package com.digiwin.mobile.mobileuibot.versionManage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.mobile.mobileuibot.dto.AppClientPageDto;
import com.digiwin.mobile.mobileuibot.dto.AppClientVo;
import com.digiwin.mobile.mobileuibot.model.db2.AppClient;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientUpdateRequest;

import java.util.List;

/**
 * <p>功能描述：客户端版本配置 服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppClientService.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 10:14
 */
public interface AppClientService {
    /**
     * 获取已发布版本，通过appId
     * @param appId 应用ID
     * @return 已发布版本
     */
    AppClient getPublishByAppId(Long appId);

    /**
     * 获取有效的版本，通过appId和version
     * @param appId 应用ID
     * @param version 版本
     * @return 有效的版本
     */
    AppClient getValidByAppIdAndVersion(Long appId, String version);

    /**
     * 获取有效的中间版本，通过appId、最新版本序列号和当前版本序列号
     * @param appId 应用ID
     * @param latestSequence 最新版本序列号
     * @param sequence 当前版本序列号
     * @return 有效的中间版本
     */
    List<AppClient> getValidMiddleVersion(Long appId, Integer latestSequence, Integer sequence);

    /**
     * 列表分页查询
     *
     * @param pageRequest 请求参数
     * @return Page<AppClientVo>
     */
    Page<AppClientVo> listPage(AppClientPageDto pageRequest);

    /**
     * 根据id查询
     *
     * @param id 版本 id
     * @return AppClientVo
     */
    AppClientVo queryById(Long id);

    /**
     * 根据id查询
     *
     * @param id 版本 id
     * @return AppClient
     */
    AppClient selectById(Long id);

    /**
     * 新增
     *
     * @param addRequest 新增参数
     * @return AppClient
     */
    AppClient add(AppClientAddRequest addRequest);

    /**
     * 修改
     *
     * @param appClient     修改的版本
     * @param updateRequest 修改参数
     */
    void update(AppClient appClient, AppClientUpdateRequest updateRequest);

    /**
     * 发布
     *
     * @param appClient     发布的版本
     * @param releaseRequest 发布参数
     */
    void release(AppClient appClient, AppClientUpdateRequest releaseRequest);

    /**
     * 取消发布
     *
     * @param appClient 取消发布的版本
     */
    void unrelease(AppClient appClient);

    /**
     * 删除
     *
     * @param id 删除的版本 id
     */
    void deleteById(Long id);
}