package com.digiwin.mobile.mobileuibot.versionManage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.mobile.mobileuibot.model.db2.AppConditionItem;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionItemRequest;

import java.util.List;
import java.util.Set;

/**
 * <p>功能描述：版更条件条件项配置 服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppConditionItemService.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 10:14
 */
public interface AppConditionItemService extends IService<AppConditionItem> {

    /**
     * 根据条件id查询条件项
     *
     * @param appConditionId 条件id
     * @return 条件项集合
     */
    List<AppConditionItem> selectByAppConditionId(Long appConditionId);

    /**
     * 根据条件id集合查询条件项
     *
     * @param appConditionIds 条件id集合
     * @return 条件项集合
     */
    List<AppConditionItem> selectByAppConditionIds(Set<Long> appConditionIds);

    /**
     * 添加条件项
     *
     * @param appConditionId 条件id
     * @param itemList 条件项集合
     */
    void add(Long appConditionId, List<AppConditionItemRequest> itemList);

    /**
     * 修改条件项
     *
     * @param appConditionId 条件id
     * @param itemList 条件项集合
     */
    void update(Long appConditionId, List<AppConditionItemRequest> itemList);

    /**
     * 删除条件项
     *
     * @param appConditionId 条件 id
     */
    void deleteByAppConditionId(Long appConditionId);
}