package com.digiwin.mobile.mobileuibot.versionManage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.mobile.mobileuibot.model.db2.AppCondition;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionPageRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionUpdateRequest;

import java.util.List;

/**
 * <p>功能描述：条件管理 服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppConditionService.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 10:14
 */
public interface AppConditionService {
    /**
     * 查询
     *
     * @param request  请求参数
     * @return List<AppCondition>
     */
    List<AppCondition> list(AppConditionPageRequest request);

    /**
     * 列表分页查询
     *
     * @param pageRequest 请求参数
     * @return Page<AppCondition>
     */
    Page<AppCondition> listPage(AppConditionPageRequest pageRequest);

    /**
     * 根据ID查询
     *
     * @param id ID
     * @return AppCondition
     */
    AppCondition selectById(Long id);

    /**
     * 新增
     *
     * @param addRequest 请求参数
     * @return AppCondition
     */
    AppCondition add(AppConditionAddRequest addRequest);

    /**
     * 修改
     *
     * @param appCondition 条件
     * @param updateRequest 请求参数
     */
    void update(AppCondition appCondition, AppConditionUpdateRequest updateRequest);

    /**
     * 删除
     *
     * @param id ID
     */
    void deleteById(Long id);
}