package com.digiwin.mobile.mobileuibot.versionManage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.mobile.mobileuibot.model.db2.AppConfig;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigPageRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigUpdateRequest;

import java.util.List;

/**
 * <p>功能描述：客户端应用配置 服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppConfigService.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 10:14
 */
public interface AppConfigService {
    /**
     * 根据appId查询
     *
     * @param code  应用Code
     * @return AppConfig
     */
    AppConfig getByCode(String code);

    /**
     * 查询
     *
     * @param request  请求参数
     * @return List<AppConfig>
     */
    List<AppConfig> list(AppConfigPageRequest request);

    /**
     * 分页查询
     *
     * @param pageRequest 请求参数
     * @return Page<AppConfig>
     */
    Page<AppConfig> listPage(AppConfigPageRequest pageRequest);

    /**
     * 根据id查询
     *
     * @param id  id
     * @return AppConfig
     */
    AppConfig selectById(Long id);

    /**
     * 添加
     *
     * @param appId  appId
     * @param addRequest  请求参数
     */
    void add(String appId, AppConfigAddRequest addRequest);

    /**
     * 根据id和code查询
     *
     * @param id  id
     * @param code  应用Code
     * @return AppConfig
     */
    AppConfig selectByIdAndCode(Long id, String code);

    /**
     * 修改
     *
     * @param appConfig  应用信息
     * @param updateRequest  请求参数
     */
    void update(AppConfig appConfig, AppConfigUpdateRequest updateRequest);

    /**
     * 删除
     *
     * @param id  id
     */
    void deleteById(Long id);

    /**
     * 修改appId
     *
     * @param id  id
     * @param appId  appId
     */
    void updateAppId(Long id, String appId);
}