package com.digiwin.mobile.mobileuibot.versionManage.service;

import com.digiwin.mobile.mobileuibot.model.db2.AppUpdate;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientUpdateRequest;

import java.util.List;
import java.util.Set;

/**
 * <p>功能描述：客户端版本更新配置 服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppUpdateService.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 10:14
 */
public interface AppUpdateService {
    /**
     * 获取指定客户端ID的版本更新配置 --- 当前有效的只有一笔数据
     *
     * @param appClientId 客户端ID
     * @return AppUpdate
     */
    AppUpdate getNotBakByAppClientId(Long appClientId);

    /**
     * 获取指定客户端ID的版本更新配置
     *
     * @param appClientIds 客户端ID集合
     * @return List<AppUpdate>
     */
    List<AppUpdate> getNotBakByAppClientIds(Set<Long> appClientIds);

    /**
     * 添加版本更新配置
     *
     * @param appClientId 客户端ID
     * @param addRequest  版本更新配置请求参数
     */
    void add(Long appClientId, AppClientAddRequest addRequest);

    /**
     * 修改版本更新配置
     *
     * @param appClientId 客户端ID
     * @param updateRequest  版本更新配置请求参数
     */
    void update(Long appClientId, AppClientUpdateRequest updateRequest);

    /**
     * 发布版本更新配置
     *
     * @param appClientId 客户端ID
     * @param publish  发布状态：0未发布，1已发布，2取消发布
     * @param releaseRequest  版本更新配置请求参数
     */
    void release(Long appClientId, Integer publish, AppClientUpdateRequest releaseRequest);

    /**
     * 删除版本更新配置
     *
     * @param appClientId 客户端ID
     */
    void deleteByAppClientId(Long appClientId);

    /**
     * 获取指定客户端ID的版本更新配置（备份）
     *
     * @param appClientId 客户端ID
     * @return List<AppUpdate>
     */
    List<AppUpdate> getBakByAppClientId(Long appClientId);
}