package com.digiwin.mobile.mobileuibot.versionManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.mobile.mobileuibot.mapper.db2.AppConditionItemMapper;
import com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum;
import com.digiwin.mobile.mobileuibot.model.db2.AppConditionItem;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionItemRequest;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppConditionItemService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>功能描述：版更条件条件项配置 服务实现类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppConditionItemServiceImpl.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 10:17
 */
@Service
public class AppConditionItemServiceImpl extends ServiceImpl<AppConditionItemMapper, AppConditionItem> implements AppConditionItemService {

    @Autowired
    private AppConditionItemMapper appConditionItemMapper;

    @Override
    public List<AppConditionItem> selectByAppConditionId(Long appConditionId) {
        if (appConditionId == null) {
            return null;
        }
        LambdaQueryWrapper<AppConditionItem> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AppConditionItem::getAppConditionId, appConditionId);
        wrapper.eq(AppConditionItem::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        // 按id升序排列 -- 后创建的条件在下面显示
        wrapper.orderByAsc(AppConditionItem::getId);
        return appConditionItemMapper.selectList(wrapper);
    }

    @Override
    public List<AppConditionItem> selectByAppConditionIds(Set<Long> appConditionIds) {
        if (appConditionIds == null || appConditionIds.isEmpty()) {
            return null;
        }
        LambdaQueryWrapper<AppConditionItem> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(AppConditionItem::getAppConditionId, appConditionIds);
        wrapper.eq(AppConditionItem::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        // 按id升序排列 -- 后创建的条件在下面显示
        wrapper.orderByAsc(AppConditionItem::getId);
        return appConditionItemMapper.selectList(wrapper);
    }

    @Override
    public void add(Long appConditionId, List<AppConditionItemRequest> itemList) {
        if (appConditionId == null || CollectionUtils.isEmpty(itemList)) {
            return;
        }
        List<AppConditionItem> list = itemList.stream().map(item ->
                        new AppConditionItem()
                                .setId(null)
                                .setAppConditionId(appConditionId)
                                .setSchema(item.getSchema())
                                .setName(item.getName())
                                .setSymbol(item.getSymbol())
                                .setComponent(item.getComponent())
                                .setContent(item.contentCovert())
                                .setVerify(item.verifyCovert())
                                .setDelFlag(DelFlagEnum.UNDELETE.getValue()))
                .collect(Collectors.toList());
        // 此方法默认逻辑：null值不会插入，而使用数据库默认值
        this.saveBatch(list);
    }

    @Override
    public void update(Long appConditionId, List<AppConditionItemRequest> itemList) {
        if (appConditionId == null) {
            return;
        }
        if (CollectionUtils.isEmpty(itemList)) {
            itemList = new ArrayList<>();
        }
        // 查询出原有数据
        LambdaQueryWrapper<AppConditionItem> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AppConditionItem::getAppConditionId, appConditionId);
        wrapper.eq(AppConditionItem::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        Set<Long> oldItemIds = appConditionItemMapper.selectList(wrapper).stream().map(AppConditionItem::getId).collect(Collectors.toSet());
        Set<Long> itemIds = itemList.stream().map(AppConditionItemRequest::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        // 删除多余的原有数据
        Set<Long> deleteIds = oldItemIds.stream().filter(id -> !itemIds.contains(id)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(deleteIds)) {
            LambdaUpdateWrapper<AppConditionItem> deleteWrapper = new LambdaUpdateWrapper<>();
            deleteWrapper.in(AppConditionItem::getId, deleteIds);
            deleteWrapper.eq(AppConditionItem::getAppConditionId, appConditionId);
            deleteWrapper.eq(AppConditionItem::getDelFlag, DelFlagEnum.UNDELETE.getValue());
            deleteWrapper.set(AppConditionItem::getDelFlag, DelFlagEnum.DELETE.getValue());
            appConditionItemMapper.update(null, deleteWrapper);
        }
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        // 更新或新增数据
        List<AppConditionItem> newItemList = itemList.stream().map(item -> {
            if (item.getId() == null) {
                return new AppConditionItem()
                        .setId(null)
                        .setAppConditionId(appConditionId)
                        .setSchema(item.getSchema())
                        .setName(item.getName())
                        .setSymbol(item.getSymbol())
                        .setComponent(item.getComponent())
                        .setContent(item.contentCovert())
                        .setVerify(item.verifyCovert())
                        .setDelFlag(DelFlagEnum.UNDELETE.getValue());
            } else {
                return new AppConditionItem()
                        .setId(item.getId())
                        .setAppConditionId(appConditionId)
                        .setSchema(item.getSchema())
                        .setName(item.getName())
                        .setSymbol(item.getSymbol())
                        .setComponent(item.getComponent())
                        .setContent(item.contentCovert())
                        .setVerify(item.verifyCovert())
                        .setDelFlag(DelFlagEnum.UNDELETE.getValue());
            }
        }).collect(Collectors.toList());
        // 此方法默认逻辑：null值不会更新，而使用数据库默认值
        this.saveOrUpdateBatch(newItemList);
    }

    @Override
    public void deleteByAppConditionId(Long appConditionId) {
        if (appConditionId == null) {
            return;
        }
        LambdaUpdateWrapper<AppConditionItem> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(AppConditionItem::getAppConditionId, appConditionId);
        wrapper.eq(AppConditionItem::getDelFlag, DelFlagEnum.UNDELETE.getValue());

        wrapper.set(AppConditionItem::getDelFlag, DelFlagEnum.DELETE.getValue());
        appConditionItemMapper.update(null, wrapper);
    }
}