package com.digiwin.mobile.mobileuibot.versionManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.mobile.mobileuibot.mapper.db2.AppConditionMapper;
import com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum;
import com.digiwin.mobile.mobileuibot.model.db2.AppCondition;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionPageRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppConditionService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>功能描述：条件管理 服务实现类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppConditionServiceImpl.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 10:17
 */
@Service
public class AppConditionServiceImpl implements AppConditionService {

    @Autowired
    private AppConditionMapper appConditionMapper;

    @Override
    public List<AppCondition> list(AppConditionPageRequest request) {
        if (request == null) {
            return null;
        }
        LambdaQueryWrapper<AppCondition> wrapper = this.buildWrapper(request);
        // id 降序排序
        wrapper.orderByDesc(AppCondition::getId);
        return appConditionMapper.selectList(wrapper);
    }

    private LambdaQueryWrapper<AppCondition> buildWrapper(AppConditionPageRequest pageRequest) {
        LambdaQueryWrapper<AppCondition> wrapper = new LambdaQueryWrapper<>();
        wrapper.like(StringUtils.isNotBlank(pageRequest.getName()), AppCondition::getName, pageRequest.getName());
        wrapper.like(StringUtils.isNotBlank(pageRequest.getDescr()), AppCondition::getDescr, pageRequest.getDescr());
        wrapper.eq(AppCondition::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        wrapper.ge(StringUtils.isNotBlank(pageRequest.getCreateTimeStart()), AppCondition::getCreateTime, pageRequest.getCreateTimeStart());
        wrapper.le(StringUtils.isNotBlank(pageRequest.getCreateTimeEnd()), AppCondition::getCreateTime, pageRequest.getCreateTimeEnd());
        wrapper.ge(StringUtils.isNotBlank(pageRequest.getUpdateTimeStart()), AppCondition::getUpdateTime, pageRequest.getUpdateTimeStart());
        wrapper.le(StringUtils.isNotBlank(pageRequest.getUpdateTimeEnd()), AppCondition::getUpdateTime, pageRequest.getUpdateTimeEnd());
        return wrapper;
    }

    @Override
    public Page<AppCondition> listPage(AppConditionPageRequest pageRequest) {
        if (pageRequest == null) {
            return new Page<>();
        }
        // 1. 创建分页对象（当前页, 每页数量）
        Page<AppCondition> page = new Page<>(pageRequest.getPageNum(), pageRequest.getPageSize());
        // 2. 构建动态查询条件
        LambdaQueryWrapper<AppCondition> wrapper = this.buildWrapper(pageRequest);
        // id 降序排序
        wrapper.orderByDesc(AppCondition::getId);
        // 3. 执行分页查询
        return appConditionMapper.selectPage(page, wrapper);
    }

    @Override
    public AppCondition selectById(Long id) {
        if (id == null) {
            return null;
        }
        LambdaQueryWrapper<AppCondition> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AppCondition::getId, id);
        wrapper.eq(AppCondition::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        return appConditionMapper.selectOne(wrapper, false);
    }

    @Override
    public AppCondition add(AppConditionAddRequest addRequest) {
        if (addRequest == null) {
            return null;
        }
        AppCondition appCondition = new AppCondition()
                .setId(null)
                .setName(addRequest.getName())
                .setDescr(addRequest.getDescr())
                .setDelFlag(DelFlagEnum.UNDELETE.getValue());
        appConditionMapper.insert(appCondition);
        return appCondition;
    }

    @Override
    public void update(AppCondition appCondition, AppConditionUpdateRequest updateRequest) {
        if (appCondition == null || updateRequest == null) {
            return;
        }
        appCondition.setName(updateRequest.getName())
                .setDescr(updateRequest.getDescr())
                // 清空创建时间和更新时间，走数据库默认值
                .clearTime();
        appConditionMapper.updateById(appCondition);
    }

    @Override
    public void deleteById(Long id) {
        if (id == null) {
            return;
        }
        LambdaUpdateWrapper<AppCondition> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(AppCondition::getId, id);
        wrapper.eq(AppCondition::getDelFlag, DelFlagEnum.UNDELETE.getValue());

        wrapper.set(AppCondition::getDelFlag, DelFlagEnum.DELETE.getValue());
        appConditionMapper.update(null, wrapper);
    }
}