package com.digiwin.mobile.mobileuibot.versionManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.mobile.mobileuibot.mapper.db2.AppConfigMapper;
import com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum;
import com.digiwin.mobile.mobileuibot.model.db2.AppConfig;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigPageRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppConfigService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>功能描述：客户端应用配置 服务实现类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppConfigServiceImpl.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 10:17
 */
@Service
public class AppConfigServiceImpl implements AppConfigService {
    @Autowired
    private AppConfigMapper appConfigMapper;

    @Override
    public AppConfig getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        LambdaQueryWrapper<AppConfig> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AppConfig::getCode, code);
        wrapper.eq(AppConfig::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        return appConfigMapper.selectOne(wrapper, false);
    }

    @Override
    public List<AppConfig> list(AppConfigPageRequest request) {
        if (request == null) {
            return null;
        }
        LambdaQueryWrapper<AppConfig> wrapper = this.buildWrapper(request);
        // id 降序排序
        wrapper.orderByDesc(AppConfig::getId);
        return appConfigMapper.selectList(wrapper);
    }

    private LambdaQueryWrapper<AppConfig> buildWrapper(AppConfigPageRequest pageRequest) {
        LambdaQueryWrapper<AppConfig> wrapper = new LambdaQueryWrapper<>();
        wrapper.like(StringUtils.isNotBlank(pageRequest.getCode()), AppConfig::getCode, pageRequest.getCode());
        wrapper.like(StringUtils.isNotBlank(pageRequest.getName()), AppConfig::getName, pageRequest.getName());
        wrapper.like(StringUtils.isNotBlank(pageRequest.getOsType()), AppConfig::getOsType, pageRequest.getOsType());
        wrapper.like(StringUtils.isNotBlank(pageRequest.getEnv()), AppConfig::getEnv, pageRequest.getEnv());
        wrapper.like(StringUtils.isNotBlank(pageRequest.getDescr()), AppConfig::getDescr, pageRequest.getDescr());
        wrapper.eq(pageRequest.getValid() != null, AppConfig::getValid, pageRequest.getValid());
        wrapper.eq(AppConfig::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        wrapper.ge(StringUtils.isNotBlank(pageRequest.getCreateTimeStart()), AppConfig::getCreateTime, pageRequest.getCreateTimeStart());
        wrapper.le(StringUtils.isNotBlank(pageRequest.getCreateTimeEnd()), AppConfig::getCreateTime, pageRequest.getCreateTimeEnd());
        wrapper.ge(StringUtils.isNotBlank(pageRequest.getUpdateTimeStart()), AppConfig::getUpdateTime, pageRequest.getUpdateTimeStart());
        wrapper.le(StringUtils.isNotBlank(pageRequest.getUpdateTimeEnd()), AppConfig::getUpdateTime, pageRequest.getUpdateTimeEnd());
        return wrapper;
    }

    @Override
    public Page<AppConfig> listPage(AppConfigPageRequest pageRequest) {
        if (pageRequest == null) {
            return new Page<>();
        }
        // 1. 创建分页对象（当前页, 每页数量）
        Page<AppConfig> page = new Page<>(pageRequest.getPageNum(), pageRequest.getPageSize());
        // 2. 构建动态查询条件
        LambdaQueryWrapper<AppConfig> wrapper = this.buildWrapper(pageRequest);
        // id 降序排序
        wrapper.orderByDesc(AppConfig::getId);
        // 3. 执行分页查询
        return appConfigMapper.selectPage(page, wrapper);
    }

    @Override
    public AppConfig selectById(Long id) {
        if (id == null) {
            return null;
        }
        LambdaQueryWrapper<AppConfig> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AppConfig::getId, id);
        wrapper.eq(AppConfig::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        return appConfigMapper.selectOne(wrapper, false);
    }

    @Override
    public void add(String appId, AppConfigAddRequest addRequest) {
        if (addRequest == null || StringUtils.isBlank(appId)) {
            return;
        }
        AppConfig appConfig = new AppConfig()
                .setId(null)
                .setCode(appId)
                .setName(addRequest.getName())
                .setOsType(addRequest.getOsType())
                .setEnv(addRequest.getEnv())
                .setDescr(addRequest.getDescr())
                .setValid(addRequest.getValid())
                .setDelFlag(DelFlagEnum.UNDELETE.getValue());
        appConfigMapper.insert(appConfig);
    }

    @Override
    public AppConfig selectByIdAndCode(Long id, String code) {
        if (id == null || StringUtils.isBlank(code)) {
            return null;
        }
        LambdaQueryWrapper<AppConfig> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AppConfig::getId, id);
        wrapper.eq(AppConfig::getCode, code);
        wrapper.eq(AppConfig::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        return appConfigMapper.selectOne(wrapper, false);
    }

    @Override
    public void update(AppConfig appConfig, AppConfigUpdateRequest updateRequest) {
        if (appConfig == null || updateRequest == null) {
            return;
        }
        // 更新
        appConfig.setName(updateRequest.getName())
                .setOsType(updateRequest.getOsType())
                .setEnv(updateRequest.getEnv())
                .setDescr(updateRequest.getDescr())
                .setValid(updateRequest.getValid())
                // 清空创建时间和更新时间，走数据库默认值
                .clearTime();
        appConfigMapper.updateById(appConfig);
    }

    @Override
    public void deleteById(Long id) {
        if (id == null) {
            return;
        }
        LambdaUpdateWrapper<AppConfig> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(AppConfig::getId, id);
        wrapper.eq(AppConfig::getDelFlag, DelFlagEnum.UNDELETE.getValue());

        wrapper.set(AppConfig::getDelFlag, DelFlagEnum.DELETE.getValue());
        appConfigMapper.update(null, wrapper);
    }

    @Override
    public void updateAppId(Long id, String appId) {
        if (id == null || StringUtils.isBlank(appId)) {
            return;
        }
        // 创建一个 LambdaUpdateWrapper 对象
        LambdaUpdateWrapper<AppConfig> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(AppConfig::getId, id);
        wrapper.eq(AppConfig::getDelFlag, DelFlagEnum.UNDELETE.getValue());

        wrapper.set(AppConfig::getCode, appId);
        appConfigMapper.update(null, wrapper);
    }
}