package com.digiwin.mobile.mobileuibot.versionManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.digiwin.mobile.mobileuibot.mapper.db2.AppUpdateMapper;
import com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum;
import com.digiwin.mobile.mobileuibot.model.db2.AppUpdate;
import com.digiwin.mobile.mobileuibot.versionManage.enums.BakFlagEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.PublishEnum;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.service.AppUpdateService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * <p>功能描述：客户端版本更新配置 服务实现类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppUpdateServiceImpl.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 10:17
 */
@Service
public class AppUpdateServiceImpl implements AppUpdateService {
    @Autowired
    private AppUpdateMapper appUpdateMapper;

    @Override
    public AppUpdate getNotBakByAppClientId(Long appClientId) {
        if (appClientId == null) {
            return null;
        }
        LambdaQueryWrapper<AppUpdate> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AppUpdate::getAppClientId, appClientId);
        wrapper.eq(AppUpdate::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(AppUpdate::getBakFlag, BakFlagEnum.UNBAK.getValue());
        return appUpdateMapper.selectOne(wrapper, false);
    }

    @Override
    public List<AppUpdate> getNotBakByAppClientIds(Set<Long> appClientIds) {
        if (CollectionUtils.isEmpty(appClientIds)) {
            return null;
        }
        LambdaQueryWrapper<AppUpdate> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(AppUpdate::getAppClientId, appClientIds);
        wrapper.eq(AppUpdate::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(AppUpdate::getBakFlag, BakFlagEnum.UNBAK.getValue());
        // 按id倒序 -- 最新的版本在前
        wrapper.orderByDesc(AppUpdate::getId);
        return appUpdateMapper.selectList(wrapper);
    }

    @Override
    public void add(Long appClientId, AppClientAddRequest addRequest) {
        if (appClientId == null || addRequest == null) {
            return;
        }
        AppUpdate appUpdate = new AppUpdate()
                .setId(null)
                .setAppClientId(appClientId)
                .setReleaseType(addRequest.getReleaseType())
                .setStrongUpdate(addRequest.getStrongUpdate())
                .setUpdateRange(addRequest.getUpdateRange())
                .setConditions(addRequest.convertConditions())
                .setBakFlag(BakFlagEnum.UNBAK.getValue())
                .setDelFlag(DelFlagEnum.UNDELETE.getValue());
        appUpdateMapper.insert(appUpdate);
    }

    @Override
    public void update(Long appClientId, AppClientUpdateRequest updateRequest) {
        if (appClientId == null || updateRequest == null) {
            return;
        }
        LambdaQueryWrapper<AppUpdate> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AppUpdate::getAppClientId, appClientId);
        wrapper.eq(AppUpdate::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(AppUpdate::getBakFlag, BakFlagEnum.UNBAK.getValue());
        AppUpdate appUpdate = appUpdateMapper.selectOne(wrapper, false);
        if (appUpdate == null) {
            return;
        }
        appUpdate.setReleaseType(updateRequest.getReleaseType())
                .setStrongUpdate(updateRequest.getStrongUpdate())
                .setUpdateRange(updateRequest.getUpdateRange())
                .setConditions(updateRequest.convertConditions())
                // 清空创建时间和更新时间，走数据库默认值
                .clearTime();
        appUpdateMapper.updateById(appUpdate);
    }

    @Override
    public void release(Long appClientId, Integer publish, AppClientUpdateRequest releaseRequest) {
        if (appClientId == null || releaseRequest == null) {
            return;
        }
        LambdaQueryWrapper<AppUpdate> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AppUpdate::getAppClientId, appClientId);
        wrapper.eq(AppUpdate::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(AppUpdate::getBakFlag, BakFlagEnum.UNBAK.getValue());
        AppUpdate appUpdate = appUpdateMapper.selectOne(wrapper, false);
        if (appUpdate == null) {
            return;
        }
        // 发布时，之前是发布状态，则当前数据设置为备份, 否则更新之前数据
        if (!PublishEnum.PUBLISH.getValue().equals(publish)) {
            // 更新之前数据
            appUpdate.setReleaseType(releaseRequest.getReleaseType())
                    .setStrongUpdate(releaseRequest.getStrongUpdate())
                    .setUpdateRange(releaseRequest.getUpdateRange())
                    .setConditions(releaseRequest.convertConditions())
                    // 清空创建时间和更新时间，走数据库默认值
                    .clearTime();
            // 防呆：无内容变更时，更新发布时间 -- 解决历史下发条件时，发布时间为null，更新为备份时会变为当前发布时间
            appUpdate.setUpdateTime(new Date());
            appUpdateMapper.updateById(appUpdate);
            return;
        }
        // 之前是发布状态，则当前数据设置为备份
        appUpdate.setBakFlag(BakFlagEnum.BAK.getValue());
        // 不可清空创建时间和更新时间，使用原有的时间，表示当时发布的时间
//                    // 清空创建时间和更新时间，走数据库默认值
//                    .clearTime();
        appUpdateMapper.updateById(appUpdate);

        // 添加发布数据
        AppUpdate addAppUpdate = new AppUpdate()
                .setId(null)
                .setAppClientId(appClientId)
                .setReleaseType(releaseRequest.getReleaseType())
                .setStrongUpdate(releaseRequest.getStrongUpdate())
                .setUpdateRange(releaseRequest.getUpdateRange())
                .setConditions(releaseRequest.convertConditions())
                .setBakFlag(BakFlagEnum.UNBAK.getValue())
                .setDelFlag(DelFlagEnum.UNDELETE.getValue());
        // 手动插入时间，解决历史下发条件时，发布时间为null，更新为备份时会变为当前发布时间
        addAppUpdate.setCreateTime(new Date());
        addAppUpdate.setUpdateTime(new Date());
        appUpdateMapper.insert(addAppUpdate);
    }

    @Override
    public void deleteByAppClientId(Long appClientId) {
        if (appClientId == null) {
            return;
        }
        // 删除appClientId下所有的数据（包括备份数据）
        LambdaUpdateWrapper<AppUpdate> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(AppUpdate::getAppClientId, appClientId);
        wrapper.eq(AppUpdate::getDelFlag, DelFlagEnum.UNDELETE.getValue());

        wrapper.set(AppUpdate::getDelFlag, DelFlagEnum.DELETE.getValue());
        appUpdateMapper.update(null, wrapper);
    }

    @Override
    public List<AppUpdate> getBakByAppClientId(Long appClientId) {
        if (appClientId == null) {
            return null;
        }
        LambdaQueryWrapper<AppUpdate> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AppUpdate::getAppClientId, appClientId);
        wrapper.eq(AppUpdate::getDelFlag, DelFlagEnum.UNDELETE.getValue());
        wrapper.eq(AppUpdate::getBakFlag, BakFlagEnum.BAK.getValue());
        // 历史下发条件记录，根据ID降序排序可查看历史下发条件。以创建时间为历史条件时间
        wrapper.orderByDesc(AppUpdate::getId);
        return appUpdateMapper.selectList(wrapper);
    }
}