package com.digiwin.mobile.mobileuibot.versionManage.utils;

/**
 * <p>功能描述：版本号比较器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: VersionComparator.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 17:17
 */
public class VersionComparator {

    /**
     * 方法二：比较两个版本号
     * @param version1   版本号1
     * @param version2   版本号2
     * @return 0:相等 1:version1>version2 -1:version1<version2
     */
    public static int compareVersions(String version1, String version2) {
        // 使用正则表达式按点号分割字符串（注意转义）
        String[] parts1 = version1.split("\\.");
        String[] parts2 = version2.split("\\.");

        // 获取最大段数，用于遍历
        int maxLength = Math.max(parts1.length, parts2.length);

        for (int i = 0; i < maxLength; i++) {
            // 将每段字符串转为整数（若某版本段数不足则视为0）
            int num1 = (i < parts1.length) ? Integer.parseInt(parts1[i]) : 0;
            int num2 = (i < parts2.length) ? Integer.parseInt(parts2[i]) : 0;

            // 比较当前段数值
            if (num1 < num2) {
                // version1 < version2
                return -1;
            } else if (num1 > num2) {
                // version1 > version2
                return 1;
            }
            // 若相等则继续比较下一段
        }

        // 所有段均相等
        return 0;
    }

    /**
     * 方法一：比较版本号
     * @param s1    版本号1
     * @param s2    版本号2
     * @return 0:相等 1:s1>s2 -1:s1<s2
     */
    @Deprecated
    public static int compareVersion(String s1, String s2) {
        int x = 0;
        int y = 0;
        int i;
        int j;

        while (x < s1.length() || y < s2.length()) {
            i = x;
            while (i < s1.length() && s1.charAt(i) != '.') {
                i++;
            }

            j = y;
            while (j < s2.length() && s2.charAt(j) != '.') {
                j++;
            }

            int s11 = i == x ? 0 : Integer.parseInt(s1.substring(x, i));
            int s22 = j == y ? 0 : Integer.parseInt(s2.substring(y, j));

            if (s11 > s22) {
                return 1;
            }

            if (s11 < s22) {
                return -1;
            }

            //如果不加1 指向的时.加一正好掠过
            x = i + 1;
            y = j + 1;
        }
        return 0;
    }

    public static void main(String[] args) {
        // 测试用例
        String v1 = "1.2.1";
        String v2 = "1.11.1";
        int result = compareVersions(v1, v2);

        System.out.println("比较结果: " + result);
        System.out.println("解释: " + v1 + " < " + v2);
    }
}