/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.agileData.controller;

import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataEchoPptQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFileParsingPptQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFileParsingPptUpdateDTO;
import com.digiwin.mobile.mobileuibot.agileData.service.IAgileDataPptService;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.ppt.EchoAgileDataFileDTO;
import com.digiwin.mobile.mobileuibot.proxy.fileparsing.DigiwinAgileDataFileParsingResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/mobile/agileData/v2/ppt"})
public class AgileDataPptController {
    @Autowired
    private IAgileDataPptService pptService;

    @PostMapping(value={"getAgileDataFile"})
    public ApiResponse getAgileDataFile(@RequestBody AgileDataEchoPptQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData((Object)this.pptService.getAgileDataFile(queryDTO));
    }

    @PostMapping(value={"saveAgileDataFile"})
    public ApiResponse saveAgileDataFile(@RequestBody EchoAgileDataFileDTO queryDTO) {
        return ApiResponse.buildOK().setData((Object)this.pptService.saveAgileDataFile(queryDTO));
    }

    @PostMapping(value={"updateAgileDataFile"})
    public ApiResponse updateAgileDataFile(@RequestBody EchoAgileDataFileDTO queryDTO) {
        return ApiResponse.buildOK().setData((Object)this.pptService.updateAgileDataFile(queryDTO));
    }

    @PostMapping(value={"deleteAgileDataFile"})
    public ApiResponse deleteAgileDataFile(@RequestBody AgileDataEchoPptQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData((Object)this.pptService.deleteAgileDataFile(queryDTO));
    }

    @PostMapping(value={"getPptFileList"})
    public ApiResponse getPptFileList(@RequestBody AgileDataFileParsingPptQueryDTO queryDTO) {
        DigiwinAgileDataFileParsingResponse result = this.pptService.getPptFileList(queryDTO);
        if (HttpStatus.OK.value() == result.getCode().intValue()) {
            return ApiResponse.buildOK().setData(result.getData());
        }
        return ApiResponse.buildError((String)result.getMsg());
    }

    @PostMapping(value={"updatePptFileName"})
    public ApiResponse updatePptFileName(@RequestBody AgileDataFileParsingPptQueryDTO queryDTO) {
        DigiwinAgileDataFileParsingResponse result = this.pptService.updatePptFileName(queryDTO);
        if (HttpStatus.OK.value() == result.getCode().intValue()) {
            return ApiResponse.buildOK().setData(result.getData());
        }
        return ApiResponse.buildError((String)result.getMsg());
    }

    @PostMapping(value={"deletePptFile"})
    public ApiResponse deletePptFile(@RequestBody AgileDataFileParsingPptQueryDTO queryDTO) {
        DigiwinAgileDataFileParsingResponse result = this.pptService.deletePptFile(queryDTO);
        if (HttpStatus.OK.value() == result.getCode().intValue()) {
            return ApiResponse.buildOK().setData(result.getData());
        }
        return ApiResponse.buildError((String)result.getMsg());
    }

    @PostMapping(value={"uploadPptFile"})
    public ApiResponse uploadPptFile(AgileDataFileParsingPptUpdateDTO queryDTO) {
        DigiwinAgileDataFileParsingResponse result = this.pptService.uploadPptFile(queryDTO);
        if (HttpStatus.OK.value() == result.getCode().intValue()) {
            return ApiResponse.buildOK().setData(result.getData());
        }
        return ApiResponse.buildError((String)result.getMsg());
    }

    @PostMapping(value={"getPDFDmcShareUrl"})
    public ApiResponse getPDFDmcShareUrl(@RequestBody AgileDataFileParsingPptQueryDTO queryDTO) {
        DigiwinAgileDataFileParsingResponse result = this.pptService.getPDFDmcShareUrl(queryDTO);
        if (HttpStatus.OK.value() == result.getCode().intValue()) {
            return ApiResponse.buildOK().setData(result.getData());
        }
        return ApiResponse.buildError((String)result.getMsg());
    }

    @PostMapping(value={"regenerateQuestion"})
    public ApiResponse regenerateQuestion(@RequestBody AgileDataEchoPptQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData((Object)this.pptService.regenerateQuestion(queryDTO));
    }

    @PostMapping(value={"generatePPT"})
    public ApiResponse generatePPT(@RequestBody AgileDataEchoPptQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData((Object)this.pptService.generatePPT(queryDTO));
    }

    @PostMapping(value={"executionParsing"})
    public ApiResponse executionParsing(@RequestBody AgileDataEchoPptQueryDTO queryDTO) {
        this.pptService.executionParsing(queryDTO);
        return ApiResponse.buildOK();
    }
}

