/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.agileData.sse.domain;

import com.digiwin.mobile.mobileuibot.agileData.sse.domain.EventData;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.SseAniaEventEnum;
import com.digiwin.mobile.mobileuibot.agileData.sse.dto.SSEBaseEvent;
import com.digiwin.mobile.mobileuibot.agileData.sse.utils.SseEmitterUtils;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class SseEmitterTimeOutCallbackComponent
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SseEmitterTimeOutCallbackComponent.class);
    private SSEBaseEvent sseBaseEvent;

    public SseEmitterTimeOutCallbackComponent(SSEBaseEvent sseBaseEvent) {
        this.sseBaseEvent = sseBaseEvent;
    }

    @Override
    public void run() {
        log.info("\u5f53\u524d\u5bf9\u8bdd\u6267\u884c\u65f6\u95f4\u8fc7\u957f\uff0c\u8fdb\u884c\u963b\u65ad\uff0c\u4fe1\u606fID:{}", (Object)this.sseBaseEvent.getId());
        this.sseBaseEvent.setIsOver(Boolean.valueOf(true));
        if (!this.sseBaseEvent.getIsScrumOver().booleanValue()) {
            this.sseBaseEvent.getScrumEventSource().cancel();
        }
        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleServiceImpl.class);
        String answer = localeService.getLanguageValue(this.sseBaseEvent.getLang(), "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u77e5\u8bc6\u5e93\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002");
        EventData eventData = new EventData(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), SseAniaEventEnum.SseEventDataTypeEnum.ANSWER.getType(), SseAniaEventEnum.EventDataMessageEnum.TEXT.getMessageType(), answer);
        SseEmitterUtils.send((SseEmitter)this.sseBaseEvent.getAniaEmitter(), (EventData)eventData);
        EventData doneData = new EventData(SseAniaEventEnum.CHAT_FAILED.getEvent(), null);
        SseEmitterUtils.send((SseEmitter)this.sseBaseEvent.getAniaEmitter(), (EventData)doneData);
    }
}

