/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.agileData.sse.listener;

import com.digiwin.mobile.mobileuibot.agileData.sse.domain.EventData;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.SseAniaEventEnum;
import com.digiwin.mobile.mobileuibot.agileData.sse.dto.SSEBaseEvent;
import com.digiwin.mobile.mobileuibot.agileData.sse.listener.SSEBaseListener;
import com.digiwin.mobile.mobileuibot.agileData.sse.service.impl.event.SSEOnEventService;
import com.digiwin.mobile.mobileuibot.agileData.sse.utils.SseEmitterUtils;
import com.digiwin.mobile.mobileuibot.agileData.sse.utils.SseEventUtils;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class SSEAdtListener
extends SSEBaseListener {
    private static final Logger log = LoggerFactory.getLogger(SSEAdtListener.class);
    private final SSEBaseEvent sseBaseEvent;

    public SSEAdtListener(SSEBaseEvent sseBaseEvent) {
        this.sseBaseEvent = sseBaseEvent;
    }

    public void onOpen(EventSource eventSource, Response response) {
        this.sseBaseEvent.setScrumEventSource(eventSource);
    }

    public void onEvent(EventSource eventSource, @Nullable String id, @Nullable String type, String data) {
        if (SseAniaEventEnum.CHAT_CREATED.getEvent().equals(type)) {
            return;
        }
        SSEOnEventService sseOnEventService = (SSEOnEventService)SpringContextHolder.getBean(SSEOnEventService.class);
        sseOnEventService.onEvent(this.sseBaseEvent, eventSource, type, data);
    }

    public void onClosed(EventSource eventSource) {
        this.sseBaseEvent.setIsScrumOver(Boolean.valueOf(true));
        if (!SseEventUtils.noScrumTerminate((List)this.sseBaseEvent.getScrumEventDatas())) {
            SseEmitterUtils.sendChatErrorComplete((SseEmitter)this.sseBaseEvent.getAniaEmitter());
            SseEmitterUtils.sendAnswerDone((SseEmitter)this.sseBaseEvent.getAniaEmitter(), (boolean)false);
            this.sseBaseEvent.getAniaEmitter().complete();
        }
    }

    public void onFailure(EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
        if (t != null) {
            log.info("ADT\u76d1\u542c\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f:{}", (Object)t.getMessage());
        }
        this.sseBaseEvent.setIsScrumOver(Boolean.valueOf(true));
        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleServiceImpl.class);
        String errorMsg = localeService.getLanguageValue(this.sseBaseEvent.getLang(), "\u5927\u6a21\u578b\u8bbf\u95ee\u5f02\u5e38\uff0c\u8bf7\u5411\u5ba2\u670d\u4eba\u5458\u53cd\u9988\u6216\u7a0d\u540e\u91cd\u8bd5\u3002");
        if (Objects.nonNull(response) && response.isSuccessful() && t instanceof IllegalStateException && t.getMessage().startsWith("ResponseBodyEmitter has already completed")) {
            return;
        }
        String answer = errorMsg;
        if (StringUtils.isNotBlank((CharSequence)answer)) {
            EventData eventData = new EventData(SseAniaEventEnum.MESSAGE_DELTA.getEvent());
            eventData.setData(new EventData.EventMessage(SseAniaEventEnum.SseEventDataTypeEnum.ANSWER.getType(), SseAniaEventEnum.EventDataMessageEnum.TEXT.getMessageType(), answer));
            SseEmitterUtils.send((SseEmitter)this.sseBaseEvent.getAniaEmitter(), (EventData)eventData);
            SseEmitterUtils.sendChatErrorComplete((SseEmitter)this.sseBaseEvent.getAniaEmitter());
            SseEmitterUtils.sendAnswerDone((SseEmitter)this.sseBaseEvent.getAniaEmitter(), (boolean)false);
            this.sseBaseEvent.getAniaEmitter().complete();
        }
    }
}

