/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.agileData.sse.service.impl;

import com.digiwin.mobile.mobileuibot.agileData.sse.api.SSEManagerService;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.AthenaMessageEvent;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.EventData;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.SseAniaEventEnum;
import com.digiwin.mobile.mobileuibot.agileData.sse.dto.AgileDadaSseChatReqDTO;
import com.digiwin.mobile.mobileuibot.agileData.sse.dto.AthenaMessageDTO;
import com.digiwin.mobile.mobileuibot.agileData.sse.dto.SSEBaseEvent;
import com.digiwin.mobile.mobileuibot.agileData.sse.listener.SSEAdtListener;
import com.digiwin.mobile.mobileuibot.agileData.sse.service.SseService;
import com.digiwin.mobile.mobileuibot.agileData.sse.service.impl.process.SSEProcessService;
import com.digiwin.mobile.mobileuibot.agileData.sse.utils.SseEmitterUtils;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class SseServiceImpl
implements SseService {
    private static final Logger log = LoggerFactory.getLogger(SseServiceImpl.class);
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Resource
    private SSEManagerService sseManagerService;
    @Resource
    private SSEProcessService sseProcessService;

    public SseEmitter sseChat(AgileDadaSseChatReqDTO queryDTO) {
        log.info("sseChat\u5165\u53c2:\n{}", (Object)JsonUtil.javaObjectToJsonString((Object)queryDTO));
        SSEBaseEvent sseBaseEvent = new SSEBaseEvent();
        SseEmitter sseEmitter = this.sseManagerService.generateSseEmitter(sseBaseEvent);
        sseBaseEvent.setAniaEmitter(sseEmitter);
        AthenaMessageEvent event = this.handleEvent(queryDTO);
        event.setSseMessage(true);
        event.setSseEmitter(sseEmitter);
        event.setAppCode(queryDTO.getAssistantId());
        Map map = (Map)JsonUtil.objectToJavaObject((Object)queryDTO, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        CompletableFuture.runAsync(() -> {
            EventData eventData = new EventData(SseAniaEventEnum.CHAT_CREATED.getEvent(), null);
            if (Objects.nonNull(sseEmitter)) {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
            }
            SSEAdtListener sseListener = new SSEAdtListener(sseBaseEvent);
            SSEBaseEvent.builderSchemaEvent((AthenaMessageEvent)event, (SSEBaseEvent)sseBaseEvent);
            this.sseProcessService.process(sseListener, event, map, sseBaseEvent);
        }, (Executor)this.threadPoolTaskExecutor);
        return sseEmitter;
    }

    public AthenaMessageEvent handleEvent(AgileDadaSseChatReqDTO req) {
        AthenaMessageEvent event = new AthenaMessageEvent();
        HashMap<String, Map> athenaMessage = new HashMap<String, Map>();
        Map extData = Optional.ofNullable(req.getMessage()).map(AgileDadaSseChatReqDTO.Message::getExtData).orElse(new HashMap());
        athenaMessage.put("msgExt", extData);
        HashMap msgBody = new HashMap();
        msgBody.put("text", extData.get("msg"));
        athenaMessage.put("msgBody", msgBody);
        AthenaMessageDTO athenaMessageDTO = (AthenaMessageDTO)JsonUtil.objectToJavaObject(athenaMessage, AthenaMessageDTO.class);
        Optional.ofNullable(req.getMessage()).ifPresent(message -> athenaMessageDTO.setMessageId(message.getMessageId()));
        athenaMessageDTO.setConversationId(req.getConversationId());
        athenaMessageDTO.setAppCode(req.getAssistantId());
        this.initEventInfo(athenaMessageDTO, event);
        this.analyzeAsaCode(athenaMessageDTO, event);
        event.setUserId(req.getUserId());
        event.setUserName(req.getUserName());
        event.setTenantId(req.getTenantId());
        event.setTenantName(req.getTenantName());
        event.setToken(req.getIamUserToken());
        event.setLang(req.getLocale());
        return event;
    }

    public void analyzeAsaCode(AthenaMessageDTO athenaMessageDTO, AthenaMessageEvent event) {
        if (Objects.isNull(athenaMessageDTO.getMsgExt())) {
            event.setAsaCode(athenaMessageDTO.getAsaCode());
            return;
        }
        String asaCode = Optional.ofNullable(athenaMessageDTO.getMsgExt().get("asaCode")).map(Object::toString).filter(StringUtils::isNotEmpty).orElseGet(() -> Optional.ofNullable(athenaMessageDTO.getMsgExt().get("assistantCode")).map(Object::toString).filter(StringUtils::isNotEmpty).orElse(athenaMessageDTO.getAsaCode()));
        event.setAsaCode(asaCode);
    }

    private void initEventInfo(AthenaMessageDTO athenaMessageDTO, AthenaMessageEvent event) {
        event.setAnswerResult(Integer.valueOf(1));
        event.setSendNana(true);
        String ptxId = TraceIdUtil.get();
        event.setPtxId(ptxId);
        event.setMsgBody(athenaMessageDTO.getMsgBody());
        event.setMsgExt(athenaMessageDTO.getMsgExt());
        event.setAskTime(LocalDateTime.now());
        Long generateSerialNo = UUIDUtil.getLongUuid();
        String question = MapUtils.getString((Map)event.getMsgBody(), (Object)"text");
        event.setQuestion(question);
        String skillType = MapUtils.getString((Map)athenaMessageDTO.getMsgExt(), (Object)"agileDataSkillType");
        event.setSkillType(skillType);
        event.setGenerateSerialNo(generateSerialNo);
        log.info("agileData_mobile_generateSerialNo:{}", (Object)generateSerialNo);
    }
}

