/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.cache;

import com.digiwin.mobile.mobileuibot.environment.EnvironmentConfig;
import com.digiwin.mobile.mobileuibot.environment.EnvironmentConfigService;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JvmCache {
    private static final Logger log = LoggerFactory.getLogger(JvmCache.class);
    private static final String ATHENA_API_SWITCH = "athena_api_switch_config";
    @Autowired
    private EnvironmentConfigService environmentConfigService;
    private LoadingCache<String, Boolean> athenaApiSwitchCache = Caffeine.newBuilder().recordStats().initialCapacity(8).maximumSize(8L).refreshAfterWrite(5L, TimeUnit.MINUTES).removalListener((key, value, cause) -> log.debug("JvmCache[cahceBuilder] key {} msg {} ", key, (Object)cause)).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);

    private Boolean generateValueByKey(String key) {
        Boolean athenaApiSwitch = Boolean.FALSE;
        List environmentConfig = this.environmentConfigService.getEnvironmentConfig();
        try {
            athenaApiSwitch = ((EnvironmentConfig)environmentConfig.get(0)).getConfig().getServerConfig().getAthenaApiSwitch();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return athenaApiSwitch;
    }

    public Boolean getAthenaApiSwitch() {
        return this.getValue(ATHENA_API_SWITCH);
    }

    public Boolean getValue(String key) {
        try {
            return (Boolean)this.athenaApiSwitchCache.get((Object)key);
        }
        catch (Exception e) {
            log.error("JvmCache[getValue] occurred error ", (Throwable)e);
            return false;
        }
    }

    static /* synthetic */ Boolean access$000(JvmCache x0, String x1) {
        return x0.generateValueByKey(x1);
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

