/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.exceptionhandle;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;

@ControllerAdvice
public class MobileUiBotExceptionHandler {
    private static final String TOKEN_EXPIRED_CN = "\u767b\u5f55\u8fc7\u671f";
    private static final String TOKEN_EXPIRED_TW = "\u767b\u9304\u904e\u671f";
    private static final String TOKEN_EXPIRED_US = "Login expired";
    private static final String RENDER_PAGE_URI = "/mobile/v1/uibot/model";
    @Autowired
    private LocaleService localeService;

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ApiResponse exceptionHandler(Exception e) {
        e.printStackTrace();
        if (null != e.getMessage() && (e.getMessage().contains(TOKEN_EXPIRED_CN) || e.getMessage().contains(TOKEN_EXPIRED_TW) || e.getMessage().contains(TOKEN_EXPIRED_US))) {
            return this.buildNoAuth(e);
        }
        return ApiResponse.buildError((String)e.getMessage(), (String)ExceptionUtils.getStackTrace((Throwable)e));
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseBody
    public ApiResponse serviceExceptionHandler(Exception e, HttpServletRequest request) {
        e.printStackTrace();
        if (null != e.getMessage() && (e.getMessage().contains(TOKEN_EXPIRED_CN) || e.getMessage().contains(TOKEN_EXPIRED_TW) || e.getMessage().contains(TOKEN_EXPIRED_US))) {
            return this.buildNoAuth(e);
        }
        return ApiResponse.buildServiceError((String)e.getMessage(), (String)ExceptionUtils.getStackTrace((Throwable)e));
    }

    public ApiResponse buildNoAuth(Exception e) {
        String message = e.getMessage().contains(":") ? e.getMessage().split(":")[1] : e.getMessage();
        ApiResponse response = ApiResponse.buildError((String)message);
        response.setCode("401");
        return response;
    }

    @ExceptionHandler(value={BindException.class, ValidationException.class, MethodArgumentNotValidException.class})
    @ResponseBody
    public ApiResponse<?> validatedExceptionHandler(Exception e) {
        if (e instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException ex = (MethodArgumentNotValidException)e;
            return ApiResponse.buildError((String)ex.getBindingResult().getAllErrors().stream().map(error -> this.localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), error.getDefaultMessage())).collect(Collectors.joining("; ")));
        }
        if (e instanceof BindException) {
            BindException ex = (BindException)e;
            return ApiResponse.buildError((String)ex.getAllErrors().stream().map(error -> this.localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), error.getDefaultMessage())).collect(Collectors.joining("; ")));
        }
        if (e instanceof ConstraintViolationException) {
            ConstraintViolationException ex = (ConstraintViolationException)e;
            return ApiResponse.buildError((String)ex.getConstraintViolations().stream().map(error -> this.localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), error.getMessage())).collect(Collectors.joining("; ")));
        }
        return ApiResponse.buildError((String)e.getMessage());
    }

    @ExceptionHandler(value={AsyncRequestTimeoutException.class})
    @ResponseStatus(value=HttpStatus.REQUEST_TIMEOUT)
    public ApiResponse handleAsyncRequestTimeoutException(AsyncRequestTimeoutException ex) {
        return ApiResponse.buildError().setData((Object)"The request timed out. Please try again later");
    }
}

