/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.config;

import com.digiwin.mobile.mobileuibot.config.request.CommonAppInterceptor;
import com.digiwin.mobile.mobileuibot.config.request.RequestContextInterceptor;
import com.digiwin.mobile.mobileuibot.config.request.TokenInterceptor;
import com.digiwin.mobile.mobileuibot.config.request.log.PerformanceLogInterceptor;
import com.digiwin.mobile.mobileuibot.config.request.log.RequestResponseLogInterceptor;
import com.digiwin.mobile.mobileuibot.config.request.mock.MockInterceptor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
public class InterceptorConfig
extends WebMvcConfigurationSupport {
    @Autowired
    private RequestResponseLogInterceptor requestResponseLogInterceptor;
    @Autowired
    private PerformanceLogInterceptor performanceLogInterceptor;
    @Autowired
    private RequestContextInterceptor requestContextInterceptor;
    @Autowired
    private CommonAppInterceptor commonAppInterceptor;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private MockInterceptor mockInterceptor;
    @Autowired
    private TokenInterceptor tokenInterceptor;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"}).addResourceLocations(new String[]{"classpath:/resources/"}).addResourceLocations(new String[]{"classpath:/static/"}).addResourceLocations(new String[]{"classpath:/public/"});
        super.addResourceHandlers(registry);
    }

    protected void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.requestResponseLogInterceptor);
        registry.addInterceptor((HandlerInterceptor)this.performanceLogInterceptor);
        registry.addInterceptor((HandlerInterceptor)this.commonAppInterceptor);
        registry.addInterceptor((HandlerInterceptor)this.requestContextInterceptor);
        registry.addInterceptor((HandlerInterceptor)this.mockInterceptor);
        registry.addInterceptor((HandlerInterceptor)this.tokenInterceptor).addPathPatterns(new String[]{"/mobile/v2/version/manage/**"}).excludePathPatterns(new String[]{"/mobile/v2/version/manage/login/**"});
        super.addInterceptors(registry);
    }

    protected void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.stream().filter(c -> c instanceof StringHttpMessageConverter).map(c -> (StringHttpMessageConverter)c).forEach(c -> c.setDefaultCharset(StandardCharsets.UTF_8));
        converters.stream().filter(c -> c instanceof MappingJackson2HttpMessageConverter).map(c -> (MappingJackson2HttpMessageConverter)c).forEach(c -> c.setObjectMapper(this.objectMapper));
    }
}

