/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.config.request;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAnalyzedToken;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.versionManage.VersionManageLoginService;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class TokenInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TokenInterceptor.class);
    public static final String PATH_PREFIX = "/mobile/v2/version/manage";
    public static final String PATH_PATTERN = "/mobile/v2/version/manage/**";
    public static final String EXCLUDE_PATH_PATTERN = "/mobile/v2/version/manage/login/**";
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestUri = AppRequestContext.getContextEntity().getRequestUri();
        String iamUserToken = AppRequestContext.getContextEntity().getIamUserToken();
        if (StringUtils.isBlank((CharSequence)iamUserToken)) {
            log.error("request uri: {} be intercepted, iamUserToken is empty", (Object)requestUri);
            this.sendTokenError(request, response);
            return false;
        }
        DigiwinIamAnalyzedToken analyzedToken = this.tokenAnalyze(iamUserToken);
        if (analyzedToken == null || analyzedToken.getId() == null) {
            log.error("request uri: {} be intercepted, iamUserToken is invalid", (Object)requestUri);
            this.sendTokenError(request, response);
            return false;
        }
        if (!this.checkUserInWhiteList(analyzedToken.getId())) {
            log.error("request uri: {} be intercepted, user is not in white list", (Object)requestUri);
            this.sendWhiteListError(request, response);
            return false;
        }
        AppRequestContext.getContextEntity().setUserId(analyzedToken.getId());
        return true;
    }

    private DigiwinIamAnalyzedToken tokenAnalyze(String iamUserToken) {
        try {
            return this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
        }
        catch (Exception e) {
            log.error("tokenAnalyze failure, throwable: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private boolean checkUserInWhiteList(String userId) {
        return VersionManageLoginService.WHITELIST.contains(userId);
    }

    private void sendTokenError(HttpServletRequest request, HttpServletResponse response) {
        try {
            request.getRequestDispatcher(request.getContextPath() + "/error/token-error").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.error("sendTokenError failure, throwable: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void sendWhiteListError(HttpServletRequest request, HttpServletResponse response) {
        try {
            request.getRequestDispatcher(request.getContextPath() + "/error/white-list-error").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            log.error("sendWhiteListError failure, throwable: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        super.afterCompletion(request, response, handler, ex);
    }
}

