/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.button;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component(value="bottomButtonBizApprovalBuilder")
public class BottomButtonBizApprovalBuilder
implements MobileComponentBuilder<BottomButtonList> {
    private static final Logger logger = LoggerFactory.getLogger(BottomButtonBizApprovalBuilder.class);

    public String getMobileComponentType() {
        return "BOTTOM_BUTTON";
    }

    public BottomButtonList build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<BottomButtonList> clazz, Object ... args) {
        String locale = apiRequest.getLocale();
        List uiBotActions = pcUiBotModel.getActions();
        if (null == uiBotActions || uiBotActions.isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        String bizDataSchema = "";
        UiBotTargetLayoutSearchResult layoutSearchResult = pcUiBotModel.searchPcTargetLayout();
        if (!layoutSearchResult.found()) {
            return BottomButtonList.createEmpty();
        }
        bizDataSchema = layoutSearchResult.getTargetUiBotLayout().getSchema();
        Object bizData = pcUiBotModel.getPageData().get((Object)bizDataSchema);
        if (bizData == null) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof List && ((List)bizData).isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        if (bizData instanceof Map && ((Map)bizData).isEmpty()) {
            return BottomButtonList.createEmpty();
        }
        BottomButtonList result = new BottomButtonList();
        HashMap<String, UiBotAction> allActionMap = new HashMap<String, UiBotAction>();
        for (UiBotAction uiBotAction : uiBotActions) {
            String serviceIdName;
            if (uiBotAction.isAgreeAction(serviceIdName = uiBotAction.getActionServiceIdName())) {
                allActionMap.put("dispatch", uiBotAction);
                continue;
            }
            if (uiBotAction.isReexecuteAction(serviceIdName)) {
                allActionMap.put("reexecute", uiBotAction);
                continue;
            }
            String targetServiceIdName = uiBotAction.getUsefulActionServiceIdName();
            if (uiBotAction.isAgreeAction(targetServiceIdName)) {
                allActionMap.put("dispatch", uiBotAction);
                continue;
            }
            if (uiBotAction.isReexecuteAction(targetServiceIdName)) {
                allActionMap.put("reexecute", uiBotAction);
                continue;
            }
            allActionMap.put(targetServiceIdName, uiBotAction);
        }
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        String bottomButtonDataSchema = pageSettingModel.getLayout().stream().filter(layout -> layout.getType().equalsIgnoreCase(this.getMobileComponentType())).findFirst().orElse(new UiBotLayout()).getSchema();
        UiBotPageData pageData = pageSettingModel.getPageData();
        JSONArray bottomButtonDataArray = (JSONArray)JSON.toJSON(pageData.get(bottomButtonDataSchema));
        String appCode = null;
        if (!ObjectUtils.isEmpty((Object[])args)) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = (DigiwinAtmcBacklogDetail)args[0];
            appCode = digiwinAtmcBacklogDetail.getAppCode();
        }
        for (int i = 0; i < bottomButtonDataArray.size(); ++i) {
            BottomButtonDigiwinAthena bottomButton;
            JSONObject bottomButtonJsonObj = bottomButtonDataArray.getJSONObject(i);
            String id = bottomButtonJsonObj.getString("id");
            if ("other".equalsIgnoreCase(id)) {
                bottomButton = BottomButtonDigiwinAthena.create((Integer)BottomButtonStyleEnum.NORMAL.getValue(), (String)"...");
            } else if ("redo".equalsIgnoreCase(id)) {
                bottomButton = BottomButtonDigiwinAthena.create((Integer)BottomButtonStyleEnum.NORMAL.getValue(), (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9000\u56de"));
            } else {
                UiBotAction pcUiBotAction = (UiBotAction)allActionMap.get(id);
                if (null == pcUiBotAction) continue;
                JSONObject buttonActionJsonObj = bottomButtonJsonObj.getJSONObject("action");
                String jumpPageId = buttonActionJsonObj.getString("jumpPageId");
                Integer buttonType = buttonActionJsonObj.getInteger("type");
                bottomButton = BottomButtonDigiwinAthena.create((UiBotAction)pcUiBotAction, (String)bizDataSchema, (Object)bizData, null, (Action)new Action(jumpPageId, LocaleUtil.getMobileTextByKey((String)locale, (String)jumpPageId), buttonType), (Integer)bottomButtonJsonObj.getInteger("iconData"), (String)id, (String)appCode);
            }
            JSONArray childrenBottomButtonArray = bottomButtonJsonObj.getJSONArray("children");
            for (int j = 0; null != childrenBottomButtonArray && j < childrenBottomButtonArray.size(); ++j) {
                JSONObject childBottomButtonJsonObj = childrenBottomButtonArray.getJSONObject(j);
                String childBottomButtonId = childBottomButtonJsonObj.getString("id");
                UiBotAction childUiBotAction = (UiBotAction)allActionMap.get(childBottomButtonId);
                if (null == childUiBotAction) continue;
                JSONObject childBottomButtonActionJsonObj = childBottomButtonJsonObj.getJSONObject("action");
                String jumpPageId = childBottomButtonActionJsonObj.getString("jumpPageId");
                String jumpPageTitle = childBottomButtonActionJsonObj.getString("jumpPageTitle");
                Integer buttonType = childBottomButtonActionJsonObj.getInteger("type");
                if (StringUtils.isBlank((String)(jumpPageTitle = LocaleUtil.getMobileTextByKey((String)locale, (String)jumpPageTitle)))) {
                    jumpPageTitle = LocaleUtil.getMobileTextByKey((String)locale, (String)jumpPageId);
                }
                Action childBottomButtonAction = new Action(jumpPageId, jumpPageTitle, buttonType);
                BottomButtonDigiwinAthena childBottomButton = childBottomButtonId.equalsIgnoreCase("reapprove") ? BottomButtonDigiwinAthena.create((UiBotAction)childUiBotAction, (String)bizDataSchema, (Object)bizData, (Map)TaskDataExtractUtil.getSignoffProgressData((UiBotPageData)pcUiBotModel.getPageData()), (Action)childBottomButtonAction, (Integer)childBottomButtonJsonObj.getInteger("iconData"), (String)childBottomButtonId, (String)appCode) : BottomButtonDigiwinAthena.create((UiBotAction)childUiBotAction, (String)bizDataSchema, (Object)bizData, null, (Action)childBottomButtonAction, (Integer)childBottomButtonJsonObj.getInteger("iconData"), (String)childBottomButtonId, (String)appCode);
                ModuleUtils.addRefreshPageId((BottomButtonDigiwinAthena)childBottomButton, (String)apiRequest.getPageId());
                bottomButton.addChildBottomButton(childBottomButton);
            }
            int isHaveChildren = bottomButton.getChildren().size();
            if (null != childrenBottomButtonArray) {
                if (isHaveChildren == 0) {
                    continue;
                }
            } else {
                ModuleUtils.addRefreshPageId((BottomButtonDigiwinAthena)bottomButton, (String)apiRequest.getPageId());
            }
            result.add((Object)bottomButton);
        }
        return result;
    }
}

