/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.chart.chartstyle;

import java.io.Serializable;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ChartColorPalette
implements Serializable {
    private static final long serialVersionUID = 2461579055960450047L;
    private static final String[] CATEGORY_PALETTE_10 = new String[]{"#7D7DE3", "#71B6FB", "#B9DFFD", "#4CD4D0", "#76D285", "#F9D978", "#FFB361", "#F77D79", "#B488E3", "#E87DE1"};
    private static final String[] CATEGORY_PALETTE_20 = new String[]{"#7D7DE3", "#B5C0FB", "#71B6FB", "#B9DFFD", "#62D4D0", "#A1E9E2", "#76D285", "#92E19C", "#F7C84F", "#F9D978", "#FAE287", "#FFA647", "#FFC175", "#F77D79", "#F9A19A", "#A57ADA", "#C09FE3", "#CEADED", "#E894E2", "#F0BEEB"};
    private static final int[] H_STEPS = ChartColorPalette.buildRange((int)0, (int)330, (int)30);
    private static final int[] S_STEPS = ChartColorPalette.buildRange((int)15, (int)65, (int)10);
    private static final int[] L_STEPS = ChartColorPalette.buildRange((int)30, (int)70, (int)10);

    public static String getColorFromCategoryPalette(int dataIndex, int totalCount) {
        if (totalCount <= 10) {
            int idx = ChartColorPalette.mod((int)dataIndex, (int)CATEGORY_PALETTE_10.length);
            return CATEGORY_PALETTE_10[idx];
        }
        if (totalCount <= 20) {
            int idx = ChartColorPalette.mod((int)dataIndex, (int)CATEGORY_PALETTE_20.length);
            return CATEGORY_PALETTE_20[idx];
        }
        return ChartColorPalette.generateAutoColor((int)dataIndex);
    }

    private static String generateAutoColor(int index) {
        int total = H_STEPS.length * S_STEPS.length * L_STEPS.length;
        int k = ChartColorPalette.mod((int)index, (int)total);
        int hIdx = k % H_STEPS.length;
        int sIdx = k / H_STEPS.length % S_STEPS.length;
        int lIdx = k / (H_STEPS.length * S_STEPS.length) % L_STEPS.length;
        double h = H_STEPS[hIdx];
        double s = (double)S_STEPS[sIdx] / 100.0;
        double l = (double)L_STEPS[lIdx] / 100.0;
        return ChartColorPalette.hslToHex((double)h, (double)s, (double)l);
    }

    private static int[] buildRange(int start, int end, int step) {
        int size = (end - start) / step + 1;
        int[] arr = new int[size];
        int v = start;
        for (int i = 0; i < size; ++i) {
            arr[i] = v;
            v += step;
        }
        return arr;
    }

    private static int mod(int a, int b) {
        int m = a % b;
        return m < 0 ? m + b : m;
    }

    private static String hslToHex(double h, double s, double l) {
        double b1;
        double g1;
        double r1;
        double c = (1.0 - Math.abs(2.0 * l - 1.0)) * s;
        double x = c * (1.0 - Math.abs(h / 60.0 % 2.0 - 1.0));
        double m = l - c / 2.0;
        if (h < 60.0) {
            r1 = c;
            g1 = x;
            b1 = 0.0;
        } else if (h < 120.0) {
            r1 = x;
            g1 = c;
            b1 = 0.0;
        } else if (h < 180.0) {
            r1 = 0.0;
            g1 = c;
            b1 = x;
        } else if (h < 240.0) {
            r1 = 0.0;
            g1 = x;
            b1 = c;
        } else if (h < 300.0) {
            r1 = x;
            g1 = 0.0;
            b1 = c;
        } else {
            r1 = c;
            g1 = 0.0;
            b1 = x;
        }
        int r = (int)Math.round((r1 + m) * 255.0);
        int g = (int)Math.round((g1 + m) * 255.0);
        int b = (int)Math.round((b1 + m) * 255.0);
        return String.format("#%02X%02X%02X", ChartColorPalette.clamp((int)r), ChartColorPalette.clamp((int)g), ChartColorPalette.clamp((int)b));
    }

    private static int clamp(int v) {
        if (v < 0) {
            return 0;
        }
        return Math.min(v, 255);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof ChartColorPalette;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "ChartColorPalette()";
    }
}

