/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.multitext;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleInitConfig;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class InputMultiText
extends BaseInputMobileComponent
implements Serializable {
    public static final String COMPONENT_TYPE = "INPUT_MULTI";
    private static final long serialVersionUID = 2299255092657306155L;
    private String text;
    private String title;
    private Boolean showShadow;
    private Integer maxLength;
    private Integer maxLines = 4;
    private Boolean useExpand = true;
    private HiddenConfig hiddenConfig = new HiddenConfig();

    @Deprecated
    public static InputMultiText create(String title, String text, Boolean enable, Boolean showShadow, String locale) {
        InputMultiText inputMultiText = new InputMultiText();
        inputMultiText.setTitle(title);
        inputMultiText.setText(StringUtils.hasLength((String)text) ? text : "-");
        inputMultiText.setEnable(enable);
        inputMultiText.setRequired(Boolean.valueOf(false));
        inputMultiText.setShowShadow(showShadow);
        InputMultiText.buildHiddenConfig((InputMultiText)inputMultiText, (String)locale);
        return inputMultiText;
    }

    public static InputMultiText create(String title, String text, Boolean enable, Boolean showShadow, String locale, String placeholder) {
        InputMultiText inputMultiText = new InputMultiText();
        inputMultiText.setTitle(title);
        inputMultiText.setText(text);
        inputMultiText.setEnable(enable);
        inputMultiText.setPlaceholder(placeholder);
        inputMultiText.setRequired(Boolean.valueOf(false));
        inputMultiText.setShowShadow(showShadow);
        InputMultiText.buildHiddenConfig((InputMultiText)inputMultiText, (String)locale);
        return inputMultiText;
    }

    public static InputMultiText create(String schema, String title, String text, Boolean enable, Boolean required, Boolean showShadow, String locale) {
        InputMultiText inputMultiText = new InputMultiText();
        inputMultiText.setSchema(schema);
        inputMultiText.setTitle(title);
        inputMultiText.setText(text);
        inputMultiText.setEnable(enable);
        inputMultiText.setRequired(required);
        inputMultiText.setShowShadow(showShadow);
        InputMultiText.buildHiddenConfig((InputMultiText)inputMultiText, (String)locale);
        inputMultiText.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        return inputMultiText;
    }

    public static InputMultiText create(String schema, String title, String text, Boolean enable, Boolean required, Boolean showShadow, String locale, Integer maxLength) {
        InputMultiText inputMultiText = new InputMultiText();
        inputMultiText.setSchema(schema);
        inputMultiText.setTitle(title);
        inputMultiText.setText(text);
        inputMultiText.setEnable(enable);
        inputMultiText.setRequired(required);
        inputMultiText.setShowShadow(showShadow);
        InputMultiText.buildHiddenConfig((InputMultiText)inputMultiText, (String)locale);
        inputMultiText.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        inputMultiText.setMaxLength(maxLength);
        return inputMultiText;
    }

    public static InputMultiText create(String title, String text, Boolean enable, Boolean showShadow, List<UiBotRule> ruleList, String schema, String locale) {
        InputMultiText inputMultiText = new InputMultiText();
        inputMultiText.setTitle(title);
        inputMultiText.setText(StringUtils.hasLength((String)text) ? text : "-");
        inputMultiText.setEnable(Boolean.valueOf(enable == null ? false : enable));
        inputMultiText.setRequired(Boolean.valueOf(false));
        if (ruleList != null && ruleList.size() > 0) {
            ruleList.stream().filter(uiBotRule -> schema.equalsIgnoreCase(uiBotRule.getSchema())).forEach(uiBotRule -> {
                if (ValidateRuleTypeEnum.REQUIRED.getType().equalsIgnoreCase(uiBotRule.getKey())) {
                    inputMultiText.setRequired(Boolean.valueOf("required".equalsIgnoreCase(uiBotRule.getKey())));
                }
            });
        }
        inputMultiText.setShowShadow(showShadow);
        InputMultiText.buildHiddenConfig((InputMultiText)inputMultiText, (String)locale);
        return inputMultiText;
    }

    public static InputMultiText create(String locale, UiBotTableColumn column, List<UiBotRule> columnRuleList, Map<String, Object> bizData, List<Rule> mobileRuleList, boolean showShadow, Integer maxLength, Map<String, Object> variableMaps, String errorMessage) {
        InputMultiText inputMultiText = new InputMultiText();
        inputMultiText.setTitle(column.getHeaderName());
        inputMultiText.setText(column.getValueForDisplay(bizData));
        inputMultiText.setSchema(column.getSchema());
        inputMultiText.setEnable(Boolean.valueOf(true));
        inputMultiText.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        if (maxLength != -1) {
            inputMultiText.setMaxLength(maxLength);
        }
        Boolean hasRule = false;
        for (Rule rule : mobileRuleList) {
            if (!rule.getSchema().equalsIgnoreCase(column.getSchema())) continue;
            RuleInitConfig initConfig = rule.getInitConfig();
            if (ObjectUtils.isNotEmpty((Object)initConfig)) {
                if (variableMaps != null && ((Boolean)variableMaps.get(initConfig.getKey())).booleanValue()) {
                    inputMultiText.setRequired(Boolean.valueOf(false));
                } else {
                    inputMultiText.setRequired(initConfig.getRequired());
                }
            }
            hasRule = true;
        }
        if (column.getMRequired() != null && !hasRule.booleanValue()) {
            inputMultiText.setRequired(column.getMRequired());
        }
        if ("report_work_description".equalsIgnoreCase(column.getSchema()) && variableMaps != null && ((Boolean)variableMaps.get("isWorkReportRequired")).booleanValue()) {
            inputMultiText.setRequired(Boolean.valueOf(false));
        }
        if ("task_info".equalsIgnoreCase(column.getPath()) && "overdue_task_report_reason".equalsIgnoreCase(column.getSchema()) && CollUtil.isNotEmpty(variableMaps) && ObjectUtil.isNotEmpty((Object)variableMaps.get("overdue_report")) && ((Boolean)variableMaps.get("overdue_report")).booleanValue()) {
            String planFinishDate = variableMaps.get("plan_finish_date").toString();
            double overdueReportDay = (Double)variableMaps.get("overdue_report_day");
            DateTime dateTime = DateUtil.parseDate((CharSequence)planFinishDate);
            DateTime offsetDay = DateUtil.offsetDay((Date)dateTime, (int)((int)overdueReportDay + 1));
            Boolean beforeNowDateTime = DateTimeUtil.isBeforeNowDateTime((String)offsetDay.toString());
            inputMultiText.setRequired(beforeNowDateTime);
        }
        InputMultiText.buildHiddenConfig((InputMultiText)inputMultiText, (String)locale);
        inputMultiText.setShowShadow(Boolean.valueOf(showShadow));
        return inputMultiText;
    }

    public static InputMultiText create(UiBotLayout uiBotFieldLayout, UiBotRule uiBotRule, String locale, Boolean showShadow, String fieldHandlingInstructionsRequired) {
        InputMultiText inputMultiText = new InputMultiText();
        if (uiBotRule != null) {
            inputMultiText.setRequired(Boolean.valueOf("required".equalsIgnoreCase(uiBotRule.getKey())));
        }
        if (uiBotFieldLayout != null) {
            inputMultiText.setTitle(uiBotFieldLayout.getHeaderName());
            if ("question_info".equalsIgnoreCase(uiBotFieldLayout.getPath())) {
                if ("scene_process_illustrate".equalsIgnoreCase(uiBotFieldLayout.getSchema())) {
                    inputMultiText.setRequired(Boolean.valueOf("Y".equalsIgnoreCase(fieldHandlingInstructionsRequired)));
                }
                inputMultiText.setMaxLength(Integer.valueOf(400));
            }
        }
        inputMultiText.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        inputMultiText.setEnable(Boolean.valueOf(true));
        inputMultiText.setShowShadow(Boolean.valueOf(true));
        if (showShadow != null) {
            inputMultiText.setShowShadow(showShadow);
        }
        InputMultiText.buildHiddenConfig((InputMultiText)inputMultiText, (String)locale);
        return inputMultiText;
    }

    public static InputMultiText create(UiBotLayout uiBotLayout, List<Rule> mobileRuleList, Map<String, Object> data, String locale, boolean showShadow, Boolean isComplete) {
        InputMultiText inputMultiText = new InputMultiText();
        String desc = (String)data.get(uiBotLayout.getSchema());
        if (StringUtils.hasLength((String)desc)) {
            inputMultiText.setText(desc);
        }
        inputMultiText.setTitle((String)uiBotLayout.getmLabelText().get(locale));
        inputMultiText.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        inputMultiText.setEnable(Boolean.valueOf(isComplete == false));
        inputMultiText.setRequired(Boolean.valueOf(isComplete == false));
        for (Rule rule : mobileRuleList) {
            if (!uiBotLayout.getSchema().equals(rule.getSchema())) continue;
            inputMultiText.setRequired(rule.getValid());
        }
        InputMultiText.buildHiddenConfig((InputMultiText)inputMultiText, (String)locale);
        inputMultiText.setShowShadow(Boolean.valueOf(showShadow));
        return inputMultiText;
    }

    public static HiddenConfig buildHiddenConfig(InputMultiText inputMultiText, String locale) {
        HiddenConfig hiddenConfig = inputMultiText.getHiddenConfig();
        hiddenConfig.setHiddenCount(Integer.valueOf(4));
        hiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6536\u8d77"));
        hiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u67e5\u770b\u66f4\u591a"));
        return hiddenConfig;
    }

    public static InputMultiText create(String locale, String schema, String headerName) {
        InputMultiText inputMultiText = new InputMultiText();
        inputMultiText.setTitle(headerName);
        inputMultiText.setSchema(schema);
        inputMultiText.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        inputMultiText.setEnable(Boolean.valueOf(false));
        inputMultiText.setShowShadow(Boolean.valueOf(false));
        return inputMultiText;
    }

    public String returnComponentType() {
        return "INPUT_MULTI";
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        if ("PWD_RTP_InquiryReply".equals(executeContext.getTmActivityId()) && "supplier_remark".equals(schema)) {
            this.maxLength = 255;
        }
        this.showShadow = true;
        String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema)).map(Object::toString).orElse(null);
        if (StringUtils.hasLength((String)value)) {
            this.text = value;
        } else if (!BooleanUtils.isTrue((Boolean)this.enable)) {
            this.text = "-";
        }
        if (ObjectUtils.isEmpty((Object)this.placeholder)) {
            this.placeholder = ModuleUtils.localeService.getLanguageValue(executeContext.getLocale(), "\u8bf7\u8f93\u5165");
        }
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        InputMultiText inputMultiText = new InputMultiText();
        inputMultiText.setComponentId(rawContent.getComponentId());
        inputMultiText.setTitle(rawContent.getLabel());
        inputMultiText.setEnable(rawContent.getEditable());
        Card.DesignerRawCard.Content.MultiTextObj multiTextObj = (Card.DesignerRawCard.Content.MultiTextObj)JsonUtil.objectToJavaObject((Object)rawContent.getSetting(), Card.DesignerRawCard.Content.MultiTextObj.class);
        if (multiTextObj != null) {
            inputMultiText.setPlaceholder(multiTextObj.getPlaceholder());
            inputMultiText.setMaxLength(multiTextObj.getMaxLength());
        }
        inputMultiText.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return inputMultiText;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public Boolean getShowShadow() {
        return this.showShadow;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getMaxLines() {
        return this.maxLines;
    }

    public Boolean getUseExpand() {
        return this.useExpand;
    }

    public HiddenConfig getHiddenConfig() {
        return this.hiddenConfig;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setShowShadow(Boolean showShadow) {
        this.showShadow = showShadow;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setMaxLines(Integer maxLines) {
        this.maxLines = maxLines;
    }

    public void setUseExpand(Boolean useExpand) {
        this.useExpand = useExpand;
    }

    public void setHiddenConfig(HiddenConfig hiddenConfig) {
        this.hiddenConfig = hiddenConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputMultiText)) {
            return false;
        }
        InputMultiText other = (InputMultiText)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$showShadow = this.getShowShadow();
        Boolean other$showShadow = other.getShowShadow();
        if (this$showShadow == null ? other$showShadow != null : !((Object)this$showShadow).equals(other$showShadow)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Integer this$maxLines = this.getMaxLines();
        Integer other$maxLines = other.getMaxLines();
        if (this$maxLines == null ? other$maxLines != null : !((Object)this$maxLines).equals(other$maxLines)) {
            return false;
        }
        Boolean this$useExpand = this.getUseExpand();
        Boolean other$useExpand = other.getUseExpand();
        if (this$useExpand == null ? other$useExpand != null : !((Object)this$useExpand).equals(other$useExpand)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        HiddenConfig this$hiddenConfig = this.getHiddenConfig();
        HiddenConfig other$hiddenConfig = other.getHiddenConfig();
        return !(this$hiddenConfig == null ? other$hiddenConfig != null : !this$hiddenConfig.equals(other$hiddenConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputMultiText;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $showShadow = this.getShowShadow();
        result = result * 59 + ($showShadow == null ? 43 : ((Object)$showShadow).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Integer $maxLines = this.getMaxLines();
        result = result * 59 + ($maxLines == null ? 43 : ((Object)$maxLines).hashCode());
        Boolean $useExpand = this.getUseExpand();
        result = result * 59 + ($useExpand == null ? 43 : ((Object)$useExpand).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        HiddenConfig $hiddenConfig = this.getHiddenConfig();
        result = result * 59 + ($hiddenConfig == null ? 43 : $hiddenConfig.hashCode());
        return result;
    }

    public String toString() {
        return "InputMultiText(text=" + this.getText() + ", title=" + this.getTitle() + ", showShadow=" + this.getShowShadow() + ", maxLength=" + this.getMaxLength() + ", maxLines=" + this.getMaxLines() + ", useExpand=" + this.getUseExpand() + ", hiddenConfig=" + this.getHiddenConfig() + ")";
    }
}

