/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.sign;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.StringUtils;

public class InputSign
extends BaseInputMobileComponent {
    private static final long serialVersionUID = 8325862362775443259L;
    public static final String COMPONENT_TYPE = "INPUT_SIGN";
    private String title;
    private String editPlaceholder;
    private Boolean timestampAppend = true;
    private String timestampFormat = "YYYY.MM.DD HH:MM:SS";
    private String signData;
    private Integer displayStyle = 0;
    private String points;
    private String pointSchema;
    private String pointSchemaPath;

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public static InputSign create(String locale, UiBotTableColumn column, List<UiBotRule> columnRuleList, Map<String, Object> bizData, List<Rule> mobileRuleList) {
        InputSign inputSign = new InputSign();
        inputSign.setTitle(column.getHeaderName());
        inputSign.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u70b9\u6b64\u533a\u57df\u7b7e\u540d"));
        inputSign.setEditPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u5728\u7a7a\u767d\u533a\u57df\u7b7e\u540d"));
        inputSign.setErrorMessage(LocaleUtil.getPhrasedMobileText((String)locale, (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u5b8c\u6210"), (String)column.getHeaderName(), (String)""));
        Optional<Rule> optRequiredRule = mobileRuleList.stream().filter(r -> RuleCategoryEnum.VALIDATE.getCategory().equalsIgnoreCase(r.getCategory()) && ValidateRuleTypeEnum.REQUIRED.getType().equalsIgnoreCase(r.getType())).findFirst();
        if (optRequiredRule.isPresent()) {
            inputSign.setRequired(Boolean.valueOf(true));
        } else {
            inputSign.setRequired(Boolean.valueOf(false));
        }
        inputSign.setSignData(String.valueOf(bizData.get(column.getSchema())));
        return inputSign;
    }

    public static InputSign create(String locale, String title, String schema, Map<String, Object> bizData, List<Rule> mobileRuleList) {
        InputSign inputSign = new InputSign();
        inputSign.setTitle(title);
        inputSign.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u70b9\u6b64\u533a\u57df\u7b7e\u540d"));
        inputSign.setEditPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u5728\u7a7a\u767d\u533a\u57df\u7b7e\u540d"));
        inputSign.setErrorMessage(LocaleUtil.getPhrasedMobileText((String)locale, (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u5b8c\u6210"), (String)title, (String)""));
        Optional<Rule> optRequiredRule = mobileRuleList.stream().filter(r -> RuleCategoryEnum.VALIDATE.getCategory().equalsIgnoreCase(r.getCategory()) && ValidateRuleTypeEnum.REQUIRED.getType().equalsIgnoreCase(r.getType())).findFirst();
        if (optRequiredRule.isPresent()) {
            inputSign.setRequired(Boolean.valueOf(true));
        } else {
            inputSign.setRequired(Boolean.valueOf(false));
        }
        inputSign.setSignData(String.valueOf(bizData.get(schema)));
        return inputSign;
    }

    public static InputSign createEmpty() {
        return new InputSign();
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        String pointValue;
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema)).map(Object::toString).orElse(null);
        if (StringUtils.hasLength((String)value)) {
            this.signData = value;
        }
        if (StringUtils.hasLength((String)(pointValue = (String)Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)this.pointSchemaPath, (String)this.pointSchema)).map(Object::toString).orElse(null)))) {
            this.points = pointValue;
        }
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        InputSign inputSign = new InputSign();
        inputSign.setComponentId(rawContent.getComponentId());
        inputSign.setTitle(rawContent.getLabel());
        inputSign.setEnable(rawContent.getEditable());
        Card.DesignerRawCard.Content.InputSignObj inputSignObj = (Card.DesignerRawCard.Content.InputSignObj)JsonUtil.objectToJavaObject((Object)rawContent.getSetting(), Card.DesignerRawCard.Content.InputSignObj.class);
        if (inputSignObj != null) {
            inputSign.setEditPlaceholder(inputSignObj.getEditPlaceholder());
            inputSign.setPlaceholder(inputSignObj.getPlaceholder());
            inputSign.setDisplayStyle(inputSignObj.getDisplayStyle());
            inputSign.setTimestampAppend(inputSignObj.getTimestampAppend());
            inputSign.setPointSchemaPath(inputSignObj.getPointSchemaPath());
            inputSign.setPointSchema(inputSignObj.getPointSchema());
        }
        inputSign.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return inputSign;
    }

    public String getTitle() {
        return this.title;
    }

    public String getEditPlaceholder() {
        return this.editPlaceholder;
    }

    public Boolean getTimestampAppend() {
        return this.timestampAppend;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public String getSignData() {
        return this.signData;
    }

    public Integer getDisplayStyle() {
        return this.displayStyle;
    }

    public String getPoints() {
        return this.points;
    }

    public String getPointSchema() {
        return this.pointSchema;
    }

    public String getPointSchemaPath() {
        return this.pointSchemaPath;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setEditPlaceholder(String editPlaceholder) {
        this.editPlaceholder = editPlaceholder;
    }

    public void setTimestampAppend(Boolean timestampAppend) {
        this.timestampAppend = timestampAppend;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat;
    }

    public void setSignData(String signData) {
        this.signData = signData;
    }

    public void setDisplayStyle(Integer displayStyle) {
        this.displayStyle = displayStyle;
    }

    public void setPoints(String points) {
        this.points = points;
    }

    public void setPointSchema(String pointSchema) {
        this.pointSchema = pointSchema;
    }

    public void setPointSchemaPath(String pointSchemaPath) {
        this.pointSchemaPath = pointSchemaPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputSign)) {
            return false;
        }
        InputSign other = (InputSign)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$timestampAppend = this.getTimestampAppend();
        Boolean other$timestampAppend = other.getTimestampAppend();
        if (this$timestampAppend == null ? other$timestampAppend != null : !((Object)this$timestampAppend).equals(other$timestampAppend)) {
            return false;
        }
        Integer this$displayStyle = this.getDisplayStyle();
        Integer other$displayStyle = other.getDisplayStyle();
        if (this$displayStyle == null ? other$displayStyle != null : !((Object)this$displayStyle).equals(other$displayStyle)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$editPlaceholder = this.getEditPlaceholder();
        String other$editPlaceholder = other.getEditPlaceholder();
        if (this$editPlaceholder == null ? other$editPlaceholder != null : !this$editPlaceholder.equals(other$editPlaceholder)) {
            return false;
        }
        String this$timestampFormat = this.getTimestampFormat();
        String other$timestampFormat = other.getTimestampFormat();
        if (this$timestampFormat == null ? other$timestampFormat != null : !this$timestampFormat.equals(other$timestampFormat)) {
            return false;
        }
        String this$signData = this.getSignData();
        String other$signData = other.getSignData();
        if (this$signData == null ? other$signData != null : !this$signData.equals(other$signData)) {
            return false;
        }
        String this$points = this.getPoints();
        String other$points = other.getPoints();
        if (this$points == null ? other$points != null : !this$points.equals(other$points)) {
            return false;
        }
        String this$pointSchema = this.getPointSchema();
        String other$pointSchema = other.getPointSchema();
        if (this$pointSchema == null ? other$pointSchema != null : !this$pointSchema.equals(other$pointSchema)) {
            return false;
        }
        String this$pointSchemaPath = this.getPointSchemaPath();
        String other$pointSchemaPath = other.getPointSchemaPath();
        return !(this$pointSchemaPath == null ? other$pointSchemaPath != null : !this$pointSchemaPath.equals(other$pointSchemaPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputSign;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $timestampAppend = this.getTimestampAppend();
        result = result * 59 + ($timestampAppend == null ? 43 : ((Object)$timestampAppend).hashCode());
        Integer $displayStyle = this.getDisplayStyle();
        result = result * 59 + ($displayStyle == null ? 43 : ((Object)$displayStyle).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $editPlaceholder = this.getEditPlaceholder();
        result = result * 59 + ($editPlaceholder == null ? 43 : $editPlaceholder.hashCode());
        String $timestampFormat = this.getTimestampFormat();
        result = result * 59 + ($timestampFormat == null ? 43 : $timestampFormat.hashCode());
        String $signData = this.getSignData();
        result = result * 59 + ($signData == null ? 43 : $signData.hashCode());
        String $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : $points.hashCode());
        String $pointSchema = this.getPointSchema();
        result = result * 59 + ($pointSchema == null ? 43 : $pointSchema.hashCode());
        String $pointSchemaPath = this.getPointSchemaPath();
        result = result * 59 + ($pointSchemaPath == null ? 43 : $pointSchemaPath.hashCode());
        return result;
    }

    public String toString() {
        return "InputSign(title=" + this.getTitle() + ", editPlaceholder=" + this.getEditPlaceholder() + ", timestampAppend=" + this.getTimestampAppend() + ", timestampFormat=" + this.getTimestampFormat() + ", signData=" + this.getSignData() + ", displayStyle=" + this.getDisplayStyle() + ", points=" + this.getPoints() + ", pointSchema=" + this.getPointSchema() + ", pointSchemaPath=" + this.getPointSchemaPath() + ")";
    }
}

