/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.singletext;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.CommonRawDataParentType;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputTypeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.StringUtils;

public class InputSingleText
extends BaseInputMobileComponent
implements Serializable {
    private static final long serialVersionUID = -2804973497917889622L;
    public static final String COMPONENT_TYPE = "INPUT_SINGLE";
    private String text;
    private String title;
    private Integer inputType = InputTypeEnum.NORMAL_INPUT.getValue();
    private String unit;
    private UiBotAction inputButton;
    private Action inputAction;
    private String actionName;
    private Integer maxLength;

    public static InputSingleText create(String title, String text) {
        InputSingleText inputSingleText = new InputSingleText();
        inputSingleText.setTitle(title);
        inputSingleText.setText(text);
        return inputSingleText;
    }

    public static InputSingleText create(String title, String text, boolean enable) {
        InputSingleText inputSingleText = new InputSingleText();
        inputSingleText.setTitle(title);
        inputSingleText.setText(text);
        inputSingleText.setEnable(Boolean.valueOf(enable));
        return inputSingleText;
    }

    public static InputSingleText create(String title, String text, String locale, String schema, List<UiBotRule> ruleList, Boolean enable) {
        InputSingleText inputSingleText = new InputSingleText();
        inputSingleText.setTitle(title);
        inputSingleText.setText(text);
        inputSingleText.setSchema(schema);
        inputSingleText.setEnable(Boolean.valueOf(enable == null ? false : enable));
        inputSingleText.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        if (ruleList != null && ruleList.size() > 0) {
            ruleList.stream().filter(uiBotRule -> schema.equalsIgnoreCase(uiBotRule.getSchema())).forEach(uiBotRule -> {
                if (ValidateRuleTypeEnum.REQUIRED.getType().equalsIgnoreCase(uiBotRule.getKey())) {
                    inputSingleText.setRequired(Boolean.valueOf("required".equalsIgnoreCase(uiBotRule.getKey())));
                }
            });
        }
        return inputSingleText;
    }

    public static InputSingleText create(UiBotLayout uiBotLayout, String locale, String text) {
        InputSingleText inputSingleText = new InputSingleText();
        inputSingleText.setSchema(uiBotLayout.getSchema());
        inputSingleText.setTitle((String)uiBotLayout.getmLabelText().get(locale));
        if (StringUtils.hasLength((String)text)) {
            inputSingleText.setText(text);
        }
        inputSingleText.setEnable(Boolean.valueOf(true));
        inputSingleText.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        inputSingleText.setRequired(Boolean.valueOf(true));
        return inputSingleText;
    }

    public static InputSingleText create(UiBotLayout uiBotLayout, String locale, String text, Integer inputType) {
        InputSingleText inputSingleText = new InputSingleText();
        inputSingleText.setSchema(uiBotLayout.getSchema());
        inputSingleText.setTitle((String)uiBotLayout.getmLabelText().get(locale));
        if (StringUtils.hasLength((String)text)) {
            inputSingleText.setText(text);
        }
        inputSingleText.setInputType(inputType);
        inputSingleText.setEnable(Boolean.valueOf(true));
        inputSingleText.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        inputSingleText.setRequired(Boolean.valueOf(true));
        return inputSingleText;
    }

    public static InputSingleText create(String locale, UiBotTableColumn column, List<UiBotRule> columnRuleList, Map<String, Object> bizData, List<Rule> mobileRuleList) {
        InputSingleText inputSingleText = new InputSingleText();
        inputSingleText.setTitle(column.getHeaderName());
        inputSingleText.setText(bizData.get(column.getSchema()) == null ? "" : String.valueOf(bizData.get(column.getSchema())));
        inputSingleText.setSchema(column.getSchema());
        inputSingleText.setEnable(Boolean.valueOf(true));
        inputSingleText.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        Optional<Rule> optRequiredRule = mobileRuleList.stream().filter(r -> RuleCategoryEnum.VALIDATE.getCategory().equalsIgnoreCase(r.getCategory()) && ValidateRuleTypeEnum.REQUIRED.getType().equalsIgnoreCase(r.getType())).findFirst();
        if (optRequiredRule.isPresent()) {
            inputSingleText.setRequired(Boolean.valueOf(true));
        } else {
            inputSingleText.setRequired(Boolean.valueOf(false));
        }
        return inputSingleText;
    }

    public static InputSingleText create(UiBotLayout uiBotFieldLayout, UiBotRule uiBotRule, String locale) {
        InputSingleText inputSingleText = new InputSingleText();
        if (uiBotFieldLayout != null) {
            inputSingleText.setTitle(uiBotFieldLayout.getHeaderName());
            inputSingleText.setSchema(uiBotFieldLayout.getSchema());
            inputSingleText.setEnable(Boolean.valueOf(true));
        }
        inputSingleText.setRequired(Boolean.valueOf(false));
        if (uiBotRule != null) {
            inputSingleText.setRequired(Boolean.valueOf("required".equalsIgnoreCase(uiBotRule.getKey())));
        }
        inputSingleText.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        return inputSingleText;
    }

    public static InputSingleText create(UiBotLayout uiBotFieldLayout, List<UiBotRule> ruleList, String locale) {
        InputSingleText inputSingleText = new InputSingleText();
        if (uiBotFieldLayout != null) {
            inputSingleText.setTitle(uiBotFieldLayout.getHeaderName());
            inputSingleText.setSchema(uiBotFieldLayout.getSchema());
            inputSingleText.setEnable(Boolean.valueOf(true));
        }
        inputSingleText.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        inputSingleText.setRequired(Boolean.valueOf(false));
        ArrayList validateRuleList = new ArrayList();
        if (ruleList != null && ruleList.size() > 0) {
            ruleList.stream().filter(uiBotRule -> uiBotFieldLayout.getSchema().equalsIgnoreCase(uiBotRule.getSchema())).forEach(uiBotRule -> {
                if (ValidateRuleTypeEnum.REQUIRED.getType().equalsIgnoreCase(uiBotRule.getKey())) {
                    inputSingleText.setRequired(Boolean.valueOf("required".equalsIgnoreCase(uiBotRule.getKey())));
                } else if (ValidateRuleTypeEnum.PATTERN.getType().equalsIgnoreCase(uiBotRule.getKey())) {
                    ValidateRule validateRule = new ValidateRule();
                    validateRule.setSchema(uiBotFieldLayout.getSchema());
                    validateRule.setParameter(uiBotRule.getParameter());
                    validateRule.setType(ValidateRuleTypeEnum.PATTERN.getType());
                    validateRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
                    validateRuleList.add(validateRule);
                    inputSingleText.setErrorMessage(uiBotRule.getErrorMessage());
                }
            });
        }
        inputSingleText.setValidateRuleList(validateRuleList);
        return inputSingleText;
    }

    public static InputSingleText create(UiBotLayout uiBotLayout, String text, Map<String, Object> data, String locale, Boolean isComplete) {
        InputSingleText inputSingleText = new InputSingleText();
        inputSingleText.setTitle((String)uiBotLayout.getmLabelText().get(locale));
        inputSingleText.setText(text);
        inputSingleText.setEnable(Boolean.valueOf(isComplete == false));
        inputSingleText.setRequired(Boolean.valueOf(false));
        if ("actualMinutes".equals(uiBotLayout.getSchema()) || "minutes".equals(uiBotLayout.getSchema())) {
            inputSingleText.setErrorMessage(LocaleUtil.getMobileTextByKey((String)locale, (String)"actualMinutesErrors"));
            ArrayList<ValidateRule> validateRules = new ArrayList<ValidateRule>(1);
            ValidateRule validateRule = new ValidateRule();
            validateRule.setSchema(uiBotLayout.getSchema());
            validateRule.setParameter("^([0-5]?[0-9]|59)$");
            validateRule.setScope("EDIT");
            validateRule.setType("pattern");
            validateRules.add(validateRule);
            inputSingleText.setValidateRuleList(validateRules);
        } else if ("actualHours".equals(uiBotLayout.getSchema()) || "hours".equals(uiBotLayout.getSchema())) {
            inputSingleText.setErrorMessage(LocaleUtil.getMobileTextByKey((String)locale, (String)"actualHoursErrors"));
            ArrayList<ValidateRule> validateRules = new ArrayList<ValidateRule>(1);
            ValidateRule validateRule = new ValidateRule();
            validateRule.setSchema(uiBotLayout.getSchema());
            validateRule.setParameter("^[0-9]*$");
            validateRule.setScope("EDIT");
            validateRule.setType("pattern");
            validateRules.add(validateRule);
            inputSingleText.setValidateRuleList(validateRules);
        } else if ("taskName".equals(uiBotLayout.getSchema())) {
            inputSingleText.setRequired(Boolean.valueOf(true));
        }
        inputSingleText.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        inputSingleText.setSchema(uiBotLayout.getSchema());
        return inputSingleText;
    }

    public static InputSingleText create(String schema, String title, Boolean required, Boolean enable, String locale, String data, Boolean hidden) {
        InputSingleText inputSingleText = new InputSingleText();
        inputSingleText.setText(data);
        inputSingleText.setSchema(schema);
        inputSingleText.setTitle(title);
        inputSingleText.setEnable(enable);
        inputSingleText.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u8f93\u5165"));
        inputSingleText.setRequired(required);
        inputSingleText.setHidden(hidden);
        return inputSingleText;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema)).map(Object::toString).orElse(null);
        if (StringUtils.hasLength((String)value)) {
            this.text = value;
        } else if (!BooleanUtils.isTrue((Boolean)this.enable)) {
            this.text = "";
        }
        if (ObjectUtils.isEmpty((Object)this.placeholder)) {
            this.placeholder = ModuleUtils.localeService.getLanguageValue(executeContext.getLocale(), "\u8bf7\u8f93\u5165");
        }
        if (ObjectUtils.isEmpty((Object)this.actionName)) {
            this.actionName = ModuleUtils.localeService.getLanguageValue(executeContext.getLocale(), "\u8bf7\u9009\u62e9");
        }
        if (ObjectUtils.isEmpty((Object)this.inputButton)) {
            return;
        }
        if (ObjectUtils.isEmpty((Object)this.inputButton.getBtnType())) {
            return;
        }
        Button button = new Button();
        button.setSubmitAction(this.inputButton);
        cmptContext.setCommonRawDataParentType(CommonRawDataParentType.ALONE_BUTTON.getValue());
        button.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.inputButton = null;
        this.inputAction = button.getAction();
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        InputSingleText inputSingleText = new InputSingleText();
        inputSingleText.setComponentId(rawContent.getComponentId());
        inputSingleText.setTitle(rawContent.getLabel());
        inputSingleText.setEnable(rawContent.getEditable());
        Card.DesignerRawCard.Content.SingleTextObj singleTextObj = (Card.DesignerRawCard.Content.SingleTextObj)JsonUtil.objectToJavaObject((Object)rawContent.getSetting(), Card.DesignerRawCard.Content.SingleTextObj.class);
        if (singleTextObj != null) {
            inputSingleText.setPlaceholder(singleTextObj.getPlaceholder());
            inputSingleText.setUnit(singleTextObj.getUnit());
        }
        inputSingleText.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return inputSingleText;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getInputType() {
        return this.inputType;
    }

    public String getUnit() {
        return this.unit;
    }

    public UiBotAction getInputButton() {
        return this.inputButton;
    }

    public Action getInputAction() {
        return this.inputAction;
    }

    public String getActionName() {
        return this.actionName;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setInputType(Integer inputType) {
        this.inputType = inputType;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setInputButton(UiBotAction inputButton) {
        this.inputButton = inputButton;
    }

    public void setInputAction(Action inputAction) {
        this.inputAction = inputAction;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputSingleText)) {
            return false;
        }
        InputSingleText other = (InputSingleText)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$inputType = this.getInputType();
        Integer other$inputType = other.getInputType();
        if (this$inputType == null ? other$inputType != null : !((Object)this$inputType).equals(other$inputType)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        UiBotAction this$inputButton = this.getInputButton();
        UiBotAction other$inputButton = other.getInputButton();
        if (this$inputButton == null ? other$inputButton != null : !this$inputButton.equals(other$inputButton)) {
            return false;
        }
        Action this$inputAction = this.getInputAction();
        Action other$inputAction = other.getInputAction();
        if (this$inputAction == null ? other$inputAction != null : !this$inputAction.equals(other$inputAction)) {
            return false;
        }
        String this$actionName = this.getActionName();
        String other$actionName = other.getActionName();
        return !(this$actionName == null ? other$actionName != null : !this$actionName.equals(other$actionName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputSingleText;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $inputType = this.getInputType();
        result = result * 59 + ($inputType == null ? 43 : ((Object)$inputType).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        UiBotAction $inputButton = this.getInputButton();
        result = result * 59 + ($inputButton == null ? 43 : $inputButton.hashCode());
        Action $inputAction = this.getInputAction();
        result = result * 59 + ($inputAction == null ? 43 : $inputAction.hashCode());
        String $actionName = this.getActionName();
        result = result * 59 + ($actionName == null ? 43 : $actionName.hashCode());
        return result;
    }

    public String toString() {
        return "InputSingleText(text=" + this.getText() + ", title=" + this.getTitle() + ", inputType=" + this.getInputType() + ", unit=" + this.getUnit() + ", inputButton=" + this.getInputButton() + ", inputAction=" + this.getInputAction() + ", actionName=" + this.getActionName() + ", maxLength=" + this.getMaxLength() + ")";
    }
}

