/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.BackFillsParseUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleItemLabel;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotOperationDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotOpenWindowDefineButtonDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotOpenWindowDefineDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.CollectionUtils;

public class InputWindowMultiSelect
extends BaseInputMobileComponent
implements Serializable {
    public static final String COMPONENT_TYPE = "WINDOW_MULTI_SELECT";
    private static final long serialVersionUID = -6556419365108443785L;
    private String title;
    private InputWindowSingleItemLabel titleLabel;
    private String url;
    private String selectId;
    private Integer style;
    private Map<String, Object> rawData;
    private List<Object> selectDetailList;
    private List<String> selectIdList;
    private List<String> textList;
    private Integer selectType;
    private final String type = this.returnComponentType();
    private Integer maxSelectNum;
    private Boolean isEdit = false;
    private String suffixText;
    private PcUiBotTmOperation openWindowDefine;
    private Boolean useHasNext;
    private Integer pageSize;
    private List<PcUiBotTmOperation> operations;
    private List<OpenWindowConfig> openWindowConfigList;

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public void setType(String type) {
    }

    public static InputWindowMultiSelect create(UiBotLayout uiBotFieldLayout, UiBotRule uiBotRule, String url, String locale, UiBotExecuteContext executeContext) {
        InputWindowMultiSelect windowMultiSelect = new InputWindowMultiSelect();
        if (uiBotFieldLayout != null) {
            windowMultiSelect.setSchema(uiBotFieldLayout.getSchema());
            windowMultiSelect.setTitle(uiBotFieldLayout.getHeaderName());
            windowMultiSelect.setRawData(uiBotFieldLayout.parseExecuteContextToRawData(uiBotFieldLayout, executeContext));
        }
        windowMultiSelect.setType(COMPONENT_TYPE);
        windowMultiSelect.setUrl(url);
        windowMultiSelect.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u9009\u62e9"));
        if (uiBotRule != null) {
            windowMultiSelect.setRequired(Boolean.valueOf("required".equals(uiBotRule.getKey())));
        }
        windowMultiSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        return windowMultiSelect;
    }

    public static InputWindowMultiSelect create(UiBotLayout uiBotFieldLayout, UiBotRule uiBotRule, List<Map<String, Object>> selectDetailList, String url, String locale, UiBotExecuteContext executeContext) {
        InputWindowMultiSelect windowMultiSelect = new InputWindowMultiSelect();
        if (uiBotFieldLayout != null) {
            String title;
            windowMultiSelect.setSchema(uiBotFieldLayout.getSchema());
            String string = title = uiBotFieldLayout.getHeaderName() == null ? uiBotFieldLayout.getPlaceholder() : uiBotFieldLayout.getHeaderName();
            if (StringUtil.isEmpty((CharSequence)title)) {
                title = uiBotFieldLayout.getOperationsTitle(uiBotFieldLayout);
            }
            windowMultiSelect.setTitle(title);
            windowMultiSelect.setRawData(uiBotFieldLayout.parseExecuteContextToRawData(uiBotFieldLayout, executeContext));
        }
        windowMultiSelect.setType(COMPONENT_TYPE);
        windowMultiSelect.setUrl(url);
        windowMultiSelect.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u9009\u62e9"));
        if (uiBotRule != null) {
            windowMultiSelect.setRequired(Boolean.valueOf("required".equals(uiBotRule.getKey())));
        }
        if (selectDetailList != null && selectDetailList.size() > 0) {
            ArrayList<String> selectIds = new ArrayList<String>(selectDetailList.size());
            for (Map<String, Object> selectDetail : selectDetailList) {
                if (!CollectionUtils.isEmpty((Collection)uiBotFieldLayout.getRelationSchemas())) {
                    selectIds.add((String)selectDetail.get(uiBotFieldLayout.getRelationSchemas().get(0)));
                    continue;
                }
                selectIds.add((String)selectDetail.get(uiBotFieldLayout.getSchema()));
            }
            windowMultiSelect.setSelectIdList(selectIds);
            windowMultiSelect.setSelectDetailList(Collections.singletonList(selectDetailList));
        }
        windowMultiSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        return windowMultiSelect;
    }

    public static InputWindowMultiSelect create(UiBotLayout uiBotLayout, String url, String locale, Integer selectType) {
        InputWindowMultiSelect inputWindowMultiSelect = new InputWindowMultiSelect();
        inputWindowMultiSelect.setSchema(uiBotLayout.getSchema());
        inputWindowMultiSelect.setUrl(url);
        inputWindowMultiSelect.setTitle((String)uiBotLayout.getmLabelText().get(locale));
        HashMap rawData = new HashMap();
        inputWindowMultiSelect.setRawData(rawData);
        inputWindowMultiSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        inputWindowMultiSelect.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u9009\u62e9"));
        inputWindowMultiSelect.setType(COMPONENT_TYPE);
        inputWindowMultiSelect.setHidden(Boolean.valueOf(true));
        inputWindowMultiSelect.setEnable(Boolean.valueOf(true));
        inputWindowMultiSelect.setRequired(Boolean.valueOf(true));
        inputWindowMultiSelect.setSelectType(selectType);
        return inputWindowMultiSelect;
    }

    public static InputWindowMultiSelect create(UiBotLayout uiBotLayout, String url, Map<String, Object> rawData, String locale, Integer selectType, Integer style, Boolean hidden, Boolean required, LocaleService localeService) {
        InputWindowMultiSelect inputWindowMultiSelect = new InputWindowMultiSelect();
        inputWindowMultiSelect.setSchema(uiBotLayout.getSchema());
        inputWindowMultiSelect.setUrl(url);
        inputWindowMultiSelect.setTitle(localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        inputWindowMultiSelect.setRawData(rawData);
        inputWindowMultiSelect.setStyle(style);
        inputWindowMultiSelect.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u9009\u62e9"));
        inputWindowMultiSelect.setHidden(hidden);
        inputWindowMultiSelect.setEnable(Boolean.valueOf(true));
        inputWindowMultiSelect.setRequired(required);
        inputWindowMultiSelect.setSelectType(selectType);
        return inputWindowMultiSelect;
    }

    public static InputWindowMultiSelect create(UiBotLayout uiBotLayout, String url, Map<String, Object> rawData, String locale, Integer selectType, Integer style, Boolean hidden, Boolean required, LocaleService localeService, Boolean enable) {
        InputWindowMultiSelect inputWindowMultiSelect = new InputWindowMultiSelect();
        inputWindowMultiSelect.setSchema(uiBotLayout.getSchema());
        inputWindowMultiSelect.setUrl(url);
        inputWindowMultiSelect.setTitle(localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        inputWindowMultiSelect.setRawData(rawData);
        inputWindowMultiSelect.setStyle(style);
        inputWindowMultiSelect.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u9009\u62e9"));
        inputWindowMultiSelect.setHidden(hidden);
        inputWindowMultiSelect.setEnable(enable);
        inputWindowMultiSelect.setRequired(required);
        inputWindowMultiSelect.setSelectType(selectType);
        return inputWindowMultiSelect;
    }

    public static InputWindowMultiSelect create(UiBotLayout uiBotLayout, Boolean required, String url, UiBotModel pcUiBotModel, Boolean enable, Map<String, Object> bizData, ApiRequest request, String locale) {
        InputWindowMultiSelect windowSingleSelect = new InputWindowMultiSelect();
        UiBotExecuteContext executeContext = pcUiBotModel.getExecuteContext();
        if (uiBotLayout != null) {
            List columnList;
            windowSingleSelect.setSchema(uiBotLayout.getSchema());
            windowSingleSelect.setTitle(uiBotLayout.getLabel());
            List columnDefs1 = uiBotLayout.getColumnDefs();
            HashMap<String, Object> rawData = new HashMap<String, Object>(8);
            if (CollUtil.isNotEmpty((Collection)columnDefs1) && CollUtil.isNotEmpty(columnList = columnDefs1.stream().filter(a -> LocaleUtil.getMobileTextByKey((String)locale, (String)"\u54c1\u53f7").equals(a.getHeaderName())).collect(Collectors.toList()))) {
                for (UiBotTableColumnDefinition uiBotTableColumnDefinition : columnList) {
                    List columns = uiBotTableColumnDefinition.getColumns();
                    if (!CollUtil.isNotEmpty((Collection)columns)) continue;
                    for (UiBotTableColumn column : columns) {
                        if (!CollUtil.isNotEmpty((Collection)column.getOperations())) continue;
                        JSONObject operation = column.getOperations().getJSONObject(0);
                        rawData.put("dataSourceSet", operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getJSONObject("dataSourceSet"));
                        rawData.put("defaultShow", operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getBooleanValue("defaultShow"));
                        JSONObject executeContextObj = operation.getJSONObject("openWindowDefine").getJSONObject("allAction").getJSONObject("executeContext");
                        if (executeContextObj != null) {
                            rawData.put("executeContext", executeContextObj);
                        } else {
                            rawData.put("executeContext", executeContext);
                        }
                        rawData.put("multipleSelect", operation.getJSONObject("openWindowDefine").getBooleanValue("multipleSelect"));
                        rawData.put("selectedFirstRow", operation.getJSONObject("openWindowDefine").getBooleanValue("selectedFirstRow"));
                        rawData.put("queryTagSuffix", "DIALOG");
                        rawData.put("buttons", operation.getJSONObject("openWindowDefine").getJSONArray("buttons"));
                        if (bizData == null) continue;
                        rawData.put("parameter", bizData);
                    }
                }
            }
            windowSingleSelect.setRawData(rawData);
        }
        windowSingleSelect.setRequired(required);
        windowSingleSelect.setType(COMPONENT_TYPE);
        windowSingleSelect.setUrl(url);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey((String)request.getLocale(), (String)"\u8bf7\u9009\u62e9"));
        windowSingleSelect.setEnable(Boolean.valueOf(enable != null && enable != false));
        return windowSingleSelect;
    }

    public static InputWindowMultiSelect create(UiBotLayout uiBotLayout, String url, Map<String, Object> rawData, String locale, Integer selectType, Integer style, Boolean hidden, Boolean required, LocaleService localeService, Integer maxSelectNum, String selectId) {
        InputWindowMultiSelect inputWindowMultiSelect = new InputWindowMultiSelect();
        inputWindowMultiSelect.setSchema(uiBotLayout.getSchema());
        inputWindowMultiSelect.setUrl(url);
        inputWindowMultiSelect.setTitle(localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        inputWindowMultiSelect.setRawData(rawData);
        inputWindowMultiSelect.setStyle(style);
        inputWindowMultiSelect.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u9009\u62e9"));
        inputWindowMultiSelect.setHidden(hidden);
        inputWindowMultiSelect.setEnable(Boolean.valueOf(true));
        inputWindowMultiSelect.setRequired(required);
        inputWindowMultiSelect.setSelectType(selectType);
        inputWindowMultiSelect.setMaxSelectNum(maxSelectNum);
        inputWindowMultiSelect.setSelectIdList(Arrays.asList(selectId.split(";")));
        return inputWindowMultiSelect;
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.url = AppContext.getBaseUrl() + "/data/entry/window/data/list";
        this.openWindowConfigList = this.buildOpenWindowConfigList(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData, this.openWindowDefine, this.operations);
        if (!CollectionUtils.isEmpty((Collection)this.openWindowConfigList)) {
            OpenWindowConfig openWindowConfig = (OpenWindowConfig)this.openWindowConfigList.get(0);
            if (this.openWindowConfigList.size() == 1) {
                openWindowConfig.setCondition("true");
            }
            this.selectDetailList = openWindowConfig.getSelectDetailList();
            this.selectIdList = openWindowConfig.getSelectIdList();
            this.rawData = openWindowConfig.getRawData();
            this.useHasNext = openWindowConfig.getUseHasNext();
            this.pageSize = openWindowConfig.getPageSize();
        }
        this.openWindowDefine = null;
        this.operations = null;
        this.specialHandle(executeContext, schema);
        if (ObjectUtils.isEmpty((Object)this.placeholder)) {
            this.placeholder = ModuleUtils.localeService.getLanguageValue(executeContext.getLocale(), "\u8bf7\u9009\u62e9");
        }
    }

    private void specialHandle(PcUiBotExecuteContext executeContext, String schema) {
        if ("questionIdentify".equalsIgnoreCase(executeContext.getTmActivityId()) && "identify_notice_person_info".equals(schema)) {
            this.selectType = 1;
        }
    }

    private List<OpenWindowConfig> buildOpenWindowConfigList(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData, PcUiBotTmOperation openWindowDefine, List<PcUiBotTmOperation> operations) {
        ArrayList<OpenWindowConfig> openWindowConfigList = new ArrayList<OpenWindowConfig>();
        List tmOperations = this.buildTmOperations(openWindowDefine, operations);
        if (CollectionUtils.isEmpty((Collection)tmOperations)) {
            return openWindowConfigList;
        }
        TmPageOperationService tmPageOperationService = (TmPageOperationService)SpringContextHolder.getBean(TmPageOperationService.class);
        for (PcUiBotTmOperation tmOperation : tmOperations) {
            openWindowConfigList.add(this.buildOpenWindowConfig(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData, tmOperation, tmPageOperationService));
        }
        return openWindowConfigList;
    }

    private List<PcUiBotTmOperation> buildTmOperations(PcUiBotTmOperation openWindowDefine, List<PcUiBotTmOperation> operations) {
        if (!CollectionUtils.isEmpty(operations)) {
            operations.forEach(operation -> operation.setOperate("openwindow"));
            return operations;
        }
        if (openWindowDefine == null) {
            return new ArrayList<PcUiBotTmOperation>();
        }
        PcUiBotTmOperation tmOperation = new PcUiBotTmOperation();
        tmOperation.setOperate("openwindow");
        tmOperation.setOpenWindowDefine(openWindowDefine.getOpenWindowDefine());
        return Lists.newArrayList((Object[])new PcUiBotTmOperation[]{tmOperation});
    }

    private OpenWindowConfig buildOpenWindowConfig(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData, PcUiBotTmOperation tmOperation, TmPageOperationService tmPageOperationService) {
        PcUiBotOperationDTO operationDTO = new PcUiBotOperationDTO();
        tmPageOperationService.parseOpenWindow(executeContext, Boolean.valueOf(false), tmOperation, operationDTO);
        PcUiBotOpenWindowDefineDTO openWindowDefine = operationDTO.getOpenWindowDefine();
        OpenWindowConfig openWindowConfig = new OpenWindowConfig().setName(openWindowDefine.getTitle()).setCondition(operationDTO.getOpenWindowConditional());
        if (openWindowDefine.getAllAction() == null) {
            return openWindowConfig;
        }
        HashMap<String, Object> rawData = new HashMap<String, Object>();
        rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());
        rawData.put("dataSourceSet", openWindowDefine.getAllAction().getDataSourceSet());
        rawData.put("dataKeys", openWindowDefine.getAllAction().getDataSourceSet().getDataKeys());
        rawData.put("defaultShow", openWindowDefine.getAllAction().isDefaultShow());
        rawData.put("executeContext", openWindowDefine.getAllAction().getExecuteContext());
        rawData.put("multipleSelect", openWindowDefine.getMultipleSelect());
        rawData.put("selectedFirstRow", openWindowDefine.getSelectedFirstRow());
        rawData.put("queryTagSuffix", "DIALOG");
        rawData.put("pageInfo", openWindowDefine.getAllAction().getPageInfo());
        rawData.put("roleAttention", openWindowDefine.getRoleAttention());
        rawData.put("drilDownButton", InputWindowSingleSelect.buildDrilDownButton((UiBotAction)openWindowDefine.getMobileDrilDown(), (ComponentContext)cmptContext, (String)mobilePath, (String)schema, data, (PcUiBotExecuteContext)executeContext, (MobilePageRawData)mobilePageRawData));
        rawData.put("mobileSortInfo", openWindowDefine.getMobileSortInfo());
        rawData.put("schema", schema);
        rawData.put("useHasNext", Optional.ofNullable(openWindowDefine.getUseHasNext()).orElse(false));
        rawData.put("buttons", openWindowDefine.getButtons());
        rawData.put("parameter", data);
        this.buildDefaultSelect(openWindowConfig, data, mobilePath, schema, openWindowDefine.getAllAction().getDataSourceSet().getDataKeys(), openWindowDefine.getButtons());
        openWindowConfig.setRawData(rawData).setUseHasNext(Optional.ofNullable(openWindowDefine.getUseHasNext()).orElse(false)).setPageSize(Integer.valueOf(50));
        return openWindowConfig;
    }

    private void buildDefaultSelect(OpenWindowConfig openWindowConfig, Map<String, Object> data, String mobilePath, String schema, List<String> dataKeys, List<PcUiBotOpenWindowDefineButtonDTO> buttons) {
        Object o = UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema);
        if (o == null) {
            return;
        }
        if (!(o instanceof List)) {
            return;
        }
        openWindowConfig.setSelectDetailList((List)o);
        List list = (List)o;
        if (CollectionUtils.isEmpty(dataKeys)) {
            return;
        }
        if (CollectionUtils.isEmpty(buttons)) {
            return;
        }
        Map backFills = BackFillsParseUtil.getBackFillMap((List)((List)JsonUtil.objectToJavaObject(buttons, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)));
        if (backFills.isEmpty()) {
            return;
        }
        ArrayList<String> selectIds = new ArrayList<String>(list.size());
        for (Map item : list) {
            StringBuilder sb = new StringBuilder();
            dataKeys.forEach(dataKey -> sb.append(StringUtil.valueOf(item.get(backFills.get(dataKey)))).append("&&&&"));
            selectIds.add(sb.substring(0, sb.length() - "&&&&".length()).trim());
        }
        openWindowConfig.setSelectIdList(selectIds);
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        InputWindowMultiSelect inputWindowMultiSelect = new InputWindowMultiSelect();
        inputWindowMultiSelect.setComponentId(rawContent.getComponentId());
        inputWindowMultiSelect.setTitle(rawContent.getLabel());
        inputWindowMultiSelect.setEnable(rawContent.getEditable());
        Card.DesignerRawCard.Content.OpenWindowSelectObj openWindowSelectObj = (Card.DesignerRawCard.Content.OpenWindowSelectObj)JsonUtil.objectToJavaObject((Object)rawContent.getSetting(), Card.DesignerRawCard.Content.OpenWindowSelectObj.class);
        if (openWindowSelectObj != null) {
            inputWindowMultiSelect.setPlaceholder(openWindowSelectObj.getPlaceholder());
            inputWindowMultiSelect.setIsEdit(openWindowSelectObj.getIsEdit());
            inputWindowMultiSelect.setStyle(openWindowSelectObj.getStyle());
            inputWindowMultiSelect.setOperations(openWindowSelectObj.getOperations());
        }
        if (!CollectionUtils.isEmpty((Collection)rawContent.getSubContent())) {
            Card.DesignerRawCard.Content subContent = (Card.DesignerRawCard.Content)rawContent.getSubContent().get(0);
            String displayValue = Card.getDisplayValue((Card.DesignerRawCard.Content)subContent, (String)StringUtil.valueOf((Object)data.get(subContent.getSchema())));
            inputWindowMultiSelect.setSuffixText(displayValue);
        }
        inputWindowMultiSelect.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return inputWindowMultiSelect;
    }

    public String getTitle() {
        return this.title;
    }

    public InputWindowSingleItemLabel getTitleLabel() {
        return this.titleLabel;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public Integer getStyle() {
        return this.style;
    }

    public Map<String, Object> getRawData() {
        return this.rawData;
    }

    public List<Object> getSelectDetailList() {
        return this.selectDetailList;
    }

    public List<String> getSelectIdList() {
        return this.selectIdList;
    }

    public List<String> getTextList() {
        return this.textList;
    }

    public Integer getSelectType() {
        return this.selectType;
    }

    public String getType() {
        return this.type;
    }

    public Integer getMaxSelectNum() {
        return this.maxSelectNum;
    }

    public Boolean getIsEdit() {
        return this.isEdit;
    }

    public String getSuffixText() {
        return this.suffixText;
    }

    public PcUiBotTmOperation getOpenWindowDefine() {
        return this.openWindowDefine;
    }

    public Boolean getUseHasNext() {
        return this.useHasNext;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public List<PcUiBotTmOperation> getOperations() {
        return this.operations;
    }

    public List<OpenWindowConfig> getOpenWindowConfigList() {
        return this.openWindowConfigList;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitleLabel(InputWindowSingleItemLabel titleLabel) {
        this.titleLabel = titleLabel;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSelectId(String selectId) {
        this.selectId = selectId;
    }

    public void setStyle(Integer style) {
        this.style = style;
    }

    public void setRawData(Map<String, Object> rawData) {
        this.rawData = rawData;
    }

    public void setSelectDetailList(List<Object> selectDetailList) {
        this.selectDetailList = selectDetailList;
    }

    public void setSelectIdList(List<String> selectIdList) {
        this.selectIdList = selectIdList;
    }

    public void setTextList(List<String> textList) {
        this.textList = textList;
    }

    public void setSelectType(Integer selectType) {
        this.selectType = selectType;
    }

    public void setMaxSelectNum(Integer maxSelectNum) {
        this.maxSelectNum = maxSelectNum;
    }

    public void setIsEdit(Boolean isEdit) {
        this.isEdit = isEdit;
    }

    public void setSuffixText(String suffixText) {
        this.suffixText = suffixText;
    }

    public void setOpenWindowDefine(PcUiBotTmOperation openWindowDefine) {
        this.openWindowDefine = openWindowDefine;
    }

    public void setUseHasNext(Boolean useHasNext) {
        this.useHasNext = useHasNext;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setOperations(List<PcUiBotTmOperation> operations) {
        this.operations = operations;
    }

    public void setOpenWindowConfigList(List<OpenWindowConfig> openWindowConfigList) {
        this.openWindowConfigList = openWindowConfigList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputWindowMultiSelect)) {
            return false;
        }
        InputWindowMultiSelect other = (InputWindowMultiSelect)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$style = this.getStyle();
        Integer other$style = other.getStyle();
        if (this$style == null ? other$style != null : !((Object)this$style).equals(other$style)) {
            return false;
        }
        Integer this$selectType = this.getSelectType();
        Integer other$selectType = other.getSelectType();
        if (this$selectType == null ? other$selectType != null : !((Object)this$selectType).equals(other$selectType)) {
            return false;
        }
        Integer this$maxSelectNum = this.getMaxSelectNum();
        Integer other$maxSelectNum = other.getMaxSelectNum();
        if (this$maxSelectNum == null ? other$maxSelectNum != null : !((Object)this$maxSelectNum).equals(other$maxSelectNum)) {
            return false;
        }
        Boolean this$isEdit = this.getIsEdit();
        Boolean other$isEdit = other.getIsEdit();
        if (this$isEdit == null ? other$isEdit != null : !((Object)this$isEdit).equals(other$isEdit)) {
            return false;
        }
        Boolean this$useHasNext = this.getUseHasNext();
        Boolean other$useHasNext = other.getUseHasNext();
        if (this$useHasNext == null ? other$useHasNext != null : !((Object)this$useHasNext).equals(other$useHasNext)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        InputWindowSingleItemLabel this$titleLabel = this.getTitleLabel();
        InputWindowSingleItemLabel other$titleLabel = other.getTitleLabel();
        if (this$titleLabel == null ? other$titleLabel != null : !this$titleLabel.equals(other$titleLabel)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$selectId = this.getSelectId();
        String other$selectId = other.getSelectId();
        if (this$selectId == null ? other$selectId != null : !this$selectId.equals(other$selectId)) {
            return false;
        }
        Map this$rawData = this.getRawData();
        Map other$rawData = other.getRawData();
        if (this$rawData == null ? other$rawData != null : !((Object)this$rawData).equals(other$rawData)) {
            return false;
        }
        List this$selectDetailList = this.getSelectDetailList();
        List other$selectDetailList = other.getSelectDetailList();
        if (this$selectDetailList == null ? other$selectDetailList != null : !((Object)this$selectDetailList).equals(other$selectDetailList)) {
            return false;
        }
        List this$selectIdList = this.getSelectIdList();
        List other$selectIdList = other.getSelectIdList();
        if (this$selectIdList == null ? other$selectIdList != null : !((Object)this$selectIdList).equals(other$selectIdList)) {
            return false;
        }
        List this$textList = this.getTextList();
        List other$textList = other.getTextList();
        if (this$textList == null ? other$textList != null : !((Object)this$textList).equals(other$textList)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$suffixText = this.getSuffixText();
        String other$suffixText = other.getSuffixText();
        if (this$suffixText == null ? other$suffixText != null : !this$suffixText.equals(other$suffixText)) {
            return false;
        }
        PcUiBotTmOperation this$openWindowDefine = this.getOpenWindowDefine();
        PcUiBotTmOperation other$openWindowDefine = other.getOpenWindowDefine();
        if (this$openWindowDefine == null ? other$openWindowDefine != null : !this$openWindowDefine.equals(other$openWindowDefine)) {
            return false;
        }
        List this$operations = this.getOperations();
        List other$operations = other.getOperations();
        if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
            return false;
        }
        List this$openWindowConfigList = this.getOpenWindowConfigList();
        List other$openWindowConfigList = other.getOpenWindowConfigList();
        return !(this$openWindowConfigList == null ? other$openWindowConfigList != null : !((Object)this$openWindowConfigList).equals(other$openWindowConfigList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputWindowMultiSelect;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        Integer $selectType = this.getSelectType();
        result = result * 59 + ($selectType == null ? 43 : ((Object)$selectType).hashCode());
        Integer $maxSelectNum = this.getMaxSelectNum();
        result = result * 59 + ($maxSelectNum == null ? 43 : ((Object)$maxSelectNum).hashCode());
        Boolean $isEdit = this.getIsEdit();
        result = result * 59 + ($isEdit == null ? 43 : ((Object)$isEdit).hashCode());
        Boolean $useHasNext = this.getUseHasNext();
        result = result * 59 + ($useHasNext == null ? 43 : ((Object)$useHasNext).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        InputWindowSingleItemLabel $titleLabel = this.getTitleLabel();
        result = result * 59 + ($titleLabel == null ? 43 : $titleLabel.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $selectId = this.getSelectId();
        result = result * 59 + ($selectId == null ? 43 : $selectId.hashCode());
        Map $rawData = this.getRawData();
        result = result * 59 + ($rawData == null ? 43 : ((Object)$rawData).hashCode());
        List $selectDetailList = this.getSelectDetailList();
        result = result * 59 + ($selectDetailList == null ? 43 : ((Object)$selectDetailList).hashCode());
        List $selectIdList = this.getSelectIdList();
        result = result * 59 + ($selectIdList == null ? 43 : ((Object)$selectIdList).hashCode());
        List $textList = this.getTextList();
        result = result * 59 + ($textList == null ? 43 : ((Object)$textList).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $suffixText = this.getSuffixText();
        result = result * 59 + ($suffixText == null ? 43 : $suffixText.hashCode());
        PcUiBotTmOperation $openWindowDefine = this.getOpenWindowDefine();
        result = result * 59 + ($openWindowDefine == null ? 43 : $openWindowDefine.hashCode());
        List $operations = this.getOperations();
        result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
        List $openWindowConfigList = this.getOpenWindowConfigList();
        result = result * 59 + ($openWindowConfigList == null ? 43 : ((Object)$openWindowConfigList).hashCode());
        return result;
    }

    public String toString() {
        return "InputWindowMultiSelect(title=" + this.getTitle() + ", titleLabel=" + this.getTitleLabel() + ", url=" + this.getUrl() + ", selectId=" + this.getSelectId() + ", style=" + this.getStyle() + ", rawData=" + this.getRawData() + ", selectDetailList=" + this.getSelectDetailList() + ", selectIdList=" + this.getSelectIdList() + ", textList=" + this.getTextList() + ", selectType=" + this.getSelectType() + ", type=" + this.getType() + ", maxSelectNum=" + this.getMaxSelectNum() + ", isEdit=" + this.getIsEdit() + ", suffixText=" + this.getSuffixText() + ", openWindowDefine=" + this.getOpenWindowDefine() + ", useHasNext=" + this.getUseHasNext() + ", pageSize=" + this.getPageSize() + ", operations=" + this.getOperations() + ", openWindowConfigList=" + this.getOpenWindowConfigList() + ")";
    }
}

