/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.layout.headbodycontainer;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.container.Container;
import com.digiwin.mobile.mobileuibot.core.component.layout.container.ContainerContent;
import com.digiwin.mobile.mobileuibot.core.component.layout.container.ContainerContentGroupLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.headbodycontainer.HeadBodyContainer;
import com.digiwin.mobile.mobileuibot.core.component.layout.headbodycontainer.HeadBodyContainerBody;
import com.digiwin.mobile.mobileuibot.core.component.layout.headbodycontainer.HeadBodyContainerHead;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearch;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchField;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchItemList;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.webview.Webview;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.search.model.SmartPreciseSearchListBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component(value="headBodyContainerBuilder")
public class HeadBodyContainerBuilder
implements MobileComponentBuilder<HeadBodyContainer> {
    private static final Logger logger = LoggerFactory.getLogger(HeadBodyContainerBuilder.class);
    @Autowired
    private SmartPreciseSearchListBuilder smartPreciseSearchListBuilder;

    public String getMobileComponentType() {
        return "HEAD_BODY_CONTAINER";
    }

    public HeadBodyContainer build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<HeadBodyContainer> clazz, Object ... args) {
        List bodyMaps;
        Map headMap;
        Assert.isInstanceOf(Map.class, (Object)args[0], (String)"dataKeyMatchedBizData must NOT be null!");
        Map dataKeyMatchedBizData = (Map)args[0];
        Assert.isInstanceOf(List.class, (Object)args[1], (String)"not instanceof List.class!");
        List columnTagList = (List)args[1];
        Assert.isInstanceOf(UiBotLayout.class, (Object)args[2], (String)"not instanceof UiBotLayout.class!");
        UiBotLayout pageSettingLayout = (UiBotLayout)args[2];
        HeadBodyContainer headBodyContainer = new HeadBodyContainer();
        HeadBodyContainerHead headBodyContainerHead = new HeadBodyContainerHead();
        String locale = apiRequest.getLocale();
        String dataKey = (String)apiRequest.getRawData().get((Object)"dataKey");
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        Map map = (Map)pageData.get((Object)pageSettingLayout.getSchema());
        if (map.get("head") != null && (headMap = (Map)map.get("head")) != null && headMap.size() > 0) {
            List headLayOut = (List)headMap.get("layout");
            String schema = "";
            if (headLayOut != null && headLayOut.size() > 0) {
                for (Map lay1 : headLayOut) {
                    if (!"CONTAINER".equals(lay1.get("type"))) continue;
                    schema = (String)lay1.get("schema");
                    break;
                }
                if (schema != null && !schema.trim().equals("")) {
                    Map pageDataOut = (Map)headMap.get("pageData");
                    Container container = null;
                    if (pageDataOut != null && pageDataOut.size() > 0) {
                        container = (Container)JsonUtil.objectToJavaObject(pageDataOut.get(schema), Container.class);
                        container.setShowLessText(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)container.getShowLessText()) + "\u2227");
                        container.setShowMoreText(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)container.getShowMoreText()) + "\u2228");
                        container.setContentList(this.buildContentList(pcUiBotModel, dataKeyMatchedBizData, columnTagList, locale));
                        pageDataOut.put(schema, JsonUtil.objectToJavaObject((Object)container, Map.class));
                    }
                    headBodyContainerHead.setPageData((UiBotPageData)JsonUtil.objectToJavaObject((Object)pageDataOut, UiBotPageData.class));
                    UiBotLayout uiBotLayout = (UiBotLayout)JsonUtil.objectToJavaObject(headLayOut.get(0), UiBotLayout.class);
                    ArrayList<UiBotLayout> uiBotLayouts = new ArrayList<UiBotLayout>(1);
                    uiBotLayouts.add(uiBotLayout);
                    headBodyContainerHead.setLayout(uiBotLayouts);
                    headBodyContainer.setHead(headBodyContainerHead);
                }
            }
        }
        if (map.get("body") != null && (bodyMaps = (List)map.get("body")) != null && bodyMaps.size() > 0) {
            ArrayList<HeadBodyContainerBody> headBodyContainerBodies = new ArrayList<HeadBodyContainerBody>(bodyMaps.size());
            for (Map bodyMap : bodyMaps) {
                List bodyLayOuts = (List)bodyMap.get("layout");
                if (bodyLayOuts == null || bodyLayOuts.size() == 0) continue;
                Map bodyLayout = (Map)bodyLayOuts.get(0);
                Map bodyPageData = (Map)bodyMap.get("pageData");
                String schema = (String)bodyLayout.get("schema");
                ArrayList<Object> uiBotLayouts = new ArrayList<Object>(1);
                uiBotLayouts.add(JsonUtil.objectToJavaObject((Object)bodyLayout, UiBotLayout.class));
                if ("WEBVIEW".equals(bodyLayout.get("type"))) {
                    HeadBodyContainerBody headBodyContainerBody = new HeadBodyContainerBody();
                    headBodyContainerBody.setTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)((String)bodyMap.get("title"))));
                    Webview webview = (Webview)Optional.ofNullable(JsonUtil.objectToJavaObject(bodyPageData.get(schema), Webview.class)).orElse(new Webview());
                    String resultUrl = this.buildUrl(pcUiBotModel, dataKeyMatchedBizData, columnTagList, webview.getUrl());
                    if (StringUtils.hasLength((String)resultUrl) && !resultUrl.toLowerCase().contains("null")) {
                        webview.initSetting(locale);
                        webview.setUrl(resultUrl);
                        headBodyContainerBody.setLayout(uiBotLayouts);
                        bodyPageData.put(schema, JsonUtil.objectToJavaObject((Object)webview, Map.class));
                        headBodyContainerBody.setPageData((UiBotPageData)JsonUtil.objectToJavaObject((Object)bodyPageData, UiBotPageData.class));
                    } else {
                        headBodyContainerBody.createEmptyContentModel(apiRequest.getLocale(), "\u6682\u65e0\u6570\u636e");
                    }
                    headBodyContainerBodies.add(headBodyContainerBody);
                    continue;
                }
                if (!"SMART_PRECISE_SEARCH_ITEM_LIST".equals(bodyLayout.get("type"))) continue;
                String id = pcUiBotModel.getContent().getActivityId();
                List list = (List)bodyPageData.get(schema);
                String countNumText = "";
                if (list != null && list.size() > 0) {
                    Map data = (Map)((Map)list.get(0)).get("data");
                    countNumText = (String)data.get("countNumText");
                }
                List smartPreciseSearches = null;
                List pathInfos = (List)bodyMap.get("pathInfo");
                String path = "";
                for (Map pathInfo : pathInfos) {
                    if (id == null || !id.contains((String)pathInfo.get("id"))) continue;
                    path = (String)pathInfo.get("path");
                    break;
                }
                smartPreciseSearches = this.smartPreciseSearchListBuilder.build(apiRequest, null, pcUiBotModel, SmartPreciseSearch.class, new Object[]{apiRequest.getRawData().get((Object)"params"), apiRequest.getRawData().getString("tmActivityId"), path, dataKeyMatchedBizData});
                SmartPreciseSearchItemList smartPreciseSearchItemList = new SmartPreciseSearchItemList(countNumText);
                smartPreciseSearchItemList.addAllComponentsToList(smartPreciseSearches, "SMART_PRECISE_SEARCH_ITEM");
                bodyPageData.put(schema, smartPreciseSearchItemList);
                HeadBodyContainerBody headBodyContainerBody = new HeadBodyContainerBody();
                headBodyContainerBody.setTitle(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)((String)bodyMap.get("title"))));
                if (smartPreciseSearchItemList.isNotEmpty()) {
                    headBodyContainerBody.setLayout(uiBotLayouts);
                    headBodyContainerBody.setPageData((UiBotPageData)JsonUtil.objectToJavaObject((Object)bodyPageData, UiBotPageData.class));
                } else {
                    headBodyContainerBody.createEmptyContentModel(apiRequest.getLocale(), "\u6682\u65e0\u6570\u636e");
                }
                headBodyContainerBodies.add(headBodyContainerBody);
            }
            headBodyContainer.setBody(headBodyContainerBodies);
        }
        return headBodyContainer;
    }

    private List<SmartPreciseSearch> buildSmartPreciseSearch(UiBotModel pcUiBotModel, Map<String, Object> dataKeyMatchedBizData, List<ColumnTag> columnTagList, String dataKey, String locale) {
        List uiBotLayouts = pcUiBotModel.getLayout();
        if (uiBotLayouts == null || uiBotLayouts.isEmpty()) {
            return Collections.emptyList();
        }
        UiBotLayout pcDataLayout = pcUiBotModel.searchPcTargetLayout().getTargetUiBotLayout();
        String schema = pcUiBotModel.searchBizDataSchema();
        List tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return Collections.emptyList();
        }
        List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
        return this.getSmartPreciseSearchListByBizData(schema, dataKeyMatchedBizData, pcUiBotModel, columnTagList, tableColumns, locale);
    }

    private List<SmartPreciseSearch> getSmartPreciseSearchListByBizData(String path, Map<String, Object> keyBizData, UiBotModel pcUiBotModel, List<ColumnTag> columnTagList, List<UiBotTableColumn> tableColumns, String locale) {
        List historyCadInfoList;
        List groupTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_GROUP.getCode())).sorted(Comparator.comparingInt(ColumnTag::getGroupNo)).collect(Collectors.toList());
        ArrayList<SmartPreciseSearchField> smartPreciseSearchFields = new ArrayList<SmartPreciseSearchField>(groupTagList.size());
        block0: for (ColumnTag columnTag : groupTagList) {
            SmartPreciseSearchField smartPreciseSearchField = new SmartPreciseSearchField();
            for (UiBotTableColumn column : tableColumns) {
                if (!columnTag.getSchema().equals(column.getSchema())) continue;
                smartPreciseSearchField.setFieldId(columnTag.getSchema());
                smartPreciseSearchField.setFieldLayoutType(Integer.valueOf(1));
                smartPreciseSearchField.setFieldTitle(column.getHeaderName());
                smartPreciseSearchFields.add(smartPreciseSearchField);
                continue block0;
            }
        }
        ArrayList<SmartPreciseSearch> smartPreciseSearches = new ArrayList<SmartPreciseSearch>();
        List graphInfoList = (List)keyBizData.get("graph_info");
        if (graphInfoList != null && graphInfoList.size() > 0 && (historyCadInfoList = (List)((Map)graphInfoList.get(0)).get("history_cad_info")) != null && historyCadInfoList.size() > 0) {
            for (Map bizData : historyCadInfoList) {
                SmartPreciseSearch smartPreciseSearch = new SmartPreciseSearch();
                for (SmartPreciseSearchField smartPreciseSearchField : smartPreciseSearchFields) {
                    if (smartPreciseSearchField.getFieldId() == null) continue;
                    if (bizData.get(smartPreciseSearchField.getFieldId()) instanceof String) {
                        smartPreciseSearchField.setFieldValue((String)bizData.get(smartPreciseSearchField.getFieldId()));
                        continue;
                    }
                    smartPreciseSearchField.setFieldValue(String.valueOf(bizData.get(smartPreciseSearchField.getFieldId())));
                }
                smartPreciseSearch.setStyleType(SmartPreciseSearchStyleTypeEnum.LEFT_IMAGE_RIGHT_TEXT.getValue());
                smartPreciseSearch.setFields(smartPreciseSearchFields);
                smartPreciseSearches.add(smartPreciseSearch);
            }
        }
        return smartPreciseSearches;
    }

    private String buildUrl(UiBotModel pcUiBotModel, Map<String, Object> dataKeyMatchedBizData, List<ColumnTag> columnTagList, String url) {
        if (!StringUtils.hasLength((String)url)) {
            return "";
        }
        List uiBotLayouts = pcUiBotModel.getLayout();
        if (uiBotLayouts == null || uiBotLayouts.isEmpty()) {
            return "";
        }
        String schema = pcUiBotModel.searchBizDataSchema();
        return this.getUrlByBizDataAndColumnTag(schema, url, dataKeyMatchedBizData, columnTagList);
    }

    private String getUrlByBizDataAndColumnTag(String schema, String url, Map<String, Object> bizData, List<ColumnTag> columnTagList) {
        List groupOnlineDrawingTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase(schema) && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_GRAPH_ONLINE_DRAWING.getCode())).sorted(Comparator.comparingInt(ColumnTag::getGroupNo)).collect(Collectors.toList());
        for (ColumnTag columnTag : groupOnlineDrawingTagList) {
            Map graphInfo = null;
            Object bizDataValue = bizData.get(columnTag.getSchema());
            if (bizDataValue instanceof List) {
                List listBizDataValue = (List)bizDataValue;
                if (!listBizDataValue.isEmpty()) {
                    graphInfo = (Map)listBizDataValue.get(0);
                }
            } else if (bizDataValue instanceof Map) {
                graphInfo = (Map)bizDataValue;
            }
            if (null == graphInfo) continue;
            String onlineDrawingFormat = String.valueOf(graphInfo.get("online_drawing_format"));
            String cadUrl = String.valueOf(graphInfo.get("cad_url"));
            String cadUrl3d = String.valueOf(graphInfo.get("cad_url_3d"));
            url = url.contains("${athena_host}") ? url.replace("${athena_host}", AppContext.getApiUrlSetting().getMuiUrl()) : url;
            url = url.contains("${cad_info.graph_info.online_drawing_format}") ? url.replace("${cad_info.graph_info.online_drawing_format}", onlineDrawingFormat) : url;
            url = url.contains("${cad_info.graph_info.cad_url}") ? url.replace("${cad_info.graph_info.cad_url}", cadUrl) : url;
            url = url.contains("${cad_info.graph_info.cad_url_3d}") ? url.replace("${cad_info.graph_info.cad_url_3d}", cadUrl3d) : url;
        }
        return url;
    }

    private List<ContainerContent> buildContentList(UiBotModel pcUiBotModel, Map<String, Object> dataKeyMatchedBizData, List<ColumnTag> columnTagList, String locale) {
        List uiBotLayouts = pcUiBotModel.getLayout();
        if (uiBotLayouts == null || uiBotLayouts.isEmpty()) {
            return Collections.emptyList();
        }
        UiBotLayout pcDataLayout = pcUiBotModel.searchPcTargetLayout().getTargetUiBotLayout();
        String schema = pcUiBotModel.searchBizDataSchema();
        List tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return Collections.emptyList();
        }
        List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
        return this.getItemListByBizDataAndColumnTag(schema, tableColumns, dataKeyMatchedBizData, columnTagList, pcUiBotModel, locale);
    }

    private List<ContainerContent> getItemListByBizDataAndColumnTag(String path, List<UiBotTableColumn> tableColumns, Map<String, Object> bizData, List<ColumnTag> columnTagList, UiBotModel pcUiBotModel, String locale) {
        ArrayList<ContainerContent> containerContents = new ArrayList<ContainerContent>();
        HashMap<Integer, ArrayList<ColumnTag>> groupNos = new HashMap<Integer, ArrayList<ColumnTag>>();
        List groupTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_GROUP.getCode())).sorted(Comparator.comparingInt(ColumnTag::getGroupNo)).collect(Collectors.toList());
        for (ColumnTag columnTag : groupTagList) {
            ArrayList<ColumnTag> columnTags = (ArrayList<ColumnTag>)groupNos.get(columnTag.getGroupNo());
            if (columnTags != null && columnTags.size() > 0) {
                columnTags.add(columnTag);
                continue;
            }
            columnTags = new ArrayList<ColumnTag>();
            columnTags.add(columnTag);
            groupNos.put(columnTag.getGroupNo(), columnTags);
        }
        List groupOnlineDrawingTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_GRAPH_ONLINE_DRAWING.getCode())).sorted(Comparator.comparingInt(ColumnTag::getGroupNo)).collect(Collectors.toList());
        for (Integer groupNo : groupNos.keySet()) {
            ContainerContent containerContent = new ContainerContent();
            List sameGroupNoColumnTags = (List)groupNos.get(groupNo);
            if (sameGroupNoColumnTags.size() == 1) {
                containerContent.setGroupLayoutType(ContainerContentGroupLayoutTypeEnum.EXCLUSIVE_ONE_LINE.getValue());
            } else {
                containerContent.setGroupLayoutType(ContainerContentGroupLayoutTypeEnum.SHARE_ONE_LINE_AND_OVERFLOW_WITH_NEW_LINE.getValue());
            }
            containerContent.setGroupList(this.buildGroupList(tableColumns, sameGroupNoColumnTags, bizData, pcUiBotModel, locale));
            containerContents.add(containerContent);
        }
        return containerContents;
    }

    private List<UiBotModel> buildGroupList(List<UiBotTableColumn> tableColumns, List<ColumnTag> columnTags, Map<String, Object> bizData, UiBotModel pcUiBotModel, String locale) {
        ArrayList<UiBotModel> uiBotModels = new ArrayList<UiBotModel>(columnTags.size());
        ArrayList<String> attSchema = new ArrayList<String>();
        Boolean isUpload = false;
        Integer hasAttach = 0;
        for (ColumnTag columnTag : columnTags) {
            ArrayList<UiBotLayout> layoutList = new ArrayList<UiBotLayout>();
            UiBotLayout layout = new UiBotLayout();
            UiBotModel uiBotModel = new UiBotModel(layoutList);
            Field field = null;
            Attachment attachment = null;
            for (UiBotTableColumn uiBotTableColumn : tableColumns) {
                if (!uiBotTableColumn.getSchema().equals(columnTag.getSchema())) continue;
                String dataType = Optional.ofNullable(uiBotTableColumn.getDataType()).orElse("");
                String type = Optional.ofNullable(uiBotTableColumn.getType()).orElse("");
                if (type.toUpperCase().contains("UPLOAD")) {
                    attSchema.add(columnTag.getSchema());
                    isUpload = true;
                    Integer n = hasAttach;
                    Integer n2 = hasAttach = Integer.valueOf(hasAttach + 1);
                    attachment = Attachment.create(Attachment.class, (String)locale, (UiBotTableColumn)uiBotTableColumn, bizData);
                    attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
                    break;
                }
                isUpload = false;
                field = Field.create((UiBotTableColumn)uiBotTableColumn, bizData, (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_CENTER);
                break;
            }
            if (isUpload.booleanValue()) {
                if (attachment == null || attachment.getType() == null || !Objects.equals(attachment.getType(), AttachmentTypeEnum.READ_ONLY.getValue()) || attachment.getFileList() != null && attachment.getFileList().size() != 0) {
                    uiBotModel.addPageData(columnTag.getSchema(), attachment);
                }
            } else if (field == null) {
                if (StringUtils.hasLength((String)LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)columnTag.getLabel()))) {
                    field = Field.create((UiBotTableColumn)UiBotTableColumn.create((String)LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)columnTag.getLabel()), (String)columnTag.getSchema()), bizData, (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_CENTER);
                    uiBotModel.addPageData(columnTag.getSchema(), (Object)field);
                }
            } else {
                uiBotModel.addPageData(columnTag.getSchema(), field);
            }
            if (hasAttach > 0) {
                layout.setSchema(columnTag.getSchema());
                layout.setType("ATTACHMENT");
            } else {
                layout.setSchema(columnTag.getSchema());
                layout.setType("FIELD");
            }
            layoutList.add(layout);
            uiBotModels.add(uiBotModel);
        }
        return uiBotModels;
    }
}

