/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.logistics;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsData;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbUserAddress;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.AsnHeaderResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class Logistics
extends BaseMobileComponent
implements Serializable {
    public static final String COMPONENT_TYPE = "LOGISTICS";
    private static final long serialVersionUID = -3306420354377092061L;
    protected String schema;
    protected Boolean hidden;
    protected Boolean enable;
    protected Boolean required;
    private List<LogisticsData> logisticsDataList;

    public static Logistics create(String schema, String locale, AsnHeaderResponse asnHeaderResponse, Boolean useAddressBook) {
        Logistics logistics = new Logistics();
        ArrayList<LogisticsData> logisticsDataList = new ArrayList<LogisticsData>(2);
        logistics.setLogisticsDataList(logisticsDataList);
        logistics.setSchema(schema);
        logistics.setHidden(Boolean.valueOf(false));
        logistics.setEnable(Boolean.valueOf(true));
        if (asnHeaderResponse == null) {
            return logistics;
        }
        LogisticsData sendData = new LogisticsData();
        sendData.setId(asnHeaderResponse.getDeliveryAddressId());
        sendData.setCompleteAddress(asnHeaderResponse.getDeliveryAddress());
        sendData.setName(asnHeaderResponse.getShipperName());
        if (StringUtils.hasLength((String)asnHeaderResponse.getShipperMobile())) {
            sendData.setMobile(asnHeaderResponse.getShipperMobile());
            if (!useAddressBook.booleanValue()) {
                sendData.setPhoneIcon(Integer.valueOf(58908));
            }
        } else {
            sendData.setMobile("-");
        }
        HashMap<String, String> sendRawData = new HashMap<String, String>(3);
        Boolean sendHaveEmpty = false;
        if (StringUtils.hasLength((String)asnHeaderResponse.getDeliveryAddress())) {
            sendRawData.put("complete_address", asnHeaderResponse.getDeliveryAddress());
        } else {
            sendHaveEmpty = true;
        }
        if (StringUtils.hasLength((String)asnHeaderResponse.getShipperMobile())) {
            sendRawData.put("user_phone", asnHeaderResponse.getShipperMobile());
        } else {
            sendHaveEmpty = true;
        }
        if (StringUtils.hasLength((String)asnHeaderResponse.getShipperName())) {
            sendRawData.put("user_name", asnHeaderResponse.getShipperName());
        } else {
            sendHaveEmpty = true;
        }
        if (sendHaveEmpty.booleanValue()) {
            sendData.setPlaceholderAddress(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u586b\u5199\u8be6\u7ec6\u5730\u5740\u3001\u8054\u7cfb\u4eba\u3001\u8054\u7cfb\u7535\u8bdd"));
            sendData.setPlaceholderName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u53d1\u8d27\u4fe1\u606f"));
        }
        sendData.setType(LogisticsEnum.SEND.getValue());
        sendData.setIconName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u53d1"));
        sendData.setUseAddressBook(useAddressBook);
        HashMap<String, String> pageMap = new HashMap<String, String>(2);
        pageMap.put("pageNo", "1");
        pageMap.put("pageSize", "9999");
        if (useAddressBook.booleanValue()) {
            sendData.setModifiyAddress(Button.createModifiyAddress((String)UUIDUtil.getUuid(), sendRawData, (String)locale, (String)""));
            sendData.setAddressBook(Button.createAddressBook((String)UUIDUtil.getUuid(), pageMap, (String)locale));
        } else {
            sendData.setMapIcon(Integer.valueOf(58948));
        }
        logisticsDataList.add(sendData);
        LogisticsData receiveData = new LogisticsData();
        receiveData.setId(asnHeaderResponse.getReceiptAddressId());
        receiveData.setCompleteAddress(asnHeaderResponse.getReceiptAddress());
        receiveData.setName(asnHeaderResponse.getReceiverName());
        if (StringUtils.hasLength((String)asnHeaderResponse.getReceiverMobile())) {
            receiveData.setMobile(asnHeaderResponse.getReceiverMobile());
            if (!useAddressBook.booleanValue()) {
                receiveData.setPhoneIcon(Integer.valueOf(58908));
            }
        } else {
            receiveData.setMobile("-");
        }
        HashMap<String, String> receiveRawData = new HashMap<String, String>(3);
        Boolean receiveHaveEmpty = false;
        if (StringUtils.hasLength((String)asnHeaderResponse.getReceiptAddress())) {
            receiveRawData.put("complete_address", asnHeaderResponse.getReceiptAddress());
        } else {
            receiveHaveEmpty = true;
        }
        if (StringUtils.hasLength((String)asnHeaderResponse.getReceiverMobile())) {
            receiveRawData.put("user_phone", asnHeaderResponse.getReceiverMobile());
        } else {
            receiveHaveEmpty = true;
        }
        if (StringUtils.hasLength((String)asnHeaderResponse.getReceiverName())) {
            receiveRawData.put("user_name", asnHeaderResponse.getReceiverName());
        } else {
            receiveHaveEmpty = true;
        }
        if (receiveHaveEmpty.booleanValue()) {
            receiveData.setPlaceholderAddress(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u586b\u5199\u8be6\u7ec6\u5730\u5740\u3001\u8054\u7cfb\u4eba\u3001\u8054\u7cfb\u7535\u8bdd"));
            receiveData.setPlaceholderName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6536\u8d27\u4fe1\u606f"));
        }
        receiveData.setType(LogisticsEnum.RECEIVER.getValue());
        receiveData.setIconName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6536"));
        receiveData.setUseAddressBook(useAddressBook);
        if (useAddressBook.booleanValue()) {
            receiveData.setModifiyAddress(Button.createModifiyAddress((String)UUIDUtil.getUuid(), receiveRawData, (String)locale, (String)""));
            receiveData.setAddressBook(Button.createAddressBook((String)UUIDUtil.getUuid(), pageMap, (String)locale));
        } else {
            receiveData.setMapIcon(Integer.valueOf(58948));
        }
        logisticsDataList.add(receiveData);
        logistics.setRequired(Boolean.valueOf(true));
        return logistics;
    }

    public static Logistics create(String schema, String locale, DigiwinTransportResponse transportMainInfo, Boolean useAddressBook) {
        Logistics logistics = new Logistics();
        ArrayList<LogisticsData> logisticsDataList = new ArrayList<LogisticsData>(2);
        logistics.setLogisticsDataList(logisticsDataList);
        logistics.setSchema(schema);
        logistics.setHidden(Boolean.valueOf(false));
        logistics.setEnable(Boolean.valueOf(true));
        if (transportMainInfo == null) {
            return logistics;
        }
        LogisticsData sendData = new LogisticsData();
        sendData.setCompleteAddress(transportMainInfo.getDeliveryAddress());
        sendData.setName(transportMainInfo.getShipperName());
        if (StringUtils.hasLength((String)transportMainInfo.getShipperMobile())) {
            sendData.setMobile(transportMainInfo.getShipperMobile());
            if (!useAddressBook.booleanValue()) {
                sendData.setPhoneIcon(Integer.valueOf(58908));
            }
        } else {
            sendData.setMobile("-");
        }
        HashMap<String, String> sendRawData = new HashMap<String, String>(3);
        HashMap<String, String> pageMap = new HashMap<String, String>(2);
        pageMap.put("pageNo", "1");
        pageMap.put("pageSize", "9999");
        Boolean sendHaveEmpty = false;
        if (StringUtils.hasLength((String)transportMainInfo.getDeliveryAddress())) {
            sendRawData.put("complete_address", transportMainInfo.getDeliveryAddress());
        } else {
            sendHaveEmpty = true;
        }
        if (StringUtils.hasLength((String)transportMainInfo.getShipperMobile())) {
            sendRawData.put("user_phone", transportMainInfo.getShipperMobile());
        } else {
            sendHaveEmpty = true;
        }
        if (StringUtils.hasLength((String)transportMainInfo.getShipperName())) {
            sendRawData.put("user_name", transportMainInfo.getShipperName());
        } else {
            sendHaveEmpty = true;
        }
        if (sendHaveEmpty.booleanValue()) {
            sendData.setPlaceholderAddress(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u586b\u5199\u8be6\u7ec6\u5730\u5740\u3001\u8054\u7cfb\u4eba\u3001\u8054\u7cfb\u7535\u8bdd"));
            sendData.setPlaceholderName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u53d1\u8d27\u4fe1\u606f"));
        }
        if (useAddressBook.booleanValue()) {
            sendData.setModifiyAddress(Button.createModifiyAddress((String)UUIDUtil.getUuid(), sendRawData, (String)locale, (String)""));
            sendData.setAddressBook(Button.createAddressBook((String)UUIDUtil.getUuid(), pageMap, (String)locale));
        } else {
            sendData.setMapIcon(Integer.valueOf(58948));
        }
        sendData.setType(LogisticsEnum.SEND.getValue());
        sendData.setIconName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u53d1"));
        sendData.setUseAddressBook(useAddressBook);
        logisticsDataList.add(sendData);
        LogisticsData receiveData = new LogisticsData();
        receiveData.setCompleteAddress(transportMainInfo.getReceiptAddress());
        receiveData.setName(transportMainInfo.getReceiverName());
        if (StringUtils.hasLength((String)transportMainInfo.getReceiverMobile())) {
            receiveData.setMobile(transportMainInfo.getReceiverMobile());
            if (!useAddressBook.booleanValue()) {
                receiveData.setPhoneIcon(Integer.valueOf(58908));
            }
        } else {
            receiveData.setMobile("-");
        }
        HashMap<String, String> receiveRawData = new HashMap<String, String>(3);
        Boolean receiveHaveEmpty = false;
        if (StringUtils.hasLength((String)transportMainInfo.getReceiptAddress())) {
            receiveRawData.put("complete_address", transportMainInfo.getReceiptAddress());
        } else {
            receiveHaveEmpty = true;
        }
        if (StringUtils.hasLength((String)transportMainInfo.getReceiverMobile())) {
            receiveRawData.put("user_phone", transportMainInfo.getReceiverMobile());
        } else {
            receiveHaveEmpty = true;
        }
        if (StringUtils.hasLength((String)transportMainInfo.getReceiverName())) {
            receiveRawData.put("user_name", transportMainInfo.getReceiverName());
        } else {
            receiveHaveEmpty = true;
        }
        if (receiveHaveEmpty.booleanValue()) {
            receiveData.setPlaceholderAddress(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u586b\u5199\u8be6\u7ec6\u5730\u5740\u3001\u8054\u7cfb\u4eba\u3001\u8054\u7cfb\u7535\u8bdd"));
            receiveData.setPlaceholderName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6536\u8d27\u4fe1\u606f"));
        }
        if (useAddressBook.booleanValue()) {
            receiveData.setModifiyAddress(Button.createModifiyAddress((String)UUIDUtil.getUuid(), receiveRawData, (String)locale, (String)""));
            receiveData.setAddressBook(Button.createAddressBook((String)UUIDUtil.getUuid(), pageMap, (String)locale));
        } else {
            receiveData.setMapIcon(Integer.valueOf(58948));
        }
        receiveData.setType(LogisticsEnum.RECEIVER.getValue());
        receiveData.setIconName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6536"));
        receiveData.setUseAddressBook(useAddressBook);
        logisticsDataList.add(receiveData);
        logistics.setRequired(Boolean.valueOf(true));
        return logistics;
    }

    public static Logistics create(String schema, String locale, Map<String, Object> deliverAddress, Map<String, Object> receiptAddress, Boolean useAddressBook) {
        Logistics logistics = new Logistics();
        ArrayList<LogisticsData> logisticsDataList = new ArrayList<LogisticsData>(2);
        logistics.setLogisticsDataList(logisticsDataList);
        logistics.setSchema(schema);
        logistics.setHidden(Boolean.valueOf(false));
        logistics.setEnable(Boolean.valueOf(true));
        if (deliverAddress == null || receiptAddress == null) {
            return logistics;
        }
        ZtbUserAddress deliverAddressData = (ZtbUserAddress)JsonUtil.objectToJavaObject(deliverAddress, ZtbUserAddress.class);
        LogisticsData sendData = new LogisticsData();
        sendData.setCompleteAddress(deliverAddressData.getCompleteAddress());
        sendData.setName(deliverAddressData.getUserName());
        if (StringUtils.hasLength((String)deliverAddressData.getUserPhone())) {
            sendData.setMobile(deliverAddressData.getUserPhone());
            if (!useAddressBook.booleanValue()) {
                sendData.setPhoneIcon(Integer.valueOf(58908));
            }
        } else {
            sendData.setMobile("-");
        }
        HashMap<String, String> sendRawData = new HashMap<String, String>(3);
        HashMap<String, String> pageMap = new HashMap<String, String>(2);
        pageMap.put("pageNo", "1");
        pageMap.put("pageSize", "9999");
        Boolean sendHaveEmpty = false;
        if (StringUtils.hasLength((String)deliverAddressData.getCompleteAddress())) {
            sendRawData.put("complete_address", deliverAddressData.getCompleteAddress());
        } else {
            sendHaveEmpty = true;
        }
        if (StringUtils.hasLength((String)deliverAddressData.getUserPhone())) {
            sendRawData.put("user_phone", deliverAddressData.getUserPhone());
        } else {
            sendHaveEmpty = true;
        }
        if (StringUtils.hasLength((String)deliverAddressData.getUserName())) {
            sendRawData.put("user_name", deliverAddressData.getUserName());
        } else {
            sendHaveEmpty = true;
        }
        if (sendHaveEmpty.booleanValue()) {
            sendData.setPlaceholderAddress(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u586b\u5199\u8be6\u7ec6\u5730\u5740\u3001\u8054\u7cfb\u4eba\u3001\u8054\u7cfb\u7535\u8bdd"));
            sendData.setPlaceholderName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u53d1\u8d27\u4fe1\u606f"));
        }
        if (useAddressBook.booleanValue()) {
            sendData.setModifiyAddress(Button.createModifiyAddress((String)UUIDUtil.getUuid(), sendRawData, (String)locale, (String)""));
            sendData.setAddressBook(Button.createAddressBook((String)UUIDUtil.getUuid(), pageMap, (String)locale));
        } else {
            sendData.setMapIcon(Integer.valueOf(58948));
        }
        sendData.setType(LogisticsEnum.SEND.getValue());
        sendData.setIconName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u53d1"));
        sendData.setUseAddressBook(useAddressBook);
        logisticsDataList.add(sendData);
        LogisticsData receiveData = new LogisticsData();
        ZtbUserAddress receiveAddressData = (ZtbUserAddress)JsonUtil.objectToJavaObject(receiptAddress, ZtbUserAddress.class);
        receiveData.setCompleteAddress(receiveAddressData.getCompleteAddress());
        receiveData.setName(receiveAddressData.getUserName());
        if (StringUtils.hasLength((String)receiveAddressData.getUserPhone())) {
            receiveData.setMobile(receiveAddressData.getUserPhone());
            if (!useAddressBook.booleanValue()) {
                receiveData.setPhoneIcon(Integer.valueOf(58908));
            }
        } else {
            receiveData.setMobile("-");
        }
        HashMap<String, String> receiveRawData = new HashMap<String, String>(3);
        Boolean receiveHaveEmpty = false;
        if (StringUtils.hasLength((String)receiveAddressData.getCompleteAddress())) {
            receiveRawData.put("complete_address", receiveAddressData.getCompleteAddress());
        } else {
            receiveHaveEmpty = true;
        }
        if (StringUtils.hasLength((String)receiveAddressData.getUserPhone())) {
            receiveRawData.put("user_phone", receiveAddressData.getUserPhone());
        } else {
            receiveHaveEmpty = true;
        }
        if (StringUtils.hasLength((String)receiveAddressData.getUserName())) {
            receiveRawData.put("user_name", receiveAddressData.getUserName());
        } else {
            receiveHaveEmpty = true;
        }
        if (receiveHaveEmpty.booleanValue()) {
            receiveData.setPlaceholderAddress(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u586b\u5199\u8be6\u7ec6\u5730\u5740\u3001\u8054\u7cfb\u4eba\u3001\u8054\u7cfb\u7535\u8bdd"));
            receiveData.setPlaceholderName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6536\u8d27\u4fe1\u606f"));
        }
        if (useAddressBook.booleanValue()) {
            receiveData.setModifiyAddress(Button.createModifiyAddress((String)UUIDUtil.getUuid(), receiveRawData, (String)locale, (String)""));
            receiveData.setAddressBook(Button.createAddressBook((String)UUIDUtil.getUuid(), pageMap, (String)locale));
        } else {
            receiveData.setMapIcon(Integer.valueOf(58948));
        }
        receiveData.setType(LogisticsEnum.RECEIVER.getValue());
        receiveData.setIconName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6536"));
        receiveData.setUseAddressBook(useAddressBook);
        logisticsDataList.add(receiveData);
        logistics.setRequired(Boolean.valueOf(true));
        return logistics;
    }

    public static Logistics createEmpty(LocaleService localeService, String locale, Boolean useAddressBook) {
        Logistics logistics = new Logistics();
        ArrayList<LogisticsData> logisticsDataList = new ArrayList<LogisticsData>(2);
        logistics.setLogisticsDataList(logisticsDataList);
        logistics.setSchema(COMPONENT_TYPE);
        logistics.setHidden(Boolean.valueOf(false));
        logistics.setEnable(Boolean.valueOf(true));
        LogisticsData sendData = new LogisticsData();
        sendData.setPlaceholderName(localeService.getLanguageValue(locale, "\u53d1\u8d27\u4fe1\u606f"));
        sendData.setPlaceholderAddress(localeService.getLanguageValue(locale, "\u8bf7\u586b\u5199\u8be6\u7ec6\u5730\u5740\u3001\u8054\u7cfb\u4eba\u3001\u8054\u7cfb\u7535\u8bdd"));
        HashMap<String, String> pageMap = new HashMap<String, String>(2);
        pageMap.put("pageNo", "1");
        pageMap.put("pageSize", "9999");
        if (useAddressBook.booleanValue()) {
            sendData.setModifiyAddress(Button.createModifiyAddress((String)UUIDUtil.getUuid(), Collections.emptyMap(), (String)locale, (String)""));
            sendData.setAddressBook(Button.createAddressBook((String)UUIDUtil.getUuid(), pageMap, (String)locale));
        } else {
            sendData.setMapIcon(Integer.valueOf(58948));
        }
        sendData.setType(LogisticsEnum.SEND.getValue());
        sendData.setIconName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u53d1"));
        sendData.setUseAddressBook(useAddressBook);
        logisticsDataList.add(sendData);
        LogisticsData receiveData = new LogisticsData();
        receiveData.setPlaceholderAddress(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u586b\u5199\u8be6\u7ec6\u5730\u5740\u3001\u8054\u7cfb\u4eba\u3001\u8054\u7cfb\u7535\u8bdd"));
        receiveData.setPlaceholderName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6536\u8d27\u4fe1\u606f"));
        if (useAddressBook.booleanValue()) {
            receiveData.setModifiyAddress(Button.createModifiyAddress((String)UUIDUtil.getUuid(), Collections.emptyMap(), (String)locale, (String)""));
            receiveData.setAddressBook(Button.createAddressBook((String)UUIDUtil.getUuid(), pageMap, (String)locale));
        } else {
            receiveData.setMapIcon(Integer.valueOf(58948));
        }
        receiveData.setType(LogisticsEnum.RECEIVER.getValue());
        receiveData.setIconName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6536"));
        receiveData.setUseAddressBook(useAddressBook);
        logisticsDataList.add(receiveData);
        logistics.setRequired(Boolean.valueOf(true));
        return logistics;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public void applyEditable(Boolean enable) {
        this.enable = enable;
    }

    public void applyHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public String getSchema() {
        return this.schema;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public List<LogisticsData> getLogisticsDataList() {
        return this.logisticsDataList;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setLogisticsDataList(List<LogisticsData> logisticsDataList) {
        this.logisticsDataList = logisticsDataList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Logistics)) {
            return false;
        }
        Logistics other = (Logistics)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$hidden = this.getHidden();
        Boolean other$hidden = other.getHidden();
        if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        Boolean this$required = this.getRequired();
        Boolean other$required = other.getRequired();
        if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        List this$logisticsDataList = this.getLogisticsDataList();
        List other$logisticsDataList = other.getLogisticsDataList();
        return !(this$logisticsDataList == null ? other$logisticsDataList != null : !((Object)this$logisticsDataList).equals(other$logisticsDataList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Logistics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        Boolean $required = this.getRequired();
        result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        List $logisticsDataList = this.getLogisticsDataList();
        result = result * 59 + ($logisticsDataList == null ? 43 : ((Object)$logisticsDataList).hashCode());
        return result;
    }

    public String toString() {
        return "Logistics(schema=" + this.getSchema() + ", hidden=" + this.getHidden() + ", enable=" + this.getEnable() + ", required=" + this.getRequired() + ", logisticsDataList=" + this.getLogisticsDataList() + ")";
    }

    public Logistics() {
    }

    public Logistics(String schema, Boolean hidden, Boolean enable, Boolean required, List<LogisticsData> logisticsDataList) {
        this.schema = schema;
        this.hidden = hidden;
        this.enable = enable;
        this.required = required;
        this.logisticsDataList = logisticsDataList;
    }
}

