/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.qrcode;

import com.digiwin.mobile.mobileuibot.common.crypto.aes.AESUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import java.io.Serializable;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QrCodeContentMsg
extends HashMap<String, String>
implements Serializable {
    private static final long serialVersionUID = 7122712833233796728L;
    public static final String BIZ_TYPE_ZHILINK_ITM = "ZHILINK_ITM";
    public static final String BIZ_TYPE_DRIVER_CODE = "DRIVER_CODE";
    public static final String BIZ_TYPE_BAR_CODE = "BAR_CODE";
    public static final String BIZ_TYPE_ASN_CODE = "ASN_CODE";
    public static final String BIZ_TYPE_TRANSPORT_RECEIVE = "TRANSPORT_RECEIVE";
    private static String aesKey;
    private String bizType;
    private String timestamp = String.valueOf(System.currentTimeMillis());

    public QrCodeContentMsg(String bizType) {
        this.bizType = bizType = this.encrypt(bizType);
    }

    @Override
    public String put(String key, String value) {
        value = this.encrypt(value);
        return super.put(key, value);
    }

    private QrCodeContentMsg() {
    }

    @Autowired
    public void init(SysEnvConfig sysEnvConfig) {
        aesKey = sysEnvConfig.getAesKey();
    }

    private String encrypt(String content) {
        try {
            content = AESUtil.encrypt((String)aesKey, (String)content);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return content;
    }

    public String getBizType() {
        return this.bizType;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QrCodeContentMsg)) {
            return false;
        }
        QrCodeContentMsg other = (QrCodeContentMsg)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$bizType = this.getBizType();
        String other$bizType = other.getBizType();
        if (this$bizType == null ? other$bizType != null : !this$bizType.equals(other$bizType)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QrCodeContentMsg;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bizType = this.getBizType();
        result = result * 59 + ($bizType == null ? 43 : $bizType.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "QrCodeContentMsg(bizType=" + this.getBizType() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

