/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.tab.customtab;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTab;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabsComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="customTabsComponentBuilder")
public class CustomTabsComponentBuilder
implements MobileComponentBuilder<CustomTabs> {
    private static final Logger log = LoggerFactory.getLogger(CustomTabsComponentBuilder.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public String getMobileComponentType() {
        return "CUSTOM_TABS";
    }

    public CustomTabs build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<CustomTabs> clazz, Object ... args) {
        CustomTabs result = new CustomTabs();
        switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$core$pagesetting$PageSettingIdPresetEnum[Objects.requireNonNull(PageSettingIdPresetEnum.getEnumByName((String)pageSetting.getPageId())).ordinal()]) {
            case 1: 
            case 2: {
                result = this.buildWorkingHourReport(apiRequest, pageSetting, pcUiBotModel, clazz, args);
                break;
            }
        }
        return result;
    }

    public CustomTabs buildWorkingHourReport(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<CustomTabs> clazz, Object ... args) {
        CustomTabs customTabs = new CustomTabs();
        Map defaultDataMap = TaskDataExtractUtil.getDefaultData((String)pageSetting.getPageId());
        String[] leftTitleFields = (String[])defaultDataMap.get("leftTitleFields");
        String rightTitleField = String.valueOf(defaultDataMap.get("rightTitleField"));
        String[] contentFields = (String[])defaultDataMap.get("contentFields");
        int contentFieldsLimit = Integer.parseInt(defaultDataMap.get("contentFieldsLimit").toString());
        Map valueToTextMap = (Map)defaultDataMap.get("valueToTextMap");
        UiBotPageData uiBotPageData = pcUiBotModel.getPageData();
        String bizDataSchema = pcUiBotModel.searchBizDataSchema();
        if (bizDataSchema.isEmpty()) {
            switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$core$pagesetting$PageSettingIdPresetEnum[Objects.requireNonNull(PageSettingIdPresetEnum.getEnumByName((String)pageSetting.getPageId())).ordinal()]) {
                case 1: 
                case 2: {
                    bizDataSchema = "wo_op_report_data";
                    break;
                }
            }
        }
        List bizDataRaw = (List)uiBotPageData.get((Object)bizDataSchema);
        if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST.toString().equalsIgnoreCase(pageSetting.getPageId()) && !CollectionUtils.isEmpty((Collection)bizDataRaw)) {
            bizDataRaw.forEach(item -> {
                item.put("is_merge_report", true);
                item.put("whether_support", true);
            });
        }
        CustomTab offLineCustomTab = this.buildCustomTab(pageSetting.getPageId(), bizDataRaw, pcUiBotModel, false, apiRequest, customTabs, leftTitleFields, rightTitleField, contentFields, contentFieldsLimit, valueToTextMap);
        customTabs.add((Object)offLineCustomTab);
        CustomTab onLineCustomTab = this.buildCustomTab(pageSetting.getPageId(), bizDataRaw, pcUiBotModel, true, apiRequest, customTabs, leftTitleFields, rightTitleField, contentFields, contentFieldsLimit, valueToTextMap);
        customTabs.add((Object)onLineCustomTab);
        return customTabs;
    }

    private CustomTab buildCustomTab(String pageId, List<Map<String, Object>> bizDataRaw, UiBotModel pcUiBotModel, boolean isCheckIn, ApiRequest apiRequest, CustomTabs customTabs, String[] leftTitleFields, String rightTitleField, String[] contentFields, int contentFieldsLimit, Map<String, String> valueToTextMap) {
        int showNum;
        CustomTab customTab = new CustomTab();
        List list = bizDataRaw.stream().filter(item -> item.get("is_check_in").equals(isCheckIn)).collect(Collectors.toList());
        Map bizData = this.groupByFieldMap(list, "op_no");
        if (isCheckIn) {
            customTabs.setGrayButton(Boolean.valueOf(!CollectionUtils.isEmpty(list)));
            showNum = list.size();
        } else {
            showNum = bizData.size();
        }
        ArrayList<CustomTabContentContainer> customTabContentContainerList = new ArrayList<CustomTabContentContainer>();
        DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService = (DigiwinKnowledgeMapsProxyService)SpringContextHolder.getBean(DigiwinKnowledgeMapsProxyService.class);
        Map variableListSimpleMap = digiwinKnowledgeMapsProxyService.getVariableListSimple(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), Arrays.asList("abnormalAllowsUploadingAttachments"));
        if (!CollectionUtils.isEmpty((Map)bizData)) {
            for (Map.Entry entry : bizData.entrySet()) {
                String subOpSeq = String.valueOf(((Map)((List)entry.getValue()).get(0)).get("sub_op_seq"));
                boolean hasButton = subOpSeq.isEmpty();
                CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
                if (isCheckIn) {
                    UiBotExecuteContext executeContext = pcUiBotModel.getExecuteContext();
                    Map businessUnit = (Map)executeContext.get((Object)"businessUnit");
                    ((Map)((List)entry.getValue()).get(0)).put("eoc_site_id", businessUnit.get("eoc_site_id"));
                    List qtyInfoList = this.digiwinEspProxyService.getWoOpReportQtyInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), this.buildApcRequest((Map)((List)entry.getValue()).get(0), pageId));
                    customTabContentContainer.setContentCmptType("CUSTOM_GROUP");
                    customTabContentContainer.setData((Object)CustomGroup.create((ApiRequest)apiRequest, (UiBotModel)pcUiBotModel, (Map)((Map)((List)entry.getValue()).get(0)), (List)((List)entry.getValue()), (boolean)hasButton, (String[])leftTitleFields, (String[])contentFields, (int)contentFieldsLimit, valueToTextMap, (Boolean)isCheckIn, (List)qtyInfoList, (Map)variableListSimpleMap));
                } else {
                    customTabContentContainer.setContentCmptType("CARD");
                    customTabContentContainer.setData((Object)Card.create((ApiRequest)apiRequest, (UiBotModel)pcUiBotModel, (Map)((Map)((List)entry.getValue()).get(0)), (List)((List)entry.getValue()), (boolean)hasButton, (String[])leftTitleFields, (String)rightTitleField, (String[])contentFields, (int)contentFieldsLimit, valueToTextMap, (Boolean)isCheckIn, (CustomTabContentContainer)customTabContentContainer, (LocaleService)this.localeService, (Map)variableListSimpleMap));
                }
                customTabContentContainerList.add(customTabContentContainer);
            }
        } else {
            String emptyMsg = "\u6682\u65e0\u6570\u636e";
            CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
            customTabContentContainer.setData((Object)Empty.create((String)LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)emptyMsg), (boolean)true));
            customTabContentContainer.setContentCmptType("EMPTY");
            customTabContentContainerList.add(customTabContentContainer);
            customTab.setContent(customTabContentContainerList);
            customTab.setDefaultSelected(Integer.valueOf(isCheckIn ? 0 : 1));
        }
        String tabName = this.localeService.getLanguageValue(apiRequest.getLocale(), isCheckIn ? "\u5df2\u4e0a\u7ebf" : "\u672a\u4e0a\u7ebf") + " (" + showNum + ")";
        customTab.setName(tabName);
        customTab.setStyle(Integer.valueOf(2));
        customTab.setAlignmentType(Integer.valueOf(1));
        customTab.setContent(customTabContentContainerList);
        return customTab;
    }

    public Map<String, List<Map<String, Object>>> groupByFieldMap(List<Map<String, Object>> list, String value) {
        LinkedHashMap<String, List<Map<String, Object>>> listMap = new LinkedHashMap<String, List<Map<String, Object>>>();
        for (Map<String, Object> map : list) {
            ArrayList<Map<String, Object>> tmpList = (ArrayList<Map<String, Object>>)listMap.get(map.get(value));
            if (tmpList == null) {
                tmpList = new ArrayList<Map<String, Object>>();
                tmpList.add(map);
                listMap.put(String.valueOf(map.get(value)), tmpList);
                continue;
            }
            tmpList.add(map);
        }
        return listMap;
    }

    private Map<String, Object> buildApcRequest(Map<String, Object> woInfoJsonObject, String pageId) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        JSONObject woReportData = new JSONObject();
        woReportData.put("eoc_company_id", woInfoJsonObject.get("eoc_company_id"));
        woReportData.put("eoc_site_id", woInfoJsonObject.get("eoc_site_id"));
        woReportData.put("wo_no", woInfoJsonObject.get("wo_no"));
        woReportData.put("op_seq", woInfoJsonObject.get("op_seq"));
        woReportData.put("category", woInfoJsonObject.get("category"));
        woReportData.put("plan_source", woInfoJsonObject.get("plan_source"));
        woReportData.put("remaining_qty", woInfoJsonObject.get("remaining_qty"));
        woReportData.put("report_qty", woInfoJsonObject.get("report_qty"));
        woReportData.put("plot_no", woInfoJsonObject.get("plot_no"));
        if ("MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_LIST".equals(pageId)) {
            woReportData.put("category", (Object)"1");
        }
        if ("MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST".equals(pageId)) {
            woReportData.put("category", (Object)"2");
        }
        JSONArray array = new JSONArray();
        array.add((Object)woReportData);
        requestMap.put("wo_op_report_data", array);
        return requestMap;
    }
}

