/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.layout;

import com.digiwin.mobile.mobileuibot.core.component.BaseLayoutMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.LayoutGeneratorPreprocessData;
import com.digiwin.mobile.mobileuibot.core.layout.LayoutGeneratorService;
import com.digiwin.mobile.mobileuibot.core.layout.LayoutGeneratorServiceImpl;
import com.digiwin.mobile.mobileuibot.core.layout.LayoutGeneratorServiceResult;
import com.digiwin.mobile.mobileuibot.core.layout.analyzer.LayoutAnalyzerFactory;
import com.digiwin.mobile.mobileuibot.core.layout.analyzer.LayoutAnalyzerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.analyzer.LayoutAnalyzerWeight;
import com.digiwin.mobile.mobileuibot.core.layout.analyzer.LayoutAnalyzerWeightReader;
import com.digiwin.mobile.mobileuibot.core.layout.generator.LayoutGenerator;
import com.digiwin.mobile.mobileuibot.core.layout.generator.LayoutGeneratorFactory;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="layoutGeneratorServiceImpl")
public class LayoutGeneratorServiceImpl
implements LayoutGeneratorService {
    private static final Logger log = LoggerFactory.getLogger(LayoutGeneratorServiceImpl.class);
    private final LayoutAnalyzerFactory layoutAnalyzerFactory;
    private final LayoutAnalyzerWeightReader layoutAnalyzerWeightReader;
    private final LayoutGeneratorFactory layoutGeneratorFactory;

    public LayoutGeneratorServiceImpl(LayoutAnalyzerFactory layoutAnalyzerFactory, LayoutAnalyzerWeightReader layoutAnalyzerWeightReader, LayoutGeneratorFactory layoutGeneratorFactory) {
        this.layoutAnalyzerFactory = layoutAnalyzerFactory;
        this.layoutAnalyzerWeightReader = layoutAnalyzerWeightReader;
        this.layoutGeneratorFactory = layoutGeneratorFactory;
    }

    public LayoutGeneratorServiceResult generate(LayoutGeneratorPreprocessData preprocessData) {
        MobileLayoutTypeEnum bizDataDrivenLayout = this.layoutAnalyzerFactory.get(LayoutAnalyzerTypeEnum.BIZ_DATA_TYPE.getValue()).getLayoutType(preprocessData);
        LayoutAnalyzerWeight maxLayoutAnalyzerWeight = this.layoutAnalyzerWeightReader.getMaxWeight();
        LayoutGenerator layoutGenerator = null;
        BaseLayoutMobileComponent resultLayoutComponent = null;
        switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$core$layout$analyzer$LayoutAnalyzerTypeEnum[maxLayoutAnalyzerWeight.getLayoutAnalyzerTypeEnum().ordinal()]) {
            case 1: {
                layoutGenerator = this.layoutGeneratorFactory.get(bizDataDrivenLayout.getValue());
                if (!Objects.nonNull(layoutGenerator)) break;
                resultLayoutComponent = layoutGenerator.generate(preprocessData);
                break;
            }
            default: {
                resultLayoutComponent = null;
            }
        }
        MobileLayoutTypeEnum mobileLayoutTypeEnum = Objects.isNull(layoutGenerator) ? MobileLayoutTypeEnum.MULTI_PATTERN_LAYOUT : MobileLayoutTypeEnum.getEnumByValue((String)layoutGenerator.getType());
        return LayoutGeneratorServiceResult.builder().maxLayoutAnalyzerWeight(maxLayoutAnalyzerWeight).layoutTypeEnum(mobileLayoutTypeEnum).layoutMobileComponent(resultLayoutComponent).build();
    }
}

