/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.mobileappconfig;

import com.digiwin.mobile.mobileuibot.core.mobileappconfig.MobileAppConfig;
import com.digiwin.mobile.mobileuibot.core.mobileappconfig.MobileAppConfigService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service(value="mobileAppConfigService")
public class MobileAppConfigServiceImpl
implements MobileAppConfigService {
    private static final Logger logger = LoggerFactory.getLogger(MobileAppConfigServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;

    public List<MobileAppConfig> listMobileAppConfigsByCompanyId(String companyId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"companyId").is((Object)companyId));
        return this.mongoTemplate.find(query, MobileAppConfig.class);
    }

    public List<MobileAppConfig> listMobileAppConfigsBySourceName(String sourceName) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sourceName").is((Object)sourceName));
        return this.mongoTemplate.find(query, MobileAppConfig.class);
    }

    public List<MobileAppConfig> listMobileAppConfigsByCompanyIdAndSourceName(String companyId, String sourceName) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"companyId").is((Object)companyId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sourceName").is((Object)sourceName));
        return this.mongoTemplate.find(query, MobileAppConfig.class);
    }

    public MobileAppConfig getMobileAppConfig(String companyId, String sourceName, String appsCode) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"companyId").is((Object)companyId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sourceName").is((Object)sourceName));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appsCode").is((Object)appsCode));
        return (MobileAppConfig)this.mongoTemplate.findOne(query, MobileAppConfig.class);
    }

    @Cacheable(value={"defaultMobileAppConfigs"})
    public List<MobileAppConfig> listMobileAppConfigsBelongDefaultCompanyId() {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"companyId").is((Object)"10000"));
        return this.mongoTemplate.find(query, MobileAppConfig.class);
    }

    @Cacheable(value={"digiwinMobileAppConfigs"})
    public List<MobileAppConfig> listMobileAppConfigsBelongDigiwinCompanyId() {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"companyId").is((Object)"1000"));
        return this.mongoTemplate.find(query, MobileAppConfig.class);
    }
}

