/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.pagetaskrelation;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="pageTaskRelationService")
public class PageTaskRelationServiceImpl
implements PageTaskRelationService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="secondMongoTemplate")
    private MongoTemplate secondMongoTemplate;

    public List<PageTaskRelation> listAthenaPageTaskRelations(String version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"source").is((Object)"athena")).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        return this.mongoTemplate.find(query, PageTaskRelation.class).stream().filter(pageTaskRelation -> pageTaskRelation.validWithAppEnvType(AppContext.getEnvType())).collect(Collectors.toList());
    }

    public void deleteByCode(String appCode, String version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        this.mongoTemplate.findAllAndRemove(query, PageTaskRelation.class);
        this.secondMongoTemplate.findAllAndRemove(query, PageTaskRelation.class);
    }

    public List<PageTaskRelation> selectByCode(String appCode, String version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        List list = this.mongoTemplate.find(query, PageTaskRelation.class);
        return CollectionUtils.isEmpty((Collection)list) ? new ArrayList() : list;
    }

    public void batchInsert(List<PageTaskRelation> pageTaskRelations) {
        if (CollectionUtils.isEmpty(pageTaskRelations)) {
            return;
        }
        this.mongoTemplate.insertAll(pageTaskRelations);
        this.secondMongoTemplate.insertAll(pageTaskRelations);
    }
}

