/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardCategory;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItemEmptyModeEnum;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild.UiBotCompDataBuildStrategy;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="uiBotCompDataBuildIndexWorkspaceCardListStrategy")
public class UiBotCompDataBuildIndexWorkspaceCardListStrategy
implements UiBotCompDataBuildStrategy<CustomTabControllerItem> {
    private static final Logger logger = LoggerFactory.getLogger(UiBotCompDataBuildIndexWorkspaceCardListStrategy.class);
    @Autowired
    private ProjectService projectService;

    public String getTypeByRequestId() {
        return ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_CARD_LIST.getReuqestId();
    }

    public CustomTabControllerItem buildComponentData(ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildIndexWorkspaceCardList");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        CustomTabControllerItem customTab = useMockData == false && modelTypeShow == false ? this.doActually(apiRequest, stopWatch) : this.doMockData(apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return customTab;
    }

    private CustomTabControllerItem doActually(ApiRequest apiRequest, StopWatch stopWatch) {
        CustomTabContentContainer content = new CustomTabContentContainer();
        content.setContentCmptType("CARD_LIST");
        List cardCategoryList = this.projectService.getProjectList(apiRequest);
        List allCardList = cardCategoryList.stream().map(CardCategory::getCardList).flatMap(Collection::stream).collect(Collectors.toList());
        int actualProjectCount = allCardList.size();
        CustomTabControllerItemEmptyModeEnum emptyModeEnum = null;
        if (this.projectService.validIsMatchTenantId(apiRequest.getTenantId())) {
            content.setData(actualProjectCount <= 1 ? allCardList : this.projectService.sortCardListByCreateTime(allCardList).subList(0, 2));
        } else {
            Optional<CardCategory> optAbnormalCardCategory = cardCategoryList.stream().filter(cardCategory -> cardCategory.getCategoryName().equals(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u903e\u671f/\u5f02\u5e38"))).findFirst();
            if (!optAbnormalCardCategory.isPresent()) {
                content.setData(Collections.emptyList());
                emptyModeEnum = actualProjectCount > 0 ? CustomTabControllerItemEmptyModeEnum.EXIST_DATA_BUT_EMPTY_IN_UI_WITH_SHOW_MORE : CustomTabControllerItemEmptyModeEnum.EMPTY_DATA_AND_UI_WITH_HIDE_MORE;
            } else {
                CardCategory abnormalCardCategory = optAbnormalCardCategory.get();
                List abnormalCardList = abnormalCardCategory.getCardList();
                int abnormalCardCount = abnormalCardCategory.getCardList().size();
                content.setData((Object)(abnormalCardCount <= 1 ? abnormalCardList : abnormalCardList.subList(0, 2)));
            }
        }
        CustomTabControllerItem item = CustomTabControllerItem.createAsyncData((String)(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u9879\u76ee\u8ffd\u8e2a") + "(" + actualProjectCount + ")"), (CustomTabContentContainer)content, (CustomTabControllerItemEmptyModeEnum)emptyModeEnum);
        return item;
    }

    private CustomTabControllerItem doMockData(ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        CustomTabControllerItem uiBotModel = null;
        String data = FileUtil.readText((String)"static/appstore-use/MyWorkSpaceCard.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (CustomTabControllerItem)JsonUtil.jsonStringToObject((String)data, CustomTabControllerItem.class);
        }
        return uiBotModel;
    }
}

