/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzerFactory;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="uiBotModelBuildActionPageStrategy")
public class UiBotModelBuildActionPageStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildActionPageStrategy.class);
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;
    @Autowired
    private ComponentParamAnalyzerFactory componentSubmitParamAnalyzerFactory;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        UiBotPageData pageData = pageSettingModel.getPageData();
        for (String pageDataKey : pageData.keySet()) {
            Optional<UiBotLayout> optType = pageSettingModel.getLayout().stream().filter(layout -> layout.getSchema().equalsIgnoreCase(pageDataKey)).findFirst();
            String type = optType.orElse(new UiBotLayout()).getType();
            if ("CUSTOM_GROUP".equals(type)) {
                CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)pageDataKey), CustomGroup.class);
                customGroup.setName(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)customGroup.getName()));
                CustomGroupContent customGroupContent = customGroup.getContent();
                for (UiBotLayout layout2 : customGroupContent.getLayout()) {
                    this.componentSubmitParamAnalyzerFactory.get(layout2.getType()).handleDisplayParam(apiRequest, layout2.getSchema(), customGroupContent.getPageData(), new Object[]{apiRequest.getRawData()});
                }
                customGroup.setContent(customGroupContent);
                pageData.put((Object)pageDataKey, (Object)customGroup);
                continue;
            }
            this.componentSubmitParamAnalyzerFactory.get(type).handleDisplayParam(apiRequest, pageDataKey, pageData, new Object[]{apiRequest.getRawData()});
        }
        UiBotModel uiBotModel = this.uiBotModelBuildService.buildModel(pageSetting, pageData);
        ModuleUtils.addRefreshPageId((UiBotModel)uiBotModel, (String)apiRequest.getRefreshPageId());
        return uiBotModel;
    }
}

