/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.TaskPageService;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UiBotModelBuildMyTaskDetailV2Strategy
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelBuildMyTaskDetailV2Strategy.class);
    @Autowired
    private TaskPageService taskPageService;
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        Boolean isShared = Optional.ofNullable(apiRequest.getRawData().getBoolean("isShared")).orElse(Boolean.FALSE);
        Boolean isHistory = Boolean.FALSE;
        Boolean isSuperAdmin = Boolean.FALSE;
        if (isShared.booleanValue()) {
            isSuperAdmin = this.digiwinIamProxyService.isSuperAdmin(apiRequest.getIamUserToken(), apiRequest.getUserId());
        }
        PcUiBotExecuteContext executeContext = PcUiBotExecuteContext.create((String)apiRequest.getLocale(), (String)apiRequest.getTenantId(), (String)apiRequest.getDataId());
        executeContext.setPtmBacklogId(apiRequest.getDataId());
        executeContext.appendPageInfoAndSuperAdmin("task-detail-mobile", apiRequest.getExtraParameter().getTmTaskId(), apiRequest.getExtraParameter().getTmActivityId(), "performer", isShared, isHistory, isSuperAdmin);
        executeContext.setFromAdsc(Boolean.valueOf(false));
        executeContext.setSourceType(apiRequest.getSourceType());
        executeContext.setAuthoredUser(new PcUiBotAuthoredUser().setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId()).setToken(apiRequest.getIamUserToken()));
        UiBotModel uiBotModel = Objects.equals(apiRequest.getExtraParameter().getTmActivityId(), "uibotManualTask") ? this.taskPageService.createManuaTaskPage(executeContext, apiRequest.getDataId()) : this.taskPageService.createPage(executeContext, apiRequest.getDataId(), apiRequest);
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

