/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import cn.hutool.core.text.CharSequenceUtil;
import com.digiwin.mobile.mobileuibot.abireport.ReportCategoryEnum;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.apposition.Apposition;
import com.digiwin.mobile.mobileuibot.core.component.apposition.AppositionData;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="uiBotModelBuildReportListStrategy")
public class UiBotModelBuildReportListStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildReportListStrategy.class);
    private static final Integer REPORT_SHOW_SIZE = 2;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private DigiwinAudcProxyService audcProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String clientId = apiRequest.getClientId();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        List appbarButtonList = uiBotModel.getAppbarButtonList();
        appbarButtonList.add(Button.createSearchReportName((String)locale, (LocaleService)this.localeService));
        List tmDataList = this.audcProxyService.getTmDataList(clientId, iamUserToken, tenantId, locale);
        for (DigiwinAtmcTmData digiwinAtmcTmData : tmDataList) {
            UiBotLayout layout = new UiBotLayout();
            String schema = UUIDUtil.getUuid();
            layout.setSchema(schema);
            layout.setType("RETRACYABLE");
            uiBotLayouts.add(layout);
            Retractable retractable = new Retractable();
            retractable.setTitle(digiwinAtmcTmData.getAppName());
            Apposition apposition = new Apposition();
            apposition.setPadding(Double.valueOf(12.0));
            apposition.setColumns(REPORT_SHOW_SIZE);
            ArrayList<AppositionData> data = new ArrayList<AppositionData>(tmDataList.size());
            apposition.setDatas(data);
            List content = retractable.getContent();
            if (!CollectionUtils.isEmpty((Collection)digiwinAtmcTmData.getBaseItemDtoList())) {
                for (DigiwinAtmcTmDataReport dataReport : digiwinAtmcTmData.getBaseItemDtoList()) {
                    AppositionData appositionData = new AppositionData();
                    if (!dataReport.isAllow().booleanValue()) continue;
                    appositionData.setComponentType("BUTTON");
                    if (!ReportCategoryEnum.STATEMENT.getValue().equals(dataReport.getCategory())) continue;
                    appositionData.setData((Object)BottomButtonDigiwinAthena.createTBBReportButton((String)apiRequest.getLocale(), (String)apiRequest.getIamUserToken(), (String)apiRequest.getTenantId(), (String)Optional.ofNullable(dataReport.getResCode()).filter(CharSequenceUtil::isNotEmpty).orElse(dataReport.getCode()), (String)dataReport.getName()));
                    data.add(appositionData);
                }
            }
            if (CollectionUtils.isEmpty(data)) continue;
            content.add(new BaseMobileComponentWrapper((BaseMobileComponent)apposition, "APPOSITION"));
            pageData.put((Object)schema, (Object)retractable);
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}

