/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBar;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.list.employeelist.EmployeeData;
import com.digiwin.mobile.mobileuibot.core.component.list.employeelist.EmployeeList;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="uiBotModelBuildApcProjectScheduleReportSubmitStrategy")
public class UiBotModelBuildApcProjectScheduleReportSubmitStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        uiBotModel = useMockData == false && !modelTypeShow ? this.doActually(pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout uiBotLayout : layoutList) {
            String schema = uiBotLayout.getSchema();
            switch (uiBotLayout.getType()) {
                case "MESSAGE_BAR": {
                    pageData.put((Object)schema, (Object)MessageBar.create((String)this.localeService.getLanguageValue(locale, "\u8bf7\u4ee5\u4e0b\u4eba\u5458\u4e8e\u300c\u5de5\u65f6\u56de\u62a5\u300d\u8fdb\u884c\u300c\u4eba\u5458\u4e0b\u7ebf\u300d\u64cd\u4f5c")));
                    break;
                }
                case "EMPLOYEE_LIST": {
                    pageData.put((Object)schema, (Object)this.buildEmployeeData(apiRequest));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttons = ModuleUtils.listMapToListObject((List)((List)pageData.get((Object)schema)), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)bottomButton.getName()));
                    }
                    pageData.put((Object)schema, (Object)buttons);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private EmployeeList buildEmployeeData(ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        EmployeeList employeeList = new EmployeeList().setTitle(this.localeService.getLanguageValue(locale, "\u62a5\u5de5\u5728\u7ebf\u4eba\u5458\u6e05\u5355"));
        JSONArray onlineReporterDetail = apiRequest.getRawData().getJSONArray("online_reporter_detail");
        if (null == onlineReporterDetail) {
            return employeeList;
        }
        ArrayList<EmployeeData> employeeDatas = new ArrayList<EmployeeData>();
        for (int i = 0; i < onlineReporterDetail.size(); ++i) {
            JSONArray subOpDetail = onlineReporterDetail.getJSONObject(i).getJSONArray("wo_sub_op_detail");
            if (null == subOpDetail) continue;
            for (int j = 0; j < subOpDetail.size(); ++j) {
                JSONArray reporterDetail = subOpDetail.getJSONObject(j).getJSONArray("reporter_detail");
                if (null == reporterDetail) continue;
                for (int k = 0; k < reporterDetail.size(); ++k) {
                    JSONObject object = reporterDetail.getJSONObject(k);
                    employeeDatas.add(new EmployeeData().setEmployeeNo(object.getString("reporter_no")).setEmployeeName(object.getString("reporter_name")));
                }
            }
        }
        return employeeList.setTotal(Integer.valueOf(employeeDatas.size())).setEmployeeDatas(employeeDatas);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return UiBotModel.emptyUibotModel((String)apiRequest.getLocale());
    }
}

