/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.DataSource;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmQueryPageDataReq;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmQueryPageDataResult;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionParameterMapping;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotQueryInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.QueryActionCreateService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UiBotMultipleDataSourceService {
    private static final Logger log = LoggerFactory.getLogger(UiBotMultipleDataSourceService.class);
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private QueryActionCreateService queryActionCreateService;

    public Map<String, Object> buildPageMultipleDataSourceData(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, UiBotPageLayout pageLayout, Map<String, Object> rawParam) {
        try {
            if (pageLayout == null) {
                return null;
            }
            return this.buildMultipleDataSourceData(cmptContext, executeContext, pageLayout.getDataSource(), rawParam);
        }
        catch (Exception e) {
            log.error("build page multiple datasource data error", (Throwable)e);
            return null;
        }
    }

    public Map<String, Object> buildCmptMultipleDataSourceData(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, DataSource dataSource, Map<String, Object> rawParam) {
        try {
            return this.buildMultipleDataSourceData(cmptContext, executeContext, dataSource, rawParam);
        }
        catch (Exception e) {
            log.error("build cmpt multiple datasource data error", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> buildMultipleDataSourceData(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, DataSource dataSource, Map<String, Object> rawParam) {
        if (!this.judgeIsMultipleDataSource(cmptContext, executeContext, dataSource).booleanValue()) {
            return null;
        }
        Map parameter = this.buildRequestParamter(executeContext, dataSource, rawParam);
        return this.dataQueryByActionId(executeContext, dataSource.getActionId(), parameter);
    }

    private Boolean judgeIsMultipleDataSource(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, DataSource dataSource) {
        if (BooleanUtils.isTrue((Boolean)cmptContext.getSkipMultiDataSource())) {
            return false;
        }
        if (Objects.equals(true, executeContext.getOpenDetailPage())) {
            return false;
        }
        if (dataSource == null || StringUtils.isEmpty((CharSequence)dataSource.getActionId())) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)executeContext.getMainDataSourceName()) || StringUtils.isEmpty((CharSequence)dataSource.getActionName())) {
            return false;
        }
        if (Objects.equals(dataSource.getActionName(), executeContext.getMainDataSourceName())) {
            return false;
        }
        return true;
    }

    private Map<String, Object> dataQueryByActionId(PcUiBotExecuteContext executeContext, String actionId, Map<String, Object> parameter) {
        DigiwinAtdmRequest request = DigiwinAtdmRequest.create((String)actionId, parameter, (Map)((Map)JsonUtil.objectToJavaObject((Object)executeContext, Map.class)), (Map)((Map)JsonUtil.objectToJavaObject((Object)executeContext.getBusinessUnit(), Map.class)), null, null, null);
        DigiwinAthenaApiResponse athenaApiResponse = this.digiwinAtdmProxyService.dataQueryByActionId(AppRequestContext.getContextEntity().getLocale(), AppRequestContext.getContextEntity().getIamUserToken(), JsonUtil.javaObjectToJsonString((Object)request), AppRequestContext.getContextEntity().getTenantId());
        if (athenaApiResponse == null) {
            return null;
        }
        return (Map)athenaApiResponse.getResponse();
    }

    private Map<String, Object> buildRequestParamter(PcUiBotExecuteContext executeContext, DataSource dataSource, Map<String, Object> rawParam) {
        List actionParams = dataSource.getActionParams();
        if (CollectionUtils.isEmpty((Collection)actionParams)) {
            return new HashMap<String, Object>();
        }
        Map bpmData = Optional.ofNullable(executeContext.getBpmData()).orElse(new HashMap());
        Map convertParas = this.setActionParameter(dataSource.getParas(), actionParams, bpmData, executeContext);
        dataSource.getParas().putAll(!CollectionUtils.isEmpty((Map)convertParas) ? convertParas : new HashMap());
        dataSource.setActionParams(new ArrayList());
        for (PcUiBotActionParameterMapping actionParam : actionParams) {
            if (!"ACTIVE_ROW".equals(actionParam.getType()) && !"TM_VARIABLE".equals(actionParam.getType())) continue;
            dataSource.getActionParams().add(actionParam);
        }
        this.processParameter(dataSource, rawParam, executeContext);
        return dataSource.getParas();
    }

    private Map<String, Object> setActionParameter(Map<String, Object> paraMap, List<PcUiBotActionParameterMapping> actionParameterMappings, Map<String, Object> bpmData, PcUiBotExecuteContext executeContext) {
        if (bpmData == null || CollectionUtils.isEmpty(actionParameterMappings)) {
            return paraMap;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        for (PcUiBotActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
            List list;
            int size;
            String[] sourcesNames;
            if (!"PROCESS_VARIABLE".equals(tmActionRequestParameter.getType())) continue;
            if (bpmData.containsKey(tmActionRequestParameter.getValue())) {
                paraMap.put(tmActionRequestParameter.getName(), bpmData.get(tmActionRequestParameter.getValue()));
                continue;
            }
            String value = tmActionRequestParameter.getValue();
            if (!StringUtils.isNotBlank((CharSequence)value) || (sourcesNames = value.split("\\.")).length != 2) continue;
            Object o = bpmData.get(sourcesNames[0]);
            if (o instanceof Map) {
                Object o1 = ((Map)o).get(sourcesNames[1]);
                String name = tmActionRequestParameter.getName();
                String[] targetNames = name.split("\\.");
                if (targetNames.length == 1) {
                    map.put(targetNames[0], o1);
                    continue;
                }
                if (targetNames.length != 2) continue;
                Map targetMap = (Map)map.computeIfAbsent(targetNames[0], e -> Maps.newHashMapWithExpectedSize((int)2));
                targetMap.put(targetNames[1], o1);
                continue;
            }
            if (!(o instanceof List) || (size = (list = (List)o).size()) <= 0) continue;
            String name = tmActionRequestParameter.getName();
            String[] targetNames = name.split("\\.");
            if (targetNames.length == 1) {
                for (Object o1 : list) {
                    if (!(o1 instanceof Map)) continue;
                    map.put(targetNames[0], ((Map)o1).get(sourcesNames[1]));
                }
                continue;
            }
            if (targetNames.length != 2) continue;
            for (int i = 0; i < size; ++i) {
                Map<String, Object> row;
                List targetList = (List)map.computeIfAbsent(targetNames[0], e -> Lists.newArrayListWithCapacity((int)size));
                if (targetList.size() < i + 1) {
                    row = new HashMap();
                    targetList.add(row);
                } else {
                    row = (Map)targetList.get(i);
                }
                Object o1 = list.get(i);
                Object targetValue = null;
                if (o1 instanceof Map) {
                    targetValue = ((Map)o1).get(sourcesNames[1]);
                }
                row.put(targetNames[1], targetValue);
            }
        }
        if (!map.isEmpty()) {
            paraMap.putAll(map);
        }
        for (PcUiBotActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
            if (!"RAW_ARRAY_PARAS".equals(tmActionRequestParameter.getType())) continue;
            String[] pathName = StringUtils.split((String)tmActionRequestParameter.getName(), (String)".");
            String paramKey = pathName[0];
            String paramNodeKey = pathName[1];
            String value = tmActionRequestParameter.getValue();
            List dataList = new ArrayList();
            if (null != paraMap.get(paramKey)) {
                dataList = (List)paraMap.get(paramKey);
            }
            Map<String, Object> dataP = new HashMap();
            if (!CollectionUtils.isEmpty(dataList)) {
                dataP = (Map)dataList.get(0);
            } else {
                dataList.add(dataP);
            }
            for (String o : bpmData.keySet()) {
                String dataKey = StringUtil.valueOf((Object)o);
                if (!dataKey.equals(value)) continue;
                dataP.put(paramNodeKey, bpmData.get(dataKey));
            }
            if (CollectionUtils.isEmpty(dataList)) continue;
            paraMap.put(paramKey, dataList);
        }
        for (PcUiBotActionParameterMapping tmActionRequestParameter : actionParameterMappings) {
            if (!"CONSTANT".equals(tmActionRequestParameter.getType()) && !"ACTIVE_ROW_CONSTANT".equals(tmActionRequestParameter.getType()) && !"SYSTEM".equals(tmActionRequestParameter.getType())) continue;
            this.setSinglePara(paraMap, tmActionRequestParameter, (JSONObject)JsonUtil.objectToJavaObject(bpmData, JSONObject.class), executeContext);
        }
        return paraMap;
    }

    private void setSinglePara(Map<String, Object> paraMap, PcUiBotActionParameterMapping tmActionRequestParameter, JSONObject bpmData, PcUiBotExecuteContext executeContext) {
        String conName = tmActionRequestParameter.getName();
        if (conName.contains(".")) {
            String[] conNames = conName.split("\\.");
            Object p = paraMap.get(conNames[0]);
            if (p instanceof JSONObject) {
                JSONObject pJson = (JSONObject)p;
                if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], (Object)executeContext.getAuthoredUser().getUserId());
                } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], (Object)this.digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                } else if ("[]".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(tmActionRequestParameter.getName(), new ArrayList());
                } else if (!this.convertAtmcSystemVariable(bpmData, (Map)pJson, conNames[1], tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], (Object)tmActionRequestParameter.getValue());
                }
            } else if (p instanceof Map) {
                Map pJson = (Map)p;
                if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], executeContext.getAuthoredUser().getUserId());
                } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], this.digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                } else if ("[]".equals(tmActionRequestParameter.getValue())) {
                    pJson.put(tmActionRequestParameter.getName(), new ArrayList());
                } else if (!this.convertAtmcSystemVariable(bpmData, pJson, conNames[1], tmActionRequestParameter.getValue())) {
                    pJson.put(conNames[1], tmActionRequestParameter.getValue());
                }
            } else if (p instanceof JSONArray) {
                JSONArray pJsonArray = (JSONArray)p;
                for (Object oJson : pJsonArray.toArray()) {
                    if (!(oJson instanceof JSONObject)) continue;
                    JSONObject pJson = (JSONObject)oJson;
                    if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                        pJson.put(conNames[1], (Object)executeContext.getAuthoredUser().getUserId());
                        continue;
                    }
                    if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                        pJson.put(conNames[1], (Object)this.digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
                        continue;
                    }
                    if ("[]".equals(tmActionRequestParameter.getValue())) {
                        pJson.put(tmActionRequestParameter.getName(), new ArrayList());
                        continue;
                    }
                    if (this.convertAtmcSystemVariable(bpmData, (Map)pJson, conNames[1], tmActionRequestParameter.getValue())) continue;
                    pJson.put(conNames[1], (Object)tmActionRequestParameter.getValue());
                }
            } else if (p instanceof List) {
                List pJsonArray = (List)p;
                for (Object o : pJsonArray) {
                    if (!(o instanceof Map)) continue;
                    Map pJson = (Map)o;
                    if ("[]".equals(tmActionRequestParameter.getValue())) {
                        pJson.put(tmActionRequestParameter.getName(), new ArrayList());
                        continue;
                    }
                    if (this.convertAtmcSystemVariable(bpmData, pJson, conNames[1], tmActionRequestParameter.getValue())) continue;
                    pJson.put(conNames[1], tmActionRequestParameter.getValue());
                }
            } else if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
                paraMap.put(conNames[1], executeContext.getAuthoredUser().getUserId());
            } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
                paraMap.put(conNames[1], this.digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
            } else if (!this.convertAtmcSystemVariable(bpmData, paraMap, conNames[1], tmActionRequestParameter.getValue())) {
                paraMap.put(conNames[1], null);
            }
        } else if ("{@SYSTEM_USER_ID}".equals(tmActionRequestParameter.getValue())) {
            paraMap.put(tmActionRequestParameter.getName(), executeContext.getAuthoredUser().getUserId());
        } else if ("{@SYSTEM_EMPLOYEE_ID}".equals(tmActionRequestParameter.getValue())) {
            paraMap.put(tmActionRequestParameter.getName(), this.digiwinEocProxyService.getEocId(executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getUserId()));
        } else if ("[]".equals(tmActionRequestParameter.getValue())) {
            paraMap.put(tmActionRequestParameter.getName(), new ArrayList());
        } else if (!this.convertAtmcSystemVariable(bpmData, paraMap, tmActionRequestParameter.getName(), tmActionRequestParameter.getValue())) {
            paraMap.put(tmActionRequestParameter.getName(), tmActionRequestParameter.getValue());
        }
    }

    private boolean convertAtmcSystemVariable(JSONObject bpmData, Map pJson, String addKeyName, String tmValue) {
        if (!StringUtils.isEmpty((CharSequence)tmValue) && bpmData != null && bpmData.containsKey((Object)"ATMC_GLOBAL_VARIABLE") && bpmData.get((Object)"ATMC_GLOBAL_VARIABLE") != null && StringUtils.startsWithIgnoreCase((CharSequence)tmValue, (CharSequence)"{@") && StringUtils.endsWithIgnoreCase((CharSequence)tmValue, (CharSequence)"}")) {
            tmValue = tmValue.substring(2, tmValue.length() - 1);
            JSONObject atmcData = bpmData.getJSONObject("ATMC_GLOBAL_VARIABLE");
            if (atmcData.containsKey((Object)tmValue)) {
                pJson.put(addKeyName, atmcData.get((Object)tmValue));
                return true;
            }
        }
        return false;
    }

    private void processParameter(DataSource dataSource, Map<String, Object> parameter, PcUiBotExecuteContext executeContext) {
        List requestFields;
        if (null == dataSource) {
            return;
        }
        PcUiBotApiMetadata metadata = this.queryActionCreateService.getMetadata(executeContext, dataSource.getActionId());
        List list = requestFields = metadata == null ? new ArrayList() : metadata.getRequestFields();
        if (parameter != null) {
            if (CollectionUtils.isEmpty((Collection)dataSource.getActionParams())) {
                for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                    dataSource.getParas().put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                }
            } else {
                Map realParas = dataSource.getParas();
                for (PcUiBotActionParameterMapping actionParam : dataSource.getActionParams()) {
                    Object o;
                    HashMap<String, Object> paraData;
                    JSONObject pJson;
                    Object pJsonArray;
                    Object pJson2;
                    Object p;
                    String[] conNames;
                    String conName;
                    Object paramValue;
                    if ("TM_VARIABLE".equals(actionParam.getType())) {
                        if (StringUtils.isNotBlank((CharSequence)actionParam.getValue())) {
                            Map variableMap = this.digiwinKnowledgeMapsProxyService.getMechanismParamValue(executeContext.getAuthoredUser().getToken(), executeContext.getTenantId(), executeContext.getLocale(), actionParam.getValue());
                            Object value = variableMap.get(actionParam.getValue());
                            actionParam.setValue(null != value ? String.valueOf(value) : null);
                        }
                        actionParam.setType("CONSTANT");
                    }
                    if ("ACTIVE_ROW".equals(actionParam.getType())) {
                        paramValue = parameter.get(actionParam.getValue());
                        if (actionParam.getTypeConverter() != null) {
                            try {
                                if ("stringToBooleanConverter".equals(actionParam.getTypeConverter())) {
                                    paramValue = new DefaultConversionService().convert((Object)paramValue.toString(), Boolean.TYPE);
                                } else if ("stringToNumberConverter".equals(actionParam.getTypeConverter())) {
                                    paramValue = new DefaultConversionService().convert((Object)paramValue.toString(), Integer.TYPE);
                                }
                            }
                            catch (Exception e) {
                                log.error("\u8f6c\u6362\u53c2\u6570\u5931\u8d25", (Throwable)e);
                            }
                        }
                        if ((conName = actionParam.getName()).contains(".")) {
                            conNames = conName.split("\\.");
                            p = realParas.get(conNames[0]);
                            if (p != null) {
                                Object paraData2;
                                if (p instanceof JSONObject) {
                                    pJson2 = (JSONObject)p;
                                    pJson2.put(conNames[1], paramValue);
                                    continue;
                                }
                                if (p instanceof Map) {
                                    pJson2 = (Map)p;
                                    pJson2.put(conNames[1], paramValue);
                                    continue;
                                }
                                if (p instanceof JSONArray) {
                                    pJsonArray = (JSONArray)p;
                                    for (Object oJson : pJsonArray.toArray()) {
                                        if (!(oJson instanceof JSONObject)) continue;
                                        pJson = (JSONObject)oJson;
                                        pJson.put(conNames[1], paramValue);
                                    }
                                    continue;
                                }
                                if (!(p instanceof List)) continue;
                                pJsonArray = (List)p;
                                if (pJsonArray.size() == 0) {
                                    paraData2 = new HashMap();
                                    if (paramValue == null) continue;
                                    paraData2.put(conNames[1], paramValue);
                                    pJsonArray.add(paraData2);
                                    continue;
                                }
                                paraData2 = pJsonArray.iterator();
                                while (paraData2.hasNext()) {
                                    Object o2 = paraData2.next();
                                    if (!(o2 instanceof Map)) continue;
                                    Map pJson3 = (Map)o2;
                                    if (paramValue == null) continue;
                                    pJson3.put(conNames[1], paramValue);
                                }
                                continue;
                            }
                            paraData = new HashMap<String, Object>();
                            if (paramValue != null) {
                                paraData.put(conNames[1], paramValue);
                            }
                            if (!this.requestIsArray(requestFields, conNames[0])) {
                                realParas.put(conNames[0], paraData);
                                continue;
                            }
                            o = new ArrayList();
                            if (MapUtils.isNotEmpty(paraData)) {
                                o.add(paraData);
                            }
                            realParas.put(conNames[0], o);
                            continue;
                        }
                        realParas.put(actionParam.getName(), paramValue);
                        continue;
                    }
                    if (!"ACTIVE_ROW_CONSTANT".equals(actionParam.getType()) && !"CONSTANT".equals(actionParam.getType())) continue;
                    paramValue = actionParam.getValue();
                    if (actionParam.getTypeConverter() != null) {
                        try {
                            if ("stringToBooleanConverter".equals(actionParam.getTypeConverter())) {
                                paramValue = new DefaultConversionService().convert((Object)paramValue.toString(), Boolean.TYPE);
                            } else if ("stringToNumberConverter".equals(actionParam.getTypeConverter())) {
                                paramValue = new DefaultConversionService().convert((Object)paramValue.toString(), Integer.TYPE);
                            }
                        }
                        catch (Exception e) {
                            log.error("\u8f6c\u6362\u53c2\u6570\u5931\u8d25", (Throwable)e);
                        }
                    }
                    if ((conName = actionParam.getName()).contains(".")) {
                        conNames = conName.split("\\.");
                        p = realParas.get(conNames[0]);
                        if (p != null) {
                            if (p instanceof JSONObject) {
                                pJson2 = (JSONObject)p;
                                pJson2.put(conNames[1], paramValue);
                                continue;
                            }
                            if (p instanceof Map) {
                                pJson2 = (Map)p;
                                pJson2.put(conNames[1], paramValue);
                                continue;
                            }
                            if (p instanceof JSONArray) {
                                pJsonArray = (JSONArray)p;
                                for (Object oJson : pJsonArray.toArray()) {
                                    if (!(oJson instanceof JSONObject)) continue;
                                    pJson = (JSONObject)oJson;
                                    pJson.put(conNames[1], paramValue);
                                }
                                continue;
                            }
                            if (!(p instanceof List)) continue;
                            pJsonArray = (List)p;
                            o = pJsonArray.iterator();
                            while (o.hasNext()) {
                                Object o3 = o.next();
                                if (!(o3 instanceof Map)) continue;
                                Map pJson4 = (Map)o3;
                                pJson4.put(conNames[1], paramValue);
                            }
                            continue;
                        }
                        paraData = new HashMap();
                        paraData.put(conNames[1], paramValue);
                        if (!this.requestIsArray(requestFields, conNames[0])) {
                            realParas.put(conNames[0], paraData);
                            continue;
                        }
                        o = new ArrayList();
                        o.add(paraData);
                        realParas.put(conNames[0], o);
                        continue;
                    }
                    realParas.put(actionParam.getName(), paramValue);
                }
            }
        } else {
            if (MapUtils.isEmpty((Map)dataSource.getParas())) {
                return;
            }
            if (CollectionUtils.isEmpty((Collection)dataSource.getActionParams())) {
                return;
            }
            Map realParas = dataSource.getParas();
            String conNames = ((PcUiBotActionParameterMapping)dataSource.getActionParams().get(0)).getName();
            if (conNames.contains(".")) {
                conNames = conNames.split("\\.")[0];
            }
            if (!this.requestIsArray(requestFields, conNames)) {
                if (!(realParas.get(conNames) instanceof List)) {
                    return;
                }
                List paras = (List)JsonUtil.objectToJavaObject(realParas.get(conNames), List.class);
                if (paras != null && paras.size() > 0) {
                    Map parasMapOne = (Map)JsonUtil.objectToJavaObject(paras.get(0), Map.class);
                    dataSource.getParas().put(conNames, parasMapOne);
                }
            }
        }
    }

    private boolean requestIsArray(List<PcUiBotMetadataField> requestFields, String conNames) {
        if (!CollectionUtils.isEmpty(requestFields)) {
            for (PcUiBotMetadataField metadataField : requestFields) {
                if (!conNames.equals(metadataField.getName()) || !"object".equals(metadataField.getDataType())) continue;
                return BooleanUtils.isTrue((Boolean)metadataField.isArray());
            }
        }
        return true;
    }

    public Map<String, Object> resetCmptMultipleDataSourceDataAndQueryInfo(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, DataSource dataSource, Map<String, Object> rawParam, PcUiBotQueryInfo queryInfo) {
        try {
            return this.resetMultipleDataSourceDataAndQueryInfo(cmptContext, executeContext, dataSource, rawParam, queryInfo);
        }
        catch (Exception e) {
            log.error("reset cmpt multiple datasource data and query info error", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> resetMultipleDataSourceDataAndQueryInfo(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, DataSource dataSource, Map<String, Object> rawParam, PcUiBotQueryInfo queryInfo) {
        if (!this.judgeIsMultipleDataSource(cmptContext, executeContext, dataSource).booleanValue()) {
            return null;
        }
        PcUiBotDataSourceSetDTO dataSourceSet = ZtbViewList.getCurrentDataSourceSet((ComponentContext)cmptContext, (DataSource)dataSource, (PcUiBotExecuteContext)executeContext);
        if (dataSourceSet == null || Objects.equals(dataSourceSet.getMainDatasource(), executeContext.getMainDataSourceName())) {
            return null;
        }
        DigiwinAtdmQueryPageDataResult dataResult = this.dataQueryByDataset(cmptContext, executeContext, dataSource, dataSourceSet, rawParam, queryInfo);
        if (dataResult == null) {
            return null;
        }
        dataResult.getPageInfo().setPageCountSize(dataResult.getPageCountSize());
        queryInfo.setPageInfo(dataResult.getPageInfo());
        return dataResult.getPageData();
    }

    private DigiwinAtdmQueryPageDataResult dataQueryByDataset(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, DataSource dataSource, PcUiBotDataSourceSetDTO dataSourceSet, Map<String, Object> rawParam, PcUiBotQueryInfo queryInfo) {
        Map parameter = this.buildRequestParamter(executeContext, dataSource, rawParam);
        DigiwinAtdmQueryPageDataReq bodyData = new DigiwinAtdmQueryPageDataReq().setDataSourceSet(dataSourceSet).setExecuteContext(executeContext).setPageInfo(this.getPageInfo(queryInfo)).setParameter(parameter).setSearchInfo(new ArrayList()).setSortInfo(new ArrayList());
        return this.digiwinAtdmProxyService.queryPageDataByDataset(AppRequestContext.getContextEntity().getLocale(), AppRequestContext.getContextEntity().getIamUserToken(), AppRequestContext.getContextEntity().getTenantId(), bodyData);
    }

    private PcUiBotPageInfo getPageInfo(PcUiBotQueryInfo queryInfo) {
        PcUiBotPageInfo pageInfo = new PcUiBotPageInfo();
        pageInfo.setPageNo(Integer.valueOf(1));
        pageInfo.setPageSize(Optional.ofNullable(queryInfo).map(PcUiBotQueryInfo::getPageInfo).map(PcUiBotPageInfo::getPageSize).orElse(50));
        return pageInfo;
    }
}

