/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern;

import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.webview.Webview;
import com.digiwin.mobile.mobileuibot.core.component.webview.WebviewButtonTipConfig;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildMyTaskDetailStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildMyTaskDetailV2Strategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern.PatternTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern.UiBotModelBuildCustomPatternTaskDetailStrategy;
import com.digiwin.mobile.mobileuibot.designer.DesignerService;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildCustomPatternTaskDetailStrategy")
public class UiBotModelBuildCustomPatternTaskDetailStrategy
implements UiBotModelBuildStrategy,
TaskDetailBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelBuildCustomPatternTaskDetailStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private SysEnvConfig sysEnvConfig;
    @Autowired
    private PageTaskRelationService pageTaskRelationService;
    @Autowired
    private DesignerService designerService;
    @Autowired
    private UiBotModelBuildMyTaskDetailStrategy uiBotModelBuildMyTaskDetailStrategy;
    @Autowired
    private PageSettingService pageSettingService;
    @Autowired
    private UiBotModelBuildMyTaskDetailV2Strategy uiBotModelBuildMyTaskDetailV2Strategy;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private ActivityFilterService activityFilterService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        apiRequest.getPatternTaskInfo().setPatternType(PatternTypeEnum.CUSTOM);
        StopWatch stopWatch = new StopWatch("BuildCustomPatternTaskDetail");
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(apiRequest);
        log.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        if (apiRequest.getExtraParameter() == null) {
            ApiExtraParameter apiExtraParameter = new ApiExtraParameter();
            DigiwinAtmcBacklogDetail backlogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getDataId());
            apiExtraParameter.setAppCode(backlogDetail.getAppCode());
            apiExtraParameter.setTmTaskId(backlogDetail.getTmTaskId());
            apiExtraParameter.setTmActivityId(backlogDetail.getTmActivityId());
            apiRequest.setExtraParameter(apiExtraParameter);
        }
        UiBotDesignerConfig uiBotDesignerConfig = this.designerService.initPatternTaskInfoWithUiBotDesigner(apiRequest, apiRequest.getExtraParameter().getTmTaskId(), apiRequest.getExtraParameter().getTmActivityId(), pageSetting.getSystemDefault(), apiRequest.getExtraParameter().getAppCode());
        switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$core$strategy$modelbuild$pattern$CustomPatternTaskTypeEnum[apiRequest.getPatternTaskInfo().getCustomPatternTaskType().ordinal()]) {
            case 1: {
                return this.buildJumpH5Page(pageSetting, apiRequest, uiBotDesignerConfig.getRawTaskActivityDefinition());
            }
            case 2: {
                return this.uiBotModelBuildMyTaskDetailV2Strategy.doActually(pageSetting, apiRequest);
            }
            case 3: {
                break;
            }
            case 4: {
                apiRequest.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name());
                pageSetting = this.pageSettingService.findById(apiRequest.getPageId());
                break;
            }
            case 5: {
                apiRequest.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name());
                pageSetting = this.pageSettingService.findById(apiRequest.getPageId());
                break;
            }
        }
        return this.uiBotModelBuildMyTaskDetailStrategy.doActually(pageSetting, apiRequest, stopWatch);
    }

    public UiBotModel buildJumpH5Page(PageSetting pageSetting, ApiRequest apiRequest, KnowledgeMapsActivityDefinition rawTaskActivityDefinition) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List uiBotLayouts = uiBotModel.getLayout();
        String tenantVersion = this.activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        List pageTaskRelationList = this.activityFilterService.listAthenaOfPageTaskRelations(apiRequest.getTenantId(), tenantVersion);
        for (UiBotLayout layout : uiBotLayouts) {
            switch (layout.getType()) {
                case "WEBVIEW": {
                    Webview webview = (Webview)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), Webview.class);
                    this.initSetting(webview, apiRequest.getLocale());
                    webview.setUrl(this.buildUrl(apiRequest, pageTaskRelationList, rawTaskActivityDefinition));
                    pageData.put((Object)layout.getSchema(), (Object)webview);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private String buildUrl(ApiRequest apiRequest, List<PageTaskRelation> pageTaskRelationList, KnowledgeMapsActivityDefinition rawTaskActivityDefinition) {
        String url = "";
        Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(pageTaskRelation -> {
            Boolean customPattern = pageTaskRelation.matchInPatternAndCategory(apiRequest.getExtraParameter().getTmPattern(), apiRequest.getExtraParameter().getTmCategory());
            boolean customPage = PageSettingIdPresetEnum.MOBILE_CUSTOM_PATTERN_TASK_DETAIL.name().equals(pageTaskRelation.getPageId());
            return customPattern != false && customPage;
        }).findFirst();
        if (!optPageTaskRelationPattern.isPresent()) {
            return url;
        }
        url = StringUtil.valueOf((Object)optPageTaskRelationPattern.get().getUrl());
        url = url.replaceAll("\\$\\{customTaskTemplateUrl}", this.sysEnvConfig.getCustomTaskTemplateUrl().replace("{appId}", this.getAppId(rawTaskActivityDefinition))).replaceAll("\\$\\{tmActivityId}", apiRequest.getExtraParameter().getTmActivityId()).replaceAll("\\$\\{tmTaskId}", apiRequest.getExtraParameter().getTmTaskId()).replaceAll("\\$\\{backlogId}", StringUtil.valueOf((Object)apiRequest.getDataId())).replaceAll("\\$\\{mobile_user_token}", apiRequest.getIamUserToken()).replaceAll("\\$\\{tenantId}", apiRequest.getTenantId());
        return url;
    }

    private String getAppId(KnowledgeMapsActivityDefinition rawTaskActivityDefinition) {
        String appId = "";
        if (null == rawTaskActivityDefinition) {
            return appId;
        }
        String appName = rawTaskActivityDefinition.getString("appName");
        String application = rawTaskActivityDefinition.getString("application");
        if (!StringUtils.hasLength((String)application)) {
            return appId;
        }
        return appId.toLowerCase();
    }

    private void initSetting(Webview webview, String locale) {
        WebviewButtonTipConfig buttonTipConfig;
        if (StringUtils.hasLength((String)webview.getTitle())) {
            webview.setTitle(this.localeService.getLanguageValue(locale, webview.getTitle()));
        }
        if (null != (buttonTipConfig = webview.getButtonTipConfig())) {
            webview.getButtonTipConfig().setText(this.localeService.getLanguageValue(locale, buttonTipConfig.getText()));
            Action action = buttonTipConfig.getAction();
            if (action != null) {
                if (StringUtils.hasLength((String)action.getJumpPageTitle())) {
                    action.setJumpPageTitle(this.localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                }
                if (StringUtils.hasLength((String)action.getToastMsg())) {
                    action.setToastMsg(this.localeService.getLanguageValue(locale, action.getToastMsg()));
                }
                if (StringUtils.hasLength((String)action.getRequestUrl())) {
                    action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
                }
            }
        }
        this.initButton(locale, webview.getButtonList());
    }

    private void initButton(String locale, List<BottomButtonDigiwinAthena> buttonList) {
        if (!CollectionUtils.isEmpty(buttonList)) {
            for (BottomButtonDigiwinAthena button : buttonList) {
                Action action;
                if (StringUtils.hasLength((String)button.getName())) {
                    button.setName(this.localeService.getLanguageValue(locale, button.getName()));
                }
                if (StringUtils.hasLength((String)button.getSubName())) {
                    button.setSubName(this.localeService.getLanguageValue(locale, button.getSubName()));
                }
                if ((action = button.getAction()) == null) continue;
                if (StringUtils.hasLength((String)action.getJumpPageTitle())) {
                    action.setJumpPageTitle(this.localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                }
                if (StringUtils.hasLength((String)action.getToastMsg())) {
                    action.setToastMsg(this.localeService.getLanguageValue(locale, action.getToastMsg()));
                }
                if (!StringUtils.hasLength((String)action.getRequestUrl())) continue;
                action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
            }
        }
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }

    public String getTaskDetailType() {
        return "CUSTOM";
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        return null;
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        String schema = "uiBot__activity";
        UiBotLayout layout = new UiBotLayout();
        layout.setType("TITLE_BODY");
        layout.setSchema(schema);
        uiBotModel.getLayout().add(layout);
        uiBotModel.getPageData().put((Object)schema, (Object)ModuleUtils.buildTitle((UiBotModel)pcUiBotModel, (Map)((Map)pcUiBotModel.getPageData().get((Object)schema)), (DigiwinAtmcBacklogDetail)((DigiwinAtmcBacklogDetail)args[0]), (ApiRequest)apiRequest, (Boolean)false, (Boolean)false));
        return uiBotModel;
    }
}

