/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.dashboard;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.mobile.mobileuibot.abireport.ReportCategoryEnum;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.apposition.Apposition;
import com.digiwin.mobile.mobileuibot.core.component.apposition.AppositionData;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntrance;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceDirectionEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceTitleStyleEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.dashboard.UiBotModelBuildDashboardV2Strategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAudcWorkbench;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.recommend.RecommendService;
import com.digiwin.mobile.mobileuibot.recommend.appentrancerecord.service.AppEntranceRecordService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uibotModelBuildDashboardStrategy")
public class UiBotModelBuildDashboardStrategy
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelBuildDashboardStrategy.class);
    private static final Integer REPORT_SHOW_SIZE = 2;
    private static final String DASHBOARD_VERSION_V2 = "v2";
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;
    @Autowired
    private RecommendService recommendService;
    @Autowired
    private DigiwinAudcProxyService audcProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private AppEntranceRecordService recordService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private UiBotModelBuildDashboardV2Strategy uiBotModelBuildDashboardV2Strategy;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildDashboard");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doBefore(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        log.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doBefore(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        if (Objects.equals(DASHBOARD_VERSION_V2, apiRequest.getDashboardVersion())) {
            return this.uiBotModelBuildDashboardV2Strategy.doActually(pageSetting, apiRequest, stopWatch);
        }
        return this.doActually(pageSetting, apiRequest, stopWatch);
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        Object uuid;
        PageSetting actualPageSetting = new PageSetting();
        actualPageSetting.setSystemDefault(pageSetting.getSystemDefault());
        actualPageSetting.setPageTitle(pageSetting.getPageTitle());
        UiBotPageData pageData = new UiBotPageData();
        ArrayList<UiBotLayout> uiBotLayouts = new ArrayList<UiBotLayout>();
        boolean hasReportModule = false;
        String tmSchema = UUIDUtil.getUuid();
        List customGroups = this.getTmReportList(tmSchema, apiRequest);
        for (Object customGroup : customGroups) {
            UiBotLayout customLayout = new UiBotLayout();
            customLayout.setType("CUSTOM_GROUP");
            customLayout.setSchema(tmSchema);
            uiBotLayouts.add(customLayout);
            pageData.put((Object)tmSchema, customGroup);
            hasReportModule = true;
        }
        List launchableProjectList = this.getLaunchableProject(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        for (AppEntrance appEntrance : launchableProjectList) {
            uuid = UUIDUtil.getUuid();
            CustomGroup customGroup = this.createCustomGroup((String)uuid, appEntrance);
            UiBotLayout customLayout = new UiBotLayout();
            customLayout.setType("CUSTOM_GROUP");
            customLayout.setSchema((String)uuid);
            uiBotLayouts.add(customLayout);
            pageData.put(uuid, (Object)customGroup);
        }
        List appEntranceList = this.recommendService.getAllAppEntrance(apiRequest.getIamUserToken(), apiRequest.getUserId(), apiRequest.getLocale());
        log.debug("apiRequest.getIsZtbDriver():" + apiRequest.getIsZtbDriver());
        Boolean flag = Optional.ofNullable(apiRequest.getIsZtbDriver()).orElse(false);
        for (AppEntrance appEntrance : appEntranceList) {
            List appList = appEntrance.getAppList();
            log.debug("appList:" + JSONUtil.toJsonStr((Object)appList));
            if (!CollectionUtils.isEmpty((Collection)appList)) {
                ArrayList<AppFunctionTouchable> newAppList = new ArrayList<AppFunctionTouchable>();
                for (AppFunctionTouchable touchable : appList) {
                    if ("srm-loading_srm-loading".equalsIgnoreCase(touchable.getId())) {
                        String url;
                        HashMap<String, String> params;
                        if (!flag.booleanValue() && (StrUtil.equals((CharSequence)touchable.getAction().getDataId(), (CharSequence)"shipper") || StrUtil.equals((CharSequence)touchable.getAction().getDataId(), (CharSequence)"receiver"))) {
                            touchable.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), touchable.getName()));
                            params = new HashMap<String, String>(1);
                            params.put("module_type", "2");
                            url = this.digiwinEspProxyService.getSrmLoadingWebUrl(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params) + "&userId=" + apiRequest.getUserId() + "&transportType=" + (StrUtil.equals((CharSequence)touchable.getAction().getDataId(), (CharSequence)"shipper") ? "1" : "2");
                            touchable.getAction().setRequestUrl(url);
                            newAppList.add(touchable);
                        }
                        if (!flag.booleanValue() || !StrUtil.equals((CharSequence)touchable.getAction().getDataId(), (CharSequence)"driver")) continue;
                        touchable.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), touchable.getName()));
                        params = new HashMap(1);
                        params.put("module_type", "2");
                        url = this.digiwinEspProxyService.getSrmLoadingWebUrl(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params) + "&userId=" + apiRequest.getUserId();
                        touchable.getAction().setRequestUrl(url);
                        newAppList.add(touchable);
                        continue;
                    }
                    if ("TipBiuBI_datasource".equalsIgnoreCase(touchable.getId())) {
                        if (StringUtils.hasLength((String)Optional.ofNullable(touchable.getAction()).map(Action::getRequestUrl).orElse(null))) {
                            String requestUrl = touchable.getAction().getRequestUrl().replaceAll("\\$\\{locale}", apiRequest.getLocale()).replaceAll("\\$\\{mobile_user_token}", apiRequest.getIamUserToken());
                            touchable.getAction().setRequestUrl(requestUrl);
                        }
                        newAppList.add(touchable);
                        continue;
                    }
                    if ("Athena_GLOBAL_INFORMATION".equals(touchable.getId())) {
                        if (!hasReportModule) continue;
                        newAppList.add(touchable);
                        continue;
                    }
                    newAppList.add(touchable);
                }
                log.debug("newAppList:" + JSONUtil.toJsonStr(newAppList));
                appEntrance.setAppList(newAppList);
            }
            String uuid2 = UUIDUtil.getUuid();
            CustomGroup customGroup = this.createCustomGroup(uuid2, appEntrance);
            UiBotLayout customLayout = new UiBotLayout();
            customLayout.setType("CUSTOM_GROUP");
            customLayout.setSchema(uuid2);
            uiBotLayouts.add(customLayout);
            pageData.put((Object)uuid2, (Object)customGroup);
        }
        if (null != apiRequest.getIsHavePreset() && apiRequest.getIsHavePreset().booleanValue()) {
            uuid = UUIDUtil.getUuid();
            CustomContent customContent = CustomContent.create((String)apiRequest.getLocale(), (String)apiRequest.getClientId(), (String)apiRequest.getIamUserToken(), (String)"", (String)(AppContext.getBaseUrl() + "/machine/preset/workBench/queryAppJob"), (boolean)true);
            UiBotLayout customContentLayout = new UiBotLayout();
            customContentLayout.setType("CUSTOM_CONTENT");
            customContentLayout.setSchema((String)uuid);
            uiBotLayouts.add(customContentLayout);
            pageData.put(uuid, (Object)customContent);
        }
        if (CollectionUtils.isEmpty(uiBotLayouts)) {
            return UiBotModel.createCustomContentWelcomeModel((String)apiRequest.getLocale());
        }
        UiBotModel actualPageModel = new UiBotModel(uiBotLayouts);
        actualPageModel.setPageBackgroudColor(pageSetting.getPageModel().getPageBackgroudColor());
        actualPageSetting.setPageModel(actualPageModel);
        stopWatch.start("Build Common Page Model");
        UiBotModel uiBotModel = this.uiBotModelBuildService.buildModel(actualPageSetting, (Object)pageData, Boolean.valueOf(true));
        stopWatch.stop();
        return uiBotModel;
    }

    private List<CustomGroup> getTmReportList(String schema, ApiRequest apiRequest) {
        int i;
        List tmDataList = this.audcProxyService.getTmDataList(apiRequest.getClientId(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (CollectionUtils.isEmpty((Collection)tmDataList)) {
            return Collections.emptyList();
        }
        ArrayList<AppositionData> data = new ArrayList<AppositionData>(REPORT_SHOW_SIZE);
        for (DigiwinAtmcTmData digiwinAtmcTmData : tmDataList) {
            if (CollectionUtils.isEmpty((Collection)digiwinAtmcTmData.getBaseItemDtoList())) continue;
            for (DigiwinAtmcTmDataReport dataReport : digiwinAtmcTmData.getBaseItemDtoList()) {
                AppositionData appositionData = new AppositionData();
                if (!dataReport.isAllow().booleanValue()) continue;
                appositionData.setComponentType("BUTTON");
                if (!ReportCategoryEnum.STATEMENT.getValue().equals(dataReport.getCategory())) continue;
                appositionData.setData((Object)BottomButtonDigiwinAthena.createTBBReportButton((String)apiRequest.getLocale(), (String)apiRequest.getIamUserToken(), (String)apiRequest.getTenantId(), (String)Optional.ofNullable(dataReport.getResCode()).filter(CharSequenceUtil::isNotEmpty).orElse(dataReport.getCode()), (String)dataReport.getName()));
                data.add(appositionData);
            }
        }
        if (data.size() == 0) {
            return Collections.emptyList();
        }
        boolean isMore = false;
        if (data.size() >= REPORT_SHOW_SIZE) {
            isMore = true;
        }
        CustomGroup customGroup = new CustomGroup();
        String customName = this.localeService.getLanguageValue(apiRequest.getLocale(), "\u62a5\u8868");
        customGroup.setName(customName);
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        CustomGroupContent content = new CustomGroupContent();
        ArrayList<UiBotLayout> contentUiBotLayouts = new ArrayList<UiBotLayout>(REPORT_SHOW_SIZE);
        UiBotPageData contentPageData = new UiBotPageData();
        UiBotLayout uiBotLayout = new UiBotLayout();
        uiBotLayout.setType("APPOSITION");
        uiBotLayout.setSchema(schema);
        Apposition apposition = new Apposition();
        apposition.setPadding(Double.valueOf(24.0));
        apposition.setColumns(REPORT_SHOW_SIZE);
        contentUiBotLayouts.add(uiBotLayout);
        List reportId = this.recordService.getReportAppIdListByUserId(apiRequest.getUserId(), apiRequest.getTenantId());
        ArrayList<Object> newData = new ArrayList<Object>(2);
        if (reportId != null && reportId.size() >= REPORT_SHOW_SIZE) {
            block2: for (i = 0; i < REPORT_SHOW_SIZE; ++i) {
                for (AppositionData appositionData : data) {
                    Button button = (Button)appositionData.getData();
                    if (reportId.get(i) == null || !((String)reportId.get(i)).contains(button.getId())) continue;
                    newData.add(appositionData);
                    continue block2;
                }
            }
        } else if (reportId != null && reportId.size() == 1) {
            block4: for (i = 0; i < reportId.size(); ++i) {
                for (int j = 0; j < data.size(); ++j) {
                    Button button = (Button)((AppositionData)data.get(j)).getData();
                    if (reportId.get(i) == null || !((String)reportId.get(i)).contains(button.getId())) continue;
                    newData.add(data.get(j));
                    if (j != 0) {
                        newData.add(data.get(0));
                        continue block4;
                    }
                    newData.add(data.get(1));
                    continue block4;
                }
            }
        }
        if (newData.size() < REPORT_SHOW_SIZE) {
            for (i = 0; i < REPORT_SHOW_SIZE; ++i) {
                if (data.size() <= i) continue;
                newData.add(data.get(i));
            }
        }
        apposition.setDatas(newData);
        contentPageData.put((Object)schema, (Object)apposition);
        content.setPageData(contentPageData);
        content.setLayout(contentUiBotLayouts);
        customGroup.setContent(content);
        customGroup.setUseExpand(Boolean.valueOf(false));
        HiddenConfig hiddenConfig = new HiddenConfig();
        customGroup.setHiddenConfig(hiddenConfig);
        if (isMore) {
            Button viewMoreButton = new Button();
            viewMoreButton.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), "\u67e5\u770b\u66f4\u591a") + ">");
            Action action = new Action();
            action.setJumpPageTitle(customName);
            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_REPORT_LIST.toString());
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            viewMoreButton.setAction(action);
            customGroup.setViewMore(viewMoreButton);
        }
        return Collections.singletonList(customGroup);
    }

    private List<AppEntrance> getLaunchableProject(String iamUserToken, String tenantId, String locale) {
        List accessibleLaunchableProjectList = this.projectService.getLaunchableProjectList(iamUserToken, tenantId, locale);
        if (CollectionUtils.isEmpty((Collection)accessibleLaunchableProjectList)) {
            return Collections.emptyList();
        }
        AppEntrance appEntrance = new AppEntrance();
        appEntrance.setTitle(this.localeService.getLanguageValue(locale, "\u624b\u52a8\u53d1\u8d77\u9879\u76ee"));
        appEntrance.setAppLayoutType(AppEntranceLayoutTypeEnum.EQUAL_RATION.getValue());
        appEntrance.setDirection(AppEntranceDirectionEnum.HORIZONTAL.getValue());
        appEntrance.setTitleStyle(AppEntranceTitleStyleEnum.TITLE_BOLD.getValue());
        List appList = accessibleLaunchableProjectList.stream().map(project -> {
            AppFunctionTouchable appFunctionTouchable = new AppFunctionTouchable();
            appFunctionTouchable.setId(project.getCode());
            if ("demo_so_athenaopt_mainline_project_0001".equals(project.getCode())) {
                appFunctionTouchable.setName(project.getName().substring(0, 4));
            } else {
                appFunctionTouchable.setName(project.getName());
            }
            appFunctionTouchable.setIconData(null);
            appFunctionTouchable.setIconColor(null);
            Action action = new Action();
            if (BooleanUtils.isTrue((Boolean)project.getIsDesigner())) {
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.toString());
                action.setJumpPageTitle(project.getName());
                HashMap<String, String> rawData = new HashMap<String, String>(2);
                rawData.put("project_introduce", project.getDesc());
                rawData.put("project_name", project.getName());
                rawData.put("dataId", project.getCreateSuffix());
                action.setRawData(rawData);
            } else if ("scan_freightage_start".equalsIgnoreCase(project.getCode())) {
                Action rawDataAction = new Action();
                rawDataAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                rawDataAction.setJumpPageTitle(project.getName());
                rawDataAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                rawDataAction.setDataId(project.getCreateSuffix());
                HashMap<String, String> rawData = new HashMap<String, String>(2);
                rawData.put("bizType", "ASN_CODE");
                rawData.put("action", (String)rawDataAction);
                action.setType(ActionTypeEnum.OPEN_NATIVE_SCAN.getValue());
                action.setRawData(rawData);
            } else {
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                action.setJumpPageTitle(project.getName());
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                action.setDataId(project.getCreateSuffix());
            }
            appFunctionTouchable.setAction(action);
            if ("demo_so_athenaopt_mainline_project_0001".equals(project.getCode())) {
                appFunctionTouchable.setImage("IMAGE_LaunchExcludedProject");
            } else {
                appFunctionTouchable.setImage("IMAGE_" + project.getCreateSuffix());
            }
            return appFunctionTouchable;
        }).collect(Collectors.toList());
        appEntrance.setAppList(appList);
        return Collections.singletonList(appEntrance);
    }

    private List<AppEntrance> getWorkbenchList(ApiRequest apiRequest) {
        ArrayList<AppEntrance> appEntranceList = new ArrayList<AppEntrance>();
        DigiwinAudcWorkbench audcWorkbench = this.audcProxyService.getWorkbenchList(apiRequest.getClientId(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (audcWorkbench == null) {
            return appEntranceList;
        }
        List dataList = audcWorkbench.getDataList();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return appEntranceList;
        }
        dataList.stream().flatMap(data -> data.getGroupList().stream()).forEach(group -> {
            AppEntrance appEntrance = new AppEntrance();
            appEntrance.setTitle(group.getGroupName());
            appEntrance.setAppLayoutType(AppEntranceLayoutTypeEnum.EQUAL_RATION.getValue());
            appEntrance.setDirection(AppEntranceDirectionEnum.HORIZONTAL.getValue());
            appEntrance.setTitleStyle(AppEntranceTitleStyleEnum.TITLE_BOLD.getValue());
            List appList = group.getBaseItemDtoList().stream().filter(DigiwinAtmcTmDataReport::isAllow).map(workbench -> {
                AppFunctionTouchable touchable = new AppFunctionTouchable();
                touchable.setId(workbench.getAppCode() + "_" + workbench.getCode());
                touchable.setName(workbench.getName());
                touchable.setIconData(null);
                touchable.setIconColor(null);
                touchable.setIconBase64(workbench.getIcon());
                Action action = new Action();
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_WORKBENCH_PAGE.toString());
                action.setJumpPageTitle(workbench.getName());
                action.setDataId(workbench.getCode());
                touchable.setAction(action);
                return touchable;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(appList)) {
                return;
            }
            appEntrance.setAppList(appList);
            appEntranceList.add(appEntrance);
        });
        return appEntranceList;
    }

    private CustomGroup createCustomGroup(String schema, AppEntrance appEntrance) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(appEntrance.getTitle());
        appEntrance.setTitle("");
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        CustomGroupContent content = new CustomGroupContent();
        ArrayList<UiBotLayout> contentUiBotLayouts = new ArrayList<UiBotLayout>();
        UiBotPageData contentPageData = new UiBotPageData();
        UiBotLayout uiBotLayout = new UiBotLayout();
        uiBotLayout.setType("APP_ENTRANCE");
        uiBotLayout.setSchema(schema);
        contentUiBotLayouts.add(uiBotLayout);
        contentPageData.put((Object)schema, (Object)appEntrance);
        content.setPageData(contentPageData);
        content.setLayout(contentUiBotLayouts);
        customGroup.setContent(content);
        customGroup.setHiddenConfig(new HiddenConfig());
        return customGroup;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = null;
        String data = FileUtil.readText((String)"static/dashboard.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

