/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.designer.uibot.page;

import com.digiwin.mobile.mobileuibot.designer.uibot.page.PageAction;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.PageDataFilter;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.PageDataState;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.PageFieldMetaData;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.PageSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class PageDataState
implements Serializable {
    private static final long serialVersionUID = 5909937240165593776L;
    public static final String OPERATION_OPENWINDOW_TYPE = "openwindow";
    public static final String OPERATION_EDITOR_TYPE = "editor";
    public static final String OPERATION_EDITOR_SINGLESELECT_SUBTYPE = "SELECT";
    private String code;
    private String title;
    private PageDataFilter dataFilter;
    private List<PcUiBotTmOperation> operations;
    private List<PageAction> submitActions;
    private PageFieldMetaData showMetadatas;
    private PageSubmitType submitType;
    private List<PcUiBotTmDataState.Layout> layout;

    public List<PcUiBotTmOperation> getOpenWindowOperationList() {
        if (CollectionUtils.isEmpty((Collection)this.operations)) {
            return Collections.emptyList();
        }
        return this.operations.stream().filter(pageTmOperation -> OPERATION_OPENWINDOW_TYPE.equalsIgnoreCase(pageTmOperation.getOperate())).collect(Collectors.toList());
    }

    public List<PcUiBotTmOperation> getEditorSelectOperationList() {
        if (CollectionUtils.isEmpty((Collection)this.operations)) {
            return Collections.emptyList();
        }
        return this.operations.stream().filter(pageTmOperation -> OPERATION_EDITOR_TYPE.equalsIgnoreCase(pageTmOperation.getOperate()) && null != pageTmOperation.getEditorDefine() && OPERATION_EDITOR_SINGLESELECT_SUBTYPE.equalsIgnoreCase(pageTmOperation.getEditorDefine().getType())).collect(Collectors.toList());
    }

    public static PageDataStateBuilder builder() {
        return new PageDataStateBuilder();
    }

    public String getCode() {
        return this.code;
    }

    public String getTitle() {
        return this.title;
    }

    public PageDataFilter getDataFilter() {
        return this.dataFilter;
    }

    public List<PcUiBotTmOperation> getOperations() {
        return this.operations;
    }

    public List<PageAction> getSubmitActions() {
        return this.submitActions;
    }

    public PageFieldMetaData getShowMetadatas() {
        return this.showMetadatas;
    }

    public PageSubmitType getSubmitType() {
        return this.submitType;
    }

    public List<PcUiBotTmDataState.Layout> getLayout() {
        return this.layout;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDataFilter(PageDataFilter dataFilter) {
        this.dataFilter = dataFilter;
    }

    public void setOperations(List<PcUiBotTmOperation> operations) {
        this.operations = operations;
    }

    public void setSubmitActions(List<PageAction> submitActions) {
        this.submitActions = submitActions;
    }

    public void setShowMetadatas(PageFieldMetaData showMetadatas) {
        this.showMetadatas = showMetadatas;
    }

    public void setSubmitType(PageSubmitType submitType) {
        this.submitType = submitType;
    }

    public void setLayout(List<PcUiBotTmDataState.Layout> layout) {
        this.layout = layout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageDataState)) {
            return false;
        }
        PageDataState other = (PageDataState)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        PageDataFilter this$dataFilter = this.getDataFilter();
        PageDataFilter other$dataFilter = other.getDataFilter();
        if (this$dataFilter == null ? other$dataFilter != null : !this$dataFilter.equals(other$dataFilter)) {
            return false;
        }
        List this$operations = this.getOperations();
        List other$operations = other.getOperations();
        if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
            return false;
        }
        List this$submitActions = this.getSubmitActions();
        List other$submitActions = other.getSubmitActions();
        if (this$submitActions == null ? other$submitActions != null : !((Object)this$submitActions).equals(other$submitActions)) {
            return false;
        }
        PageFieldMetaData this$showMetadatas = this.getShowMetadatas();
        PageFieldMetaData other$showMetadatas = other.getShowMetadatas();
        if (this$showMetadatas == null ? other$showMetadatas != null : !this$showMetadatas.equals(other$showMetadatas)) {
            return false;
        }
        PageSubmitType this$submitType = this.getSubmitType();
        PageSubmitType other$submitType = other.getSubmitType();
        if (this$submitType == null ? other$submitType != null : !this$submitType.equals(other$submitType)) {
            return false;
        }
        List this$layout = this.getLayout();
        List other$layout = other.getLayout();
        return !(this$layout == null ? other$layout != null : !((Object)this$layout).equals(other$layout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageDataState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        PageDataFilter $dataFilter = this.getDataFilter();
        result = result * 59 + ($dataFilter == null ? 43 : $dataFilter.hashCode());
        List $operations = this.getOperations();
        result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
        List $submitActions = this.getSubmitActions();
        result = result * 59 + ($submitActions == null ? 43 : ((Object)$submitActions).hashCode());
        PageFieldMetaData $showMetadatas = this.getShowMetadatas();
        result = result * 59 + ($showMetadatas == null ? 43 : $showMetadatas.hashCode());
        PageSubmitType $submitType = this.getSubmitType();
        result = result * 59 + ($submitType == null ? 43 : $submitType.hashCode());
        List $layout = this.getLayout();
        result = result * 59 + ($layout == null ? 43 : ((Object)$layout).hashCode());
        return result;
    }

    public String toString() {
        return "PageDataState(code=" + this.getCode() + ", title=" + this.getTitle() + ", dataFilter=" + this.getDataFilter() + ", operations=" + this.getOperations() + ", submitActions=" + this.getSubmitActions() + ", showMetadatas=" + this.getShowMetadatas() + ", submitType=" + this.getSubmitType() + ", layout=" + this.getLayout() + ")";
    }

    public PageDataState(String code, String title, PageDataFilter dataFilter, List<PcUiBotTmOperation> operations, List<PageAction> submitActions, PageFieldMetaData showMetadatas, PageSubmitType submitType, List<PcUiBotTmDataState.Layout> layout) {
        this.code = code;
        this.title = title;
        this.dataFilter = dataFilter;
        this.operations = operations;
        this.submitActions = submitActions;
        this.showMetadatas = showMetadatas;
        this.submitType = submitType;
        this.layout = layout;
    }

    public PageDataState() {
    }
}

