/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.designer.uibot.service;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequestComponent;
import com.digiwin.mobile.mobileuibot.api.ApiRequestComponentDataQuery;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.ComponentDataQueryResult;
import com.digiwin.mobile.mobileuibot.api.ComponentDslDataRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCardList;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmQueryPageDataReq;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmQueryPageDataResult;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionSearchInfoMapping;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UiBotComponentDataQueryService {
    private static final Logger log = LoggerFactory.getLogger(UiBotComponentDataQueryService.class);
    @Autowired
    private LocaleService localeService;
    @Resource
    private UiBotDesignerRenderService uiBotDesignerRenderService;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    public ApiResponse<ComponentDataQueryResult> componentDataQuery(ApiRequestComponentDataQuery query) {
        DigiwinAtdmQueryPageDataResult queryData = this.getQueryData(query);
        if (queryData == null) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(query.getLocale(), "\u67e5\u8be2\u6570\u636e\u5931\u8d25"));
        }
        ApiRawData rawData = this.getCurrentRawData(query);
        if (rawData == null) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(query.getLocale(), "\u5f53\u524d\u64cd\u4f5crawData\u4e3a\u7a7a"));
        }
        ApiResponse componentResponse = this.renderComponent(query, rawData, queryData.getPageData());
        if (componentResponse.isError()) {
            return ApiResponse.buildError((String)componentResponse.getMsg());
        }
        BaseMobileComponentWrapper componentWrapper = (BaseMobileComponentWrapper)componentResponse.getData();
        if (componentWrapper == null) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(query.getLocale(), "\u7ec4\u4ef6\u6e32\u67d3\u5931\u8d25"));
        }
        ComponentDataQueryResult result = new ComponentDataQueryResult();
        if (componentWrapper.getData() instanceof ZtbViewList) {
            ZtbViewList ztbViewList = (ZtbViewList)componentWrapper.getData();
            result.setData(CollectionUtils.isEmpty((Collection)ztbViewList.getData()) ? new ArrayList() : new ArrayList(ztbViewList.getData()));
        } else if (componentWrapper.getData() instanceof EditCardList) {
            EditCardList editCardList = (EditCardList)componentWrapper.getData();
            result.setData(CollectionUtils.isEmpty((Collection)editCardList.getContentGroup()) ? new ArrayList() : new ArrayList(editCardList.getContentGroup()));
        } else {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(query.getLocale(), "\u4e0d\u652f\u6301\u7684\u7ec4\u4ef6\u7c7b\u578b"));
        }
        PcUiBotPageInfo pageInfo = queryData.getPageInfo();
        pageInfo.setPageCountSize(queryData.getPageCountSize());
        result.setPageInfo(pageInfo);
        return ApiResponse.buildOK().setData((Object)result);
    }

    private DigiwinAtdmQueryPageDataResult getQueryData(ApiRequestComponentDataQuery query) {
        ApiRawData rawData = this.getCurrentRawData(query);
        if (rawData == null) {
            return null;
        }
        PcUiBotDataSourceSetDTO dataSourceSet = (PcUiBotDataSourceSetDTO)JsonUtil.objectToJavaObject((Object)rawData.get((Object)"dataSourceSet"), PcUiBotDataSourceSetDTO.class);
        PcUiBotExecuteContext executeContext = (PcUiBotExecuteContext)JsonUtil.objectToJavaObject((Object)rawData.get((Object)"executeContext"), PcUiBotExecuteContext.class);
        DigiwinAtdmQueryPageDataReq bodyData = new DigiwinAtdmQueryPageDataReq().setDataSourceSet(dataSourceSet).setExecuteContext(executeContext).setPageInfo(this.getPageInfo(query)).setParameter(new HashMap()).setSearchInfo(this.buildSearchInfo(query)).setSortInfo(new ArrayList());
        return this.digiwinAtdmProxyService.queryPageDataByDataset(query.getLocale(), query.getIamUserToken(), query.getTenantId(), bodyData);
    }

    private ApiRawData getCurrentRawData(ApiRequestComponentDataQuery query) {
        ApiRawData rawData = null;
        Integer queryType = query.getQueryType();
        if (ApiRequestComponentDataQuery.QueryType.PAGE.getValue().equals(queryType)) {
            rawData = query.getPaging().getRawData();
        } else if (ApiRequestComponentDataQuery.QueryType.SEARCH.getValue().equals(queryType)) {
            rawData = query.getSearch().getRawData();
        } else if (ApiRequestComponentDataQuery.QueryType.FILTER.getValue().equals(queryType)) {
            rawData = query.getFilter().getRawData();
        } else if (ApiRequestComponentDataQuery.QueryType.SORT.getValue().equals(queryType)) {
            ApiRequestComponentDataQuery.Sort sort = query.getSort();
        }
        return rawData;
    }

    private PcUiBotPageInfo getPageInfo(ApiRequestComponentDataQuery query) {
        PcUiBotPageInfo defaltPageInfo = new PcUiBotPageInfo();
        defaltPageInfo.setPageNo(Integer.valueOf(1));
        defaltPageInfo.setPageSize(Integer.valueOf(50));
        ApiRequestComponentDataQuery.Paging paging = query.getPaging();
        if (paging == null) {
            return defaltPageInfo;
        }
        PcUiBotPageInfo pageInfo = paging.getPageInfo();
        if (pageInfo == null) {
            return defaltPageInfo;
        }
        return pageInfo;
    }

    private List<Map<String, Object>> buildSearchInfo(ApiRequestComponentDataQuery query) {
        ArrayList<Map<String, Object>> searchInfoResult = new ArrayList<Map<String, Object>>();
        ApiRequestComponentDataQuery.Search search = query.getSearch();
        if (search != null) {
            List searchInfo = ((List)Optional.ofNullable(search.getSearchInfo()).orElse(new ArrayList())).stream().filter(e -> StringUtils.hasLength((String)e.getSearchOperator())).collect(Collectors.toList());
            if (StringUtils.hasLength((String)search.getCondition()) && !CollectionUtils.isEmpty(searchInfo)) {
                ArrayList searchList = new ArrayList();
                boolean multi = searchInfo.size() > 1;
                for (int i = 0; i < searchInfo.size(); ++i) {
                    HashMap<String, Object> searchMap = new HashMap<String, Object>();
                    if (multi) {
                        if (i == 0) {
                            searchMap.put("bracket", "(");
                            searchMap.put("logic", "OR");
                        } else if (i == searchInfo.size() - 1) {
                            searchMap.put("bracket", ")");
                        } else {
                            searchMap.put("logic", "OR");
                        }
                    }
                    searchMap.put("order", i + 1);
                    searchMap.put("search_field", ((PcUiBotActionSearchInfoMapping)searchInfo.get(i)).getSearchField());
                    searchMap.put("search_operator", ((PcUiBotActionSearchInfoMapping)searchInfo.get(i)).getSearchOperator());
                    searchMap.put("search_value", Lists.newArrayList((Object[])new String[]{search.getCondition()}));
                    searchList.add(searchMap);
                }
                searchInfoResult.addAll(searchList);
            }
        }
        return searchInfoResult;
    }

    private ApiResponse<BaseMobileComponentWrapper<BaseMobileComponent>> renderComponent(ApiRequestComponentDataQuery query, ApiRawData rawData, Map<String, Object> pageData) {
        ComponentDslDataRequest dslDataRequest = new ComponentDslDataRequest();
        dslDataRequest.setExecuteContext(rawData.get((Object)"executeContext"));
        dslDataRequest.setRawData((ApiRawData)JsonUtil.objectToJavaObject((Object)rawData.get((Object)"rawData"), ApiRawData.class));
        dslDataRequest.setPageId(rawData.getString("pageId"));
        dslDataRequest.setComponentType(rawData.getString("componentType"));
        dslDataRequest.setCmptUuid(rawData.getString("cmptUuid"));
        dslDataRequest.setData(pageData);
        dslDataRequest.setViewCode(rawData.getString("viewCode"));
        ApiRequestComponent apiRequestComponent = (ApiRequestComponent)JsonUtil.objectToJavaObject((Object)query, ApiRequestComponent.class);
        apiRequestComponent.setComponentData(dslDataRequest);
        return this.uiBotDesignerRenderService.buildComponentDsl(apiRequestComponent);
    }
}

