/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.device;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.device.enums.AuthTypeEnum;
import com.digiwin.mobile.mobileuibot.device.model.ApiRequsetDeviceBind;
import com.digiwin.mobile.mobileuibot.device.model.DeviceBindAuthResp;
import com.digiwin.mobile.mobileuibot.device.service.DeviceBindService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.DeviceBindAuth;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.DeviceBindConfig;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.DeviceBindResp;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/device/bind"})
public class DeviceBindController {
    private static final List<String> SUPPORT_OS_TYPE = Lists.newArrayList((Object[])new String[]{"android", "ios"});
    @Autowired
    private DeviceBindService deviceBindService;
    @Autowired
    private LocaleService localeService;

    @GetMapping(value={"/config"})
    public ApiResponse<DeviceBindConfig> deviceBindConfig(@RequestParam(value="iamUserToken") String iamUserToken) {
        return ApiResponse.buildOK((Object)this.deviceBindService.deviceBindConfig());
    }

    @GetMapping(value={"/list"})
    public ApiResponse<List<DeviceBindResp>> deviceBindList(@RequestParam(value="iamUserToken") String iamUserToken) {
        return ApiResponse.buildOK((Object)this.deviceBindService.deviceBindList(iamUserToken));
    }

    @PostMapping(value={"/auth"})
    public ApiResponse<DeviceBindAuthResp> deviceBindAuth(@Valid @RequestBody ApiRequsetDeviceBind requsetDeviceBind) {
        DeviceBindAuthResp result = new DeviceBindAuthResp().setType(AuthTypeEnum.PASS.getValue());
        if (this.notSupportOsType(requsetDeviceBind.getOsType())) {
            if (BooleanUtils.isTrue((Boolean)Optional.ofNullable(this.deviceBindService.deviceBindConfig()).map(DeviceBindConfig::getBindEnabled).orElse(false))) {
                result.setType(AuthTypeEnum.UNSUPPORT.getValue()).setMessage(this.localeService.getLanguageValue(requsetDeviceBind.getLocale(), "\u4e3a\u4fdd\u969c\u8d26\u53f7\u5b89\u5168\uff0c\u5f53\u524d\u79df\u6237\u5df2\u542f\u7528\u8bbe\u5907\u7ed1\u5b9a\u529f\u80fd\uff0c\u6682\u4e0d\u652f\u6301\u901a\u8fc7H5 \u6216 Web \u7aef\u767b\u5f55\u3002\n\u8bf7\u4f7f\u7528 APP \u6216\u684c\u9762\u5ba2\u6237\u7aef\u8bbf\u95ee"));
            }
            return ApiResponse.buildOK((Object)result);
        }
        DeviceBindAuth auth = this.deviceBindService.deviceBindAuth(requsetDeviceBind);
        if (auth == null || BooleanUtils.isTrue((Boolean)auth.getDeviceAuthorize())) {
            return ApiResponse.buildOK((Object)result);
        }
        Boolean bindEnabled = Optional.ofNullable(auth.getBindConfig()).map(DeviceBindConfig::getBindEnabled).orElse(false);
        Boolean bindDeviceStatus = Optional.ofNullable(auth.getBindConfig()).map(DeviceBindConfig::getBindDeviceStatus).orElse(false);
        if (BooleanUtils.isNotTrue((Boolean)bindEnabled)) {
            return ApiResponse.buildOK((Object)result);
        }
        if (BooleanUtils.isNotTrue((Boolean)bindDeviceStatus)) {
            result.setType(AuthTypeEnum.OPENED.getValue()).setMessage(this.localeService.getLanguageValue(requsetDeviceBind.getLocale(), "\u5f53\u524d\u8bbe\u5907\u5c1a\u672a\u548c\u5f53\u524d\u8d26\u53f7\u7ed1\u5b9a\uff01\n\u8bf7\u8054\u7cfb\u79df\u6237\u7ba1\u7406\u5458"));
            return ApiResponse.buildOK((Object)result);
        }
        if (BooleanUtils.isTrue((Boolean)auth.getAccountExistBinding())) {
            result.setType(AuthTypeEnum.OPENED.getValue()).setMessage(this.localeService.getLanguageValue(requsetDeviceBind.getLocale(), "\u5f53\u524d\u8d26\u53f7\u5df2\u88ab\u5176\u4ed6\u79fb\u52a8\u8bbe\u5907\u7ed1\u5b9a\uff01\n\u82e5\u60f3\u7ed1\u5b9a\u5f53\u524d\u8bbe\u5907\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0"));
            return ApiResponse.buildOK((Object)result);
        }
        if (BooleanUtils.isTrue((Boolean)auth.getDeviceExistBinding())) {
            result.setType(AuthTypeEnum.AUTO.getValue()).setMessage(this.localeService.getLanguageValue(requsetDeviceBind.getLocale(), "\u5f53\u524d\u8bbe\u5907\u5df2\u7ed1\u5b9a\u5176\u4ed6\u8d26\u53f7\uff01\n\u60a8\u53ef\u5c06\u5176\u4e0e\u5f53\u524d\u8d26\u53f7\u7ed1\u5b9a"));
            return ApiResponse.buildOK((Object)result);
        }
        result.setType(AuthTypeEnum.AUTO.getValue()).setMessage(this.localeService.getLanguageValue(requsetDeviceBind.getLocale(), "\u662f\u5426\u8981\u7ed1\u5b9a\u8be5\u8bbe\u5907"));
        return ApiResponse.buildOK((Object)result);
    }

    private boolean notSupportOsType(String osType) {
        return SUPPORT_OS_TYPE.stream().noneMatch(type -> type.equalsIgnoreCase(osType));
    }

    @PostMapping(value={"/auto"})
    public ApiResponse<Boolean> deviceBindAuto(@Valid @RequestBody ApiRequsetDeviceBind requsetDeviceBind) {
        if (this.notSupportOsType(requsetDeviceBind.getOsType())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(requsetDeviceBind.getLocale(), "\u4e3a\u4fdd\u969c\u8d26\u53f7\u5b89\u5168\uff0c\u5f53\u524d\u79df\u6237\u5df2\u542f\u7528\u8bbe\u5907\u7ed1\u5b9a\u529f\u80fd\uff0c\u6682\u4e0d\u652f\u6301\u901a\u8fc7H5 \u6216 Web \u7aef\u767b\u5f55\u3002\n\u8bf7\u4f7f\u7528 APP \u6216\u684c\u9762\u5ba2\u6237\u7aef\u8bbf\u95ee"));
        }
        this.deviceBindService.deviceBindAuto(requsetDeviceBind);
        return ApiResponse.buildOK();
    }
}

