/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.experience.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppEnvDeployAreaEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Document(collection="experienceRole")
public class ExperienceRole
implements Serializable {
    private static final long serialVersionUID = -2199790037720309364L;
    @Id
    private String id;
    private String roleId;
    private String roleName;
    private Map<String, String> roleNameMap;
    private String userId;
    private String password;
    private Integer sort;
    private Integer nanaAssistant;
    @JsonIgnore
    @JSONField(serialize=false)
    private Boolean valid;
    private Action action;
    @JsonIgnore
    @JSONField(serialize=false)
    private String type;
    @JsonIgnore
    @JSONField(serialize=false)
    private List<ExperienceRole> cn;
    @JsonIgnore
    @JSONField(serialize=false)
    private List<ExperienceRole> tw;

    public ExperienceRole() {
    }

    public ExperienceRole(String id, String roleId, String roleName, Integer sort) {
        this.id = id;
        this.roleId = roleId;
        this.roleName = roleName;
        this.sort = sort;
    }

    public ExperienceRole convert() {
        String envDeployArea = AppContext.getEnvDeployArea();
        if (AppEnvDeployAreaEnum.CN.name().equals(envDeployArea)) {
            this.convertByArea(this.cn);
        } else if (AppEnvDeployAreaEnum.TW.name().equals(envDeployArea)) {
            this.convertByArea(this.tw);
        }
        return this;
    }

    private void convertByArea(List<ExperienceRole> roles) {
        if (CollectionUtils.isEmpty(roles)) {
            return;
        }
        String envType = AppContext.getEnvType();
        Optional<ExperienceRole> optional = roles.stream().filter(r -> StringUtils.hasLength((String)r.getType()) && r.getType().equals(envType)).findFirst();
        if (!optional.isPresent()) {
            return;
        }
        ExperienceRole role = optional.get();
        if (null != role.getRoleId()) {
            this.roleId = role.getRoleId();
        }
        if (null != role.getRoleName()) {
            this.roleName = role.getRoleName();
        }
        if (null != role.getRoleNameMap()) {
            this.roleNameMap = role.getRoleNameMap();
        }
        if (null != role.getUserId()) {
            this.userId = role.getUserId();
        }
        if (null != role.getPassword()) {
            this.password = role.getPassword();
        }
        if (null != role.getSort()) {
            this.sort = role.getSort();
        }
        if (null != role.getNanaAssistant()) {
            this.nanaAssistant = role.getNanaAssistant();
        }
        if (null != role.getValid()) {
            this.valid = role.getValid();
        }
        if (null != role.getAction()) {
            if (null == this.action) {
                this.action = new Action();
            }
            this.action.convert(role.getAction());
        }
    }

    public String getId() {
        return this.id;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public Map<String, String> getRoleNameMap() {
        return this.roleNameMap;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getSort() {
        return this.sort;
    }

    public Integer getNanaAssistant() {
        return this.nanaAssistant;
    }

    public Boolean getValid() {
        return this.valid;
    }

    public Action getAction() {
        return this.action;
    }

    public String getType() {
        return this.type;
    }

    public List<ExperienceRole> getCn() {
        return this.cn;
    }

    public List<ExperienceRole> getTw() {
        return this.tw;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public void setRoleNameMap(Map<String, String> roleNameMap) {
        this.roleNameMap = roleNameMap;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public void setNanaAssistant(Integer nanaAssistant) {
        this.nanaAssistant = nanaAssistant;
    }

    @JsonIgnore
    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    @JsonIgnore
    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public void setCn(List<ExperienceRole> cn) {
        this.cn = cn;
    }

    @JsonIgnore
    public void setTw(List<ExperienceRole> tw) {
        this.tw = tw;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExperienceRole)) {
            return false;
        }
        ExperienceRole other = (ExperienceRole)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$sort = this.getSort();
        Integer other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
            return false;
        }
        Integer this$nanaAssistant = this.getNanaAssistant();
        Integer other$nanaAssistant = other.getNanaAssistant();
        if (this$nanaAssistant == null ? other$nanaAssistant != null : !((Object)this$nanaAssistant).equals(other$nanaAssistant)) {
            return false;
        }
        Boolean this$valid = this.getValid();
        Boolean other$valid = other.getValid();
        if (this$valid == null ? other$valid != null : !((Object)this$valid).equals(other$valid)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$roleId = this.getRoleId();
        String other$roleId = other.getRoleId();
        if (this$roleId == null ? other$roleId != null : !this$roleId.equals(other$roleId)) {
            return false;
        }
        String this$roleName = this.getRoleName();
        String other$roleName = other.getRoleName();
        if (this$roleName == null ? other$roleName != null : !this$roleName.equals(other$roleName)) {
            return false;
        }
        Map this$roleNameMap = this.getRoleNameMap();
        Map other$roleNameMap = other.getRoleNameMap();
        if (this$roleNameMap == null ? other$roleNameMap != null : !((Object)this$roleNameMap).equals(other$roleNameMap)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List this$cn = this.getCn();
        List other$cn = other.getCn();
        if (this$cn == null ? other$cn != null : !((Object)this$cn).equals(other$cn)) {
            return false;
        }
        List this$tw = this.getTw();
        List other$tw = other.getTw();
        return !(this$tw == null ? other$tw != null : !((Object)this$tw).equals(other$tw));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExperienceRole;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        Integer $nanaAssistant = this.getNanaAssistant();
        result = result * 59 + ($nanaAssistant == null ? 43 : ((Object)$nanaAssistant).hashCode());
        Boolean $valid = this.getValid();
        result = result * 59 + ($valid == null ? 43 : ((Object)$valid).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $roleId = this.getRoleId();
        result = result * 59 + ($roleId == null ? 43 : $roleId.hashCode());
        String $roleName = this.getRoleName();
        result = result * 59 + ($roleName == null ? 43 : $roleName.hashCode());
        Map $roleNameMap = this.getRoleNameMap();
        result = result * 59 + ($roleNameMap == null ? 43 : ((Object)$roleNameMap).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List $cn = this.getCn();
        result = result * 59 + ($cn == null ? 43 : ((Object)$cn).hashCode());
        List $tw = this.getTw();
        result = result * 59 + ($tw == null ? 43 : ((Object)$tw).hashCode());
        return result;
    }

    public String toString() {
        return "ExperienceRole(id=" + this.getId() + ", roleId=" + this.getRoleId() + ", roleName=" + this.getRoleName() + ", roleNameMap=" + this.getRoleNameMap() + ", userId=" + this.getUserId() + ", password=" + this.getPassword() + ", sort=" + this.getSort() + ", nanaAssistant=" + this.getNanaAssistant() + ", valid=" + this.getValid() + ", action=" + this.getAction() + ", type=" + this.getType() + ", cn=" + this.getCn() + ", tw=" + this.getTw() + ")";
    }
}

