/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.locale.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.cache.LuckyColaCache;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.locale.model.TranslateRequest;
import com.digiwin.mobile.mobileuibot.locale.model.TranslateResponse;
import com.digiwin.mobile.mobileuibot.locale.service.TranslateService;
import com.digiwin.service.ITranslateClientService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

@Service
public class TranslateServiceImpl
implements TranslateService {
    private static final Logger logger = LoggerFactory.getLogger(TranslateServiceImpl.class);
    private static final String ZH_CN_TO_ZH_TW = "zh2Hant";
    @Autowired
    private ITranslateClientService translateClient;
    @Autowired
    private SysEnvConfig sysEnvConfig;
    @Autowired
    private HttpService httpService;
    @Autowired
    private LuckyColaCache luckyColaCache;

    public String zh2Hant(String value) {
        try {
            String resultJsonStr = this.translateClient.translate((Object)value, new String[]{ZH_CN_TO_ZH_TW});
            JSONObject resultJson = JSONObject.parseObject((String)resultJsonStr);
            return (String)resultJson.get((Object)ZH_CN_TO_ZH_TW);
        }
        catch (Exception e) {
            e.printStackTrace();
            return value;
        }
    }

    public String zh2EN(String value) {
        if (!StringUtils.hasLength((String)value)) {
            return value;
        }
        String transalateValueByEn = this.luckyColaTransalateEn(value);
        if (!StringUtils.hasLength((String)transalateValueByEn)) {
            transalateValueByEn = this.baiduTransalateEn(value);
        }
        return transalateValueByEn;
    }

    public String getColaKey() {
        String url = "https://luckycola.com.cn/ai/getColaKey";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uid", this.sysEnvConfig.getLuckycolaUserId());
        param.put("appKey", this.sysEnvConfig.getLuckycolaAppKey());
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(param), Map.class);
        if (0 == (Integer)((Map)responseEntity.getBody()).get("code")) {
            Map data = (Map)((Map)responseEntity.getBody()).get("data");
            return (String)MapUtil.getOrDefault((Map)data, (String)"cola_key", (Object)"");
        }
        return "";
    }

    public String luckyColaTransalateEn(String value) {
        String transalateValue = "";
        try {
            String url = "https://luckycola.com.cn/tools/fanyi";
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("text", value);
            param.put("ColaKey", this.luckyColaCache.getColaKey());
            param.put("fromlang", "ZH");
            param.put("tolang", "EN");
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(param), Map.class);
            if (0 == (Integer)((Map)responseEntity.getBody()).get("code")) {
                Map data = (Map)((Map)responseEntity.getBody()).get("data");
                transalateValue = (String)MapUtil.getOrDefault((Map)data, (String)"dst", (Object)"");
            }
            if (-99 == (Integer)((Map)responseEntity.getBody()).get("code")) {
                logger.error("luckyCola colaKey is invalid, prepare refresh");
                String colaKey = this.getColaKey();
                this.luckyColaCache.putValue(colaKey);
            }
        }
        catch (Exception e) {
            logger.error("luckyCola translate cn to us failed");
        }
        return transalateValue;
    }

    public String baiduTransalateEn(String value) {
        String transalateValue = "";
        String appId = this.sysEnvConfig.getBaiduDeveloperAppId();
        String secretKey = this.sysEnvConfig.getBaiduDeveloperSecretKey();
        try {
            String uuid = UUIDUtil.getUuid();
            String secretData = appId + value + uuid + secretKey;
            String sign = DigestUtils.md5DigestAsHex((byte[])secretData.getBytes("utf-8"));
            StringBuffer baiduUrlBuffer = new StringBuffer();
            baiduUrlBuffer.append("http://api.fanyi.baidu.com/api/trans/vip/translate").append("?").append("q=").append(value).append("&from=zh").append("&to=en").append("&appid=").append(appId).append("&salt=").append(uuid).append("&sign=").append(sign);
            ResponseEntity responseEntity = this.httpService.doGet(baiduUrlBuffer.toString(), Map.class);
            Object transResultObj = ((Map)responseEntity.getBody()).get("trans_result");
            if (ObjectUtils.isNotEmpty(transResultObj)) {
                List transResult = (List)transResultObj;
                transalateValue = (String)MapUtil.getOrDefault((Map)((Map)transResult.get(0)), (String)"dst", (Object)"");
            }
        }
        catch (Exception e) {
            logger.error("baidu translate cn to us failed");
        }
        return transalateValue;
    }

    public TranslateResponse translate(TranslateRequest translateRequest) {
        TranslateResponse translateResponse = new TranslateResponse();
        String value = translateRequest.getContent();
        List convertTypes = translateRequest.getConvertTypes();
        if (CollectionUtils.isEmpty((Collection)convertTypes)) {
            return translateResponse;
        }
        ArrayList<String> types = new ArrayList<String>();
        if (convertTypes.contains(ZH_CN_TO_ZH_TW)) {
            types.add(ZH_CN_TO_ZH_TW);
        }
        if (convertTypes.contains("zh2Hans")) {
            types.add("zh2Hans");
        }
        if (CollectionUtils.isNotEmpty(types)) {
            try {
                String resultJsonStr = this.translateClient.translate((Object)value, types.toArray(new String[0]));
                JSONObject resultJson = JSONObject.parseObject((String)resultJsonStr);
                translateResponse.setZh2Hant(resultJson.getString(ZH_CN_TO_ZH_TW));
                translateResponse.setZh2Hans(resultJson.getString("zh2Hans"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (convertTypes.contains("zh2En")) {
            translateResponse.setZh2En(this.zh2EN(value));
        }
        return translateResponse;
    }
}

