/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.mock;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.environment.EnvironmentConfig;
import com.digiwin.mobile.mobileuibot.environment.EnvironmentConfigService;
import com.digiwin.mobile.mobileuibot.environment.config.EnvConfigModel;
import com.digiwin.mobile.mobileuibot.environment.config.EnvServerConfig;
import com.digiwin.mobile.mobileuibot.experience.model.ExperienceRoleIdEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mock.MockService;
import com.digiwin.mobile.mobileuibot.mock.enums.EnableEnum;
import com.digiwin.mobile.mobileuibot.mock.enums.MockDeployEnvironmentEnum;
import com.digiwin.mobile.mobileuibot.mock.enums.PublishEnum;
import com.digiwin.mobile.mobileuibot.mock.model.MockData;
import com.digiwin.mobile.mobileuibot.mock.request.MockVO;
import com.digiwin.mobile.mobileuibot.mock.v2.MockV2Model;
import com.digiwin.mobile.mobileuibot.mock.v2.MockV2Service;
import com.digiwin.mobile.mobileuibot.model.db1.Mock;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/mock"})
public class MockController {
    @Autowired
    private MockService mockService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private EnvironmentConfigService environmentConfigService;
    @Autowired
    private MockV2Service mockV2Service;
    @Autowired
    private SysEnvConfig sysEnvConfig;

    @PostMapping(value={"/data/post"})
    public ApiResponse mockPostData(HttpServletRequest request) {
        return this.handleMockData(request);
    }

    @GetMapping(value={"/data/get"})
    public ApiResponse mockGetData(HttpServletRequest request) {
        return this.handleMockData(request);
    }

    ApiResponse handleMockData(HttpServletRequest request) {
        String responseBodyStr;
        MockData mockData = (MockData)request.getAttribute("mockData");
        String roleCode = AppRequestContext.getContextEntity().getExperienceRoleId();
        if (Objects.equals(PageSettingIdPresetEnum.DASHBOARD.toString(), mockData.getPageId())) {
            roleCode = "PROJECT_MANAGER";
        }
        if (StringUtils.hasLength((String)(responseBodyStr = JsonUtil.javaObjectToJsonString((Object)mockData.getResponseBody(roleCode))))) {
            responseBodyStr = responseBodyStr.replaceAll("\\$\\{BASE_URL\\}", AppContext.getBaseUrl());
            responseBodyStr = responseBodyStr.replace("\"userId\":\"dcp001\"", "\"userId\":\"" + AppRequestContext.getContextEntity().getUserId() + "\"");
            responseBodyStr = responseBodyStr.replace("userId=dcp001", "userId=" + AppRequestContext.getContextEntity().getUserId());
            responseBodyStr = responseBodyStr.replace("/mobile/v1/uibot/component?clientId=454886b20b5b7f91&tenantId=DCP", "/mobile/v1/uibot/component?clientId=454886b20b5b7f91&tenantId=DCP&userId=" + AppRequestContext.getContextEntity().getUserId());
        }
        return ApiResponse.buildOK().setData(JsonUtil.jsonStringToObject((String)responseBodyStr, Object.class));
    }

    @PostMapping(value={"/list"})
    public ApiResponse<List<Mock>> mockList(@RequestBody MockVO vo) {
        String recordUserId = vo.getRecordUserId();
        boolean isMockSuperAdmin = this.checkIsMockSuperAdmin(recordUserId);
        List mockList = this.mockService.mockList(recordUserId, isMockSuperAdmin);
        String envDeployEnvironment = this.sysEnvConfig.getEnvDeployEnvironment();
        String description = MockDeployEnvironmentEnum.getDescriptionByKey((String)envDeployEnvironment);
        List<Mock> list = Optional.ofNullable(mockList).orElse(Collections.emptyList());
        list.forEach(mock -> {
            mock.setDeployArea(description);
            if (EnableEnum.YES.getValue().equals(mock.getEnableNana())) {
                mock.setMockRoleId(ExperienceRoleIdEnum.ATHENA_MOCK.getValue());
            }
        });
        return ApiResponse.buildOK().setData(list);
    }

    @PostMapping(value={"/select"})
    public ApiResponse<Mock> select(@RequestBody MockVO vo) {
        String mockId = vo.getMockId();
        String recordUserId = vo.getRecordUserId();
        String locale = vo.getLocale();
        Mock mock = this.mockService.selectByMockId(mockId, recordUserId);
        if (null == mock) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(locale, "mock\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        return ApiResponse.buildOK().setData((Object)mock);
    }

    @PostMapping(value={"/delete"})
    public ApiResponse<String> delete(@RequestBody MockVO vo) {
        String mockId = vo.getMockId();
        String recordUserId = vo.getRecordUserId();
        String locale = vo.getLocale();
        Mock mock = this.mockService.selectByMockId(mockId, recordUserId);
        if (null == mock) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(locale, "mock\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        if (PublishEnum.PUBLISH.getValue().equals(mock.getPublish())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(locale, "\u5df2\u53d1\u5e03\u72b6\u6001\u4e0d\u80fd\u5220\u9664"));
        }
        this.mockService.delete(mockId, recordUserId);
        return ApiResponse.buildOK();
    }

    @PostMapping(value={"/publish"})
    public ApiResponse<String> publish(@RequestBody MockVO vo) {
        String mockId = vo.getMockId();
        String recordUserId = vo.getRecordUserId();
        String locale = vo.getLocale();
        Integer publish = vo.getPublish();
        Mock mock = this.mockService.selectByMockId(mockId, recordUserId);
        if (null == mock) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(locale, "mock\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        if (null == PublishEnum.exist((Integer)publish)) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(locale, "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u53c2\u6570\u503c"));
        }
        this.mockService.publish(mockId, recordUserId, publish);
        return ApiResponse.buildOK();
    }

    @PostMapping(value={"/category/list"})
    public ApiResponse<List<String>> categoryList(@RequestBody MockVO vo) {
        String locale = vo.getLocale();
        List list = this.mockService.categoryList().stream().map(s -> this.localeService.getLanguageValue(locale, s)).collect(Collectors.toList());
        return ApiResponse.buildOK().setData(list);
    }

    @PostMapping(value={"/start/record"})
    public ApiResponse<MockVO> startRecord(@RequestBody MockVO vo) {
        if (StringUtils.hasLength((String)vo.getMockId())) {
            Mock mock = this.mockService.selectByMockId(vo.getMockId(), vo.getRecordUserId());
            if (null == mock) {
                return ApiResponse.buildError((String)this.localeService.getLanguageValue(vo.getLocale(), "mock\u8bb0\u5f55\u4e0d\u5b58\u5728"));
            }
            if (PublishEnum.PUBLISH.getValue().equals(mock.getPublish())) {
                return ApiResponse.buildError((String)this.localeService.getLanguageValue(vo.getLocale(), "\u5df2\u53d1\u5e03\u72b6\u6001\u4e0d\u80fd\u4fee\u6539"));
            }
        }
        return ApiResponse.buildOK().setData((Object)this.mockService.startRecord(vo));
    }

    private boolean checkIsMockSuperAdmin(String recordUserId) {
        List environmentConfigs = this.environmentConfigService.getEnvironmentConfig();
        if (CollectionUtils.isEmpty((Collection)environmentConfigs)) {
            return false;
        }
        EnvironmentConfig environmentConfig = (EnvironmentConfig)environmentConfigs.get(0);
        EnvConfigModel envConfigModel = environmentConfig.getConfig();
        if (null == envConfigModel) {
            return false;
        }
        EnvServerConfig serverConfig = envConfigModel.getServerConfig();
        if (null == serverConfig) {
            return false;
        }
        List mockSuperAdmins = serverConfig.getMockSuperAdmins();
        return mockSuperAdmins.contains(recordUserId);
    }

    @PostMapping(value={"/insertOrUpdateMockV2Data"})
    public ApiResponse<String> insertOrUpdateMockV2Data(@RequestBody MockV2Model mockV2Model) {
        try {
            this.mockV2Service.insertOrUpdateMockV2Data(mockV2Model);
        }
        catch (ServiceException e) {
            return ApiResponse.buildError((String)e.getMessage());
        }
        return ApiResponse.buildOK();
    }
}

