/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.mongodb.uc;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.mongodb.uc.UcTaskFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UcTaskFilterRepository {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="secondMongoTemplate")
    private MongoTemplate secondMongoTemplate;

    public List<UcTaskFilter> listValidInAthena(String version, Set<String> ucAppCodeList) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"source").is((Object)"athena")).addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)true)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version)).addCriteria((CriteriaDefinition)Criteria.where((String)"ucAppCode").in(ucAppCodeList));
        return this.mongoTemplate.find(query, UcTaskFilter.class).stream().filter(filter -> filter.validWithAppEnvType(AppContext.getEnvType())).collect(Collectors.toList());
    }

    public void deleteByCode(String appCode, String ucAppCode, String version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode)).addCriteria((CriteriaDefinition)Criteria.where((String)"ucAppCode").is((Object)ucAppCode)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        this.mongoTemplate.findAllAndRemove(query, UcTaskFilter.class);
        this.secondMongoTemplate.findAllAndRemove(query, UcTaskFilter.class);
    }

    public List<UcTaskFilter> selectByCode(String appCode, String ucAppCode, String version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode)).addCriteria((CriteriaDefinition)Criteria.where((String)"ucAppCode").is((Object)ucAppCode)).addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        List list = this.mongoTemplate.find(query, UcTaskFilter.class);
        return CollectionUtils.isEmpty((Collection)list) ? new ArrayList() : list;
    }

    public void batchInsert(List<UcTaskFilter> taskFilters) {
        if (CollectionUtils.isEmpty(taskFilters)) {
            return;
        }
        this.mongoTemplate.insertAll(taskFilters);
        this.secondMongoTemplate.insertAll(taskFilters);
    }
}

