/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.mysql.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.mapper.db1.OuterRequestRecordMapper;
import com.digiwin.mobile.mobileuibot.model.db1.OuterRequestRecord;
import com.digiwin.mobile.mobileuibot.mysql.service.OuterRequestRecordService;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OuterRequestRecordServiceImpl
extends ServiceImpl<OuterRequestRecordMapper, OuterRequestRecord>
implements OuterRequestRecordService {
    private static final Logger log = LoggerFactory.getLogger(OuterRequestRecordServiceImpl.class);
    @Autowired
    private OuterRequestRecordService outerRequestRecordService;
    @Autowired
    private OuterRequestRecordMapper outerRequestRecordMapper;
    @Autowired
    private SysEnvConfig sysEnvConfig;

    public void batchInsert(List<OuterRequestRecord> list) {
        if (this.sysEnvConfig.getSwitchOuterRequestRecord().booleanValue()) {
            this.outerRequestRecordService.saveBatch(list);
        }
    }

    public void clear(int reserveDays) {
        log.debug("\u7ebf\u7a0b{}:\u6e05\u7406outer_request_record\u8868\u6570\u636e -- begin", (Object)Thread.currentThread().getName());
        String currentDate = DateTimeUtil.getTodayTimeUseDefaultPattern();
        long totalDeleted = 0L;
        Long begin = System.currentTimeMillis();
        try {
            List idList;
            Timestamp requestTime = new Timestamp(LocalDate.now().minus(reserveDays, ChronoUnit.DAYS).atStartOfDay(ZoneOffset.ofHours(8)).toInstant().toEpochMilli());
            while (!CollectionUtils.isEmpty((Collection)(idList = this.outerRequestRecordMapper.selectIdByCondition(requestTime, 1000)))) {
                int result = this.outerRequestRecordMapper.batchDeleteByIds(idList);
                totalDeleted += (long)result;
            }
        }
        catch (Exception e) {
            log.error("\u7ebf\u7a0b{}:\u6e05\u7406outer_request_record\u8868\u6570\u636e error:", (Object)Thread.currentThread().getName(), (Object)e);
        }
        Long end = System.currentTimeMillis();
        log.debug("\u7ebf\u7a0b{}:\u6e05\u7406outer_request_record\u8868\u6570\u636e -- end,\u5f53\u524d\u65f6\u95f4:{},\u9884\u7559{}\u5929\u6570\u636e,\u5220\u9664{}\u6761\u6570\u636e,\u8017\u65f6{}s", new Object[]{Thread.currentThread().getName(), currentDate, reserveDays, totalDeleted, (end - begin) / 1000L});
    }
}

