/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.navigation;

import com.digiwin.mobile.mobileuibot.aiassistant.service.AiAssistantService;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.gptai.GptAiModel;
import com.digiwin.mobile.mobileuibot.gptai.GptAiService;
import com.digiwin.mobile.mobileuibot.navigation.BottomNavigation;
import com.digiwin.mobile.mobileuibot.navigation.Navigation;
import com.digiwin.mobile.mobileuibot.navigation.NavigationService;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.test.TestController;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/navigation"})
public class NavigationController {
    private static final Logger log = LoggerFactory.getLogger(NavigationController.class);
    private static int GPT_AI_HAVE_PERMISSION = 1;
    @Autowired
    private NavigationService navigationService;
    @Autowired
    private UiBotService uiBotService;
    @Autowired
    private DigiwinCacProxyService digiwinCacProxyService;
    @Autowired
    private GptAiService gptAiService;
    @Autowired
    private AiAssistantService aiAssistantService;

    @RequestMapping(value={"/nonSuperAdminNotSetAccount"}, method={RequestMethod.POST})
    public ApiResponse<String> nonSuperAdminNotSetAccount(@RequestBody ApiRequest apiRequest) {
        boolean b = this.uiBotService.nonSuperAdminNotSetAccount(apiRequest);
        if (b) {
            if (apiRequest.getLocale().equals("zh_CN")) {
                return ApiResponse.buildOK((String)"\u3010\u7528\u6237\u4e0e\u5458\u5de5\u672a\u5173\u8054\u3011\u6216\u3010\u5458\u5de5\u672a\u8bbe\u5b9a\u6240\u5c5e\u90e8\u95e8\u3011\uff0c\u8bf7\u8054\u7cfb\u8d85\u7ea7\u7ba1\u7406\u5458\u524d\u5f80\u4e91\u63a7\u5236\u53f0\u5b8c\u6210\u8bbe\u5b9a\u3002");
            }
            return ApiResponse.buildOK((String)"\u3010\u7528\u6236\u8207\u54e1\u5de5\u672a\u95dc\u806f\u3011\u6216\u3010\u54e1\u5de5\u672a\u8a2d\u5b9a\u6240\u5c6c\u90e8\u9580\u3011\uff0c\u8acb\u806f\u7e6b\u8d85\u7d1a\u7ba1\u7406\u54e1\u524d\u5f80\u96f2\u63a7\u5236\u53f0\u5b8c\u6210\u8a2d\u5b9a\u3002");
        }
        return ApiResponse.buildOK(null);
    }

    @RequestMapping(value={"/bottom"}, method={RequestMethod.POST})
    public ApiResponse<List<BottomNavigation>> getBottomNavigation(@RequestBody ApiRequest apiRequest) throws IOException {
        if (BooleanUtils.isTrue((Boolean)AppContext.getApiUrlSetting().getAgileDataPrivatization())) {
            String bottomNavigationString = FileUtil.readText((String)"./static/agiledata/agileData-privatization-bottom.json");
            List bottomNavigationList = (List)JsonUtil.jsonStringToObject((String)bottomNavigationString, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return ApiResponse.buildOK().setData((Object)bottomNavigationList);
        }
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (modelTypeShow) {
            return this.doMockData();
        }
        if (Objects.nonNull(apiRequest.getVersionDefault())) {
            Navigation navigation = (Navigation)JsonUtil.jsonStringToObject((String)this.getBottomNavigationMockDatanew(), Navigation.class);
            if (navigation != null) {
                List bottomNavigationList = navigation.getBottomNavigations();
                if (bottomNavigationList != null) {
                    ArrayList list = new ArrayList();
                    for (BottomNavigation bottomNavigation : bottomNavigationList) {
                        this.handleNanaAuthorizations(apiRequest, bottomNavigation, list);
                    }
                    if (CollectionUtils.isEmpty(list)) {
                        bottomNavigationList.removeIf(item -> PageSettingIdPresetEnum.GPT_AI.name().equals(item.getPageId()));
                    }
                }
                return ApiResponse.buildOK().setData((Object)navigation.getBottomNavigations());
            }
        } else {
            String locale = apiRequest.getLocale();
            if (!TestController.specialHandleSwitch() && this.uiBotService.nonSuperAdminNotSetAccount(apiRequest)) {
                return ApiResponse.buildOK().setData(Collections.emptyList());
            }
            Navigation navigation = !TestController.specialHandleSwitch() ? this.navigationService.findFirst() : (Navigation)JsonUtil.jsonStringToObject((String)this.getBottomNavigationMockData(), Navigation.class);
            if (navigation != null) {
                List bottomNavigationList = navigation.getBottomNavigations();
                if (bottomNavigationList != null) {
                    ArrayList list = new ArrayList();
                    for (BottomNavigation bottomNavigation : bottomNavigationList) {
                        this.handleNanaAuthorizations(apiRequest, bottomNavigation, list);
                        bottomNavigation.setPageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)bottomNavigation.getPageId()));
                        bottomNavigation.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)bottomNavigation.getPageId()));
                    }
                    if (CollectionUtils.isEmpty(list)) {
                        bottomNavigationList.removeIf(item -> PageSettingIdPresetEnum.GPT_AI.name().equals(item.getPageId()));
                    }
                }
                return ApiResponse.buildOK().setData((Object)navigation.getBottomNavigations());
            }
        }
        return ApiResponse.buildError();
    }

    private String getBottomNavigationMockDatanew() {
        return "{\n\t\"_id\": \"613b08f3530e71620cc5e111\",\n\t\"bottomNavigations\": [\n\t\t{\n\t\t\t\"name\": null,\n\t\t\t\"selectedIcon\": \"assets/svg/ic_msg_selected.svg\",\n\t\t\t\"unSelectedIcon\": \"assets/svg/ic_msg_unselected.svg\",\n\t\t\t\"pageId\": \"NOTIFICATION_PAGE\",\n\t\t\t\"pageTitle\": \"\u6d88\u606f\"\n\t\t},\n\t\t{\n\t\t\t\"name\": null,\n\t\t\t\"selectedIcon\": \"assets/svg/ic_home_selected.svg\",\n\t\t\t\"unSelectedIcon\": \"assets/svg/ic_home_unselected.svg\",\n\t\t\t\"pageId\": \"INDEX_PORTAL\",\n\t\t\t\"pageTitle\": \"\u9996\u9875\"\n\t\t},\n\t\t{\n\t\t\t\"name\": null,\n\t\t\t\"selectedIcon\": null,\n\t\t\t\"unSelectedIcon\": null,\n\t\t\t\"pageId\": \"GPT_AI\",\n\t\t\t\"pageTitle\": \"\u5a1c\u5a1c\"\n\t\t},\n\t\t{\n\t\t\t\"name\": null,\n\t\t\t\"selectedIcon\": \"assets/svg/ic_discover_selected.svg\",\n\t\t\t\"unSelectedIcon\": \"assets/svg/ic_discover_unselected.svg\",\n\t\t\t\"pageId\": \"MOBILE_ATHENA_FOUND_PAGE\",\n\t\t\t\"pageTitle\": \"\u53d1\u73b0\"\n\t\t},\n\t\t{\n\t\t\t\"name\": null,\n\t\t\t\"selectedIcon\": \"assets/svg/ic_my_selected.svg\",\n\t\t\t\"unSelectedIcon\": \"assets/svg/ic_my_unselected.svg\",\n\t\t\t\"pageId\": \"ME\",\n\t\t\t\"pageTitle\": \"\u6211\u7684\"\n\t\t}\n\t]\n}";
    }

    private String getBottomNavigationMockData() {
        return "{   \n    \"_id\" : \"613b08f3530e71620cc5e111\", \n    \"bottomNavigations\" : [\n        {\n            \"iconData\" : 59110, \n            \"name\" : \"${i18n-dj-mobile-NOTIFICATION_PAGE}\", \n            \"pageId\" : \"NOTIFICATION_PAGE\", \n            \"pageTitle\" : \"${i18n-dj-mobile-NOTIFICATION_PAGE}\", \n            \"showName\" : false\n        }, \n        {\n            \"iconData\" : 59111, \n            \"name\" : \"${i18n-dj-mobile-INDEX}\", \n            \"pageId\" : \"INDEX\", \n            \"pageTitle\" : \"${i18n-dj-mobile-INDEX}\", \n            \"showName\" : false\n        }, \n        {\n            \"iconData\" : 59111, \n            \"name\" : \"${i18n-dj-mobile-GPT_AI}\", \n            \"pageId\" : \"GPT_AI\", \n            \"pageTitle\" : \"${i18n-dj-mobile-GPT_AI}\", \n            \"showName\" : false\n        }, \n        {\n            \"iconData\" : 58939, \n            \"name\" : \"${i18n-dj-mobile-MOBILE_MY_TODO}\", \n            \"pageId\" : \"MOBILE_MY_TODO\", \n            \"pageTitle\" : \"${i18n-dj-mobile-MOBILE_MY_TODO}\", \n            \"showName\" : false, \n            \"calenderType\" : 2\n        }, \n        {\n            \"iconData\" : 59112, \n            \"name\" : \"${i18n-dj-mobile-DASHBOARD}\", \n            \"pageId\" : \"DASHBOARD\", \n            \"pageTitle\" : \"${i18n-dj-mobile-DASHBOARD}\", \n            \"showName\" : false\n        }\n    ]\n}\n";
    }

    private void handleNanaAuthorizations(ApiRequest apiRequest, BottomNavigation bottomNavigation, List<GptAiModel> list) {
        if (PageSettingIdPresetEnum.GPT_AI.name().equals(bottomNavigation.getPageId())) {
            try {
                int assistantCount = this.aiAssistantService.queryAssistantCount(apiRequest);
                if (assistantCount != 0) {
                    list.add(new GptAiModel());
                }
            }
            catch (Exception e) {
                log.error("query product buy status error:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private ApiResponse<List<BottomNavigation>> doMockData() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        List apiData = null;
        String data = FileUtil.readText((String)"static/appstore-use/navigation-bottom.json");
        if (null != data && !data.isEmpty()) {
            apiData = (List)JsonUtil.jsonStringToObject((String)data, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        return ApiResponse.buildOK().setData(apiData);
    }
}

