/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.notification;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationRemoveResp;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationSummary;
import com.digiwin.mobile.mobileuibot.notification.model.PushNotification;
import com.digiwin.mobile.mobileuibot.notification.service.NotificationService;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/notification"})
public class NotificationController {
    private static final String CREATE_NAME = "Athena";
    private static final Logger logger = LoggerFactory.getLogger(NotificationController.class);
    private final NotificationService notificationService;

    public NotificationController(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @RequestMapping(value={"/sort/list"}, method={RequestMethod.GET})
    public ApiResponse<List<NotificationSummary>> listNotificationSummary(@RequestParam(name="clientId") String clientId, @RequestParam(name="iamUserToken") String iamUserToken, @RequestParam(name="locale") String locale, Integer pageNum) throws IOException {
        List notificationSummaries = this.notificationService.listNotificationSummaries(clientId, iamUserToken, locale, pageNum, Integer.valueOf(10));
        if (notificationSummaries != null) {
            return ApiResponse.buildOK().setData((Object)notificationSummaries);
        }
        return ApiResponse.buildError();
    }

    /*
     * Enabled aggressive block sorting
     */
    @RequestMapping(value={"/send"}, method={RequestMethod.POST})
    @ResponseBody
    public String noticeSend(HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.error("\u51c6\u5907\u53d1\u9001\u901a\u77e5...\u8fdb\u5165noticeSend\u65b9\u6cd5...");
        String rawRequestData = RequestParameterUtil.getPostData((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        logger.error("\u63a5\u6536\u5230\u7684http body\u6570\u636e\u662f.. .{}", (Object)rawRequestData);
        Map requestMap = (Map)JsonUtil.jsonStringToObject((String)rawRequestData, Map.class);
        JSONObject root = new JSONObject();
        JSONObject stdData = new JSONObject();
        JSONObject execution = new JSONObject();
        JSONObject parameter = new JSONObject();
        root.put("std_data", (Object)stdData);
        stdData.put("execution", (Object)execution);
        execution.put("code", (Object)"0");
        execution.put("description", (Object)"Request Success");
        execution.put("sql_code", (Object)"0");
        stdData.put("parameter", (Object)parameter);
        parameter.put("send_datetime", (Object)new Date());
        if (requestMap == null) {
            logger.error("\u53d1\u9001\u901a\u77e5\u6d88\u606f\u5931\u8d25...\u6ca1\u6709\u8bf7\u6c42\u53c2\u6570");
            execution.put("code", (Object)"-1");
            execution.put("description", (Object)"No Request Parameter.");
            execution.put("sql_code", (Object)"0");
            stdData.put("parameter", (Object)parameter);
            parameter.put("send_datetime", (Object)"");
            return root.toString();
        }
        Map rootMap = (Map)requestMap.get("std_data");
        Map paramMap = (Map)rootMap.get("parameter");
        if (paramMap != null && !paramMap.isEmpty()) {
            String outerTenantId = (String)paramMap.get("outer_tenant_id");
            String outerTenantSid = (String)paramMap.get("outer_tenant_sid");
            String outerUserId = (String)paramMap.get("outer_user_id");
            String creatorName = (String)paramMap.get("creator_name");
            if (!StringUtils.hasLength((String)outerTenantId) && !StringUtils.hasLength((String)outerTenantSid)) {
                execution.put("code", (Object)"-1");
                execution.put("description", (Object)"\u8bf7\u8f93\u5165\u79df\u6237Id\u6216\u8005SID");
                parameter.put("send_datetime", (Object)"");
                return root.toString();
            }
            if (!StringUtils.hasLength((String)outerUserId)) {
                execution.put("code", (Object)"-1");
                execution.put("description", (Object)"\u8bf7\u8f93\u5165\u7528\u6237ID");
                parameter.put("send_datetime", (Object)"");
                return root.toString();
            }
            if (!StringUtils.hasLength((String)creatorName)) {
                creatorName = CREATE_NAME;
            }
            String content = (String)paramMap.get("content");
            String detailUrl = (String)paramMap.get("detail_url");
            Map detail = (Map)paramMap.get("detail");
            String locale = (String)paramMap.get("locale");
            String title = (String)paramMap.get("title");
            List label = (List)paramMap.get("label");
            logger.error("\u53d1\u9001\u6d88\u606f\u7ed9\uff1a{}", (Object)outerUserId);
            PushNotification push = new PushNotification();
            push.setContent(content);
            push.setTitle(title);
            push.setDetail(detail);
            push.setTenantId(outerTenantId);
            push.setUrl(detailUrl);
            push.setApnsProduction(Boolean.valueOf(true));
            this.notificationService.pushNotificationToUserId(outerUserId, outerTenantId, push, creatorName, label);
            return root.toString();
        }
        logger.error("\u53d1\u9001\u901a\u77e5\u6d88\u606f\u5931\u8d25...\u8bf7\u6c42\u53c2\u6570\u5185\u5bb9\u4e0d\u6b63\u786e");
        execution.put("code", (Object)"-1");
        execution.put("description", (Object)"Parameter node invalid.");
        execution.put("sql_code", (Object)"0");
        stdData.put("parameter", (Object)parameter);
        parameter.put("send_datetime", (Object)"");
        return root.toString();
    }

    @GetMapping(value={"/remove"})
    public ApiResponse<NotificationRemoveResp> oneClickRemove() {
        return ApiResponse.buildOK((Object)this.notificationService.oneClickRemove());
    }
}

