/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.ocr;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.image.ImageUtil;
import com.digiwin.mobile.mobileuibot.ocr.model.ApiRequestOcr;
import com.digiwin.mobile.mobileuibot.ocr.model.OcrCarNumberResult;
import com.digiwin.mobile.mobileuibot.proxy.ocr.service.OcrService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/mobile/v1/ocr"})
public class OcrController {
    @Autowired
    private OcrService ocrService;

    @RequestMapping(value={"/ocrCarNumber"}, method={RequestMethod.POST})
    public ApiResponse<OcrCarNumberResult> ocrCarNumber(ApiRequestOcr request) throws IOException {
        OcrCarNumberResult ocrCarNumberResult = null;
        MultipartFile multipartFile = request.getFile();
        byte[] imageBytes = multipartFile.getBytes();
        String base64EncoderImg = ImageUtil.encodeImage((byte[])imageBytes);
        ocrCarNumberResult = this.ocrService.getZtbOcrCarNumber(request, base64EncoderImg);
        if ("-1".equals(ocrCarNumberResult.getCode()) || "-2".equals(ocrCarNumberResult.getCode())) {
            ocrCarNumberResult.getResultMap().put("hasPrompt", true);
            ocrCarNumberResult.getResultMap().put("errorMessage", ocrCarNumberResult.getErrorMsg());
        }
        return ApiResponse.buildOK().setData((Object)ocrCarNumberResult.getResultMap());
    }
}

